/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.mockserver.client.ClientException;
import org.mockserver.client.MockServerClient;
import org.mockserver.client.MockServerEventBus;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.action.ExpectationCallback;
import org.mockserver.mock.action.ExpectationForwardCallback;
import org.mockserver.mock.action.ExpectationResponseCallback;
import org.mockserver.model.Delay;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpObject;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.websocket.WebSocketClient;
import org.mockserver.websocket.WebSocketException;

public class ForwardChainExpectation {
    private final MockServerClient mockServerClient;
    private final Expectation expectation;
    private final Semaphore availableWebSocketCallbackRegistrations;

    ForwardChainExpectation(MockServerClient mockServerClient, Expectation expectation, Semaphore availableWebSocketCallbackRegistrations) {
        this.mockServerClient = mockServerClient;
        this.expectation = expectation;
        this.availableWebSocketCallbackRegistrations = availableWebSocketCallbackRegistrations;
    }

    public void respond(HttpResponse httpResponse) {
        this.expectation.thenRespond(httpResponse);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void respond(HttpTemplate httpTemplate) {
        this.expectation.thenRespond(httpTemplate);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void respond(HttpClassCallback httpClassCallback) {
        this.expectation.thenRespond(httpClassCallback);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void respond(ExpectationResponseCallback expectationResponseCallback) {
        this.expectation.thenRespond(new HttpObjectCallback().withClientId(this.registerWebSocketClient((ExpectationCallback)expectationResponseCallback)));
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void respond(ExpectationResponseCallback expectationResponseCallback, Delay delay) {
        this.expectation.thenRespond((HttpObjectCallback)new HttpObjectCallback().withClientId(this.registerWebSocketClient((ExpectationCallback)expectationResponseCallback)).withDelay(delay));
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(HttpForward httpForward) {
        this.expectation.thenForward(httpForward);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(HttpTemplate httpTemplate) {
        this.expectation.thenForward(httpTemplate);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(HttpClassCallback httpClassCallback) {
        this.expectation.thenForward(httpClassCallback);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(ExpectationForwardCallback expectationForwardCallback) {
        this.expectation.thenForward(new HttpObjectCallback().withClientId(this.registerWebSocketClient((ExpectationCallback)expectationForwardCallback)));
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(ExpectationForwardCallback expectationForwardCallback, Delay delay) {
        this.expectation.thenForward((HttpObjectCallback)new HttpObjectCallback().withClientId(this.registerWebSocketClient((ExpectationCallback)expectationForwardCallback)).withDelay(delay));
        this.mockServerClient.sendExpectation(this.expectation);
    }

    private <T extends HttpObject> String registerWebSocketClient(ExpectationCallback<T> expectationCallback) {
        try {
            final WebSocketClient webSocketClient = new WebSocketClient(this.availableWebSocketCallbackRegistrations);
            Future register = webSocketClient.registerExpectationCallback(expectationCallback, this.mockServerClient.getEventLoopGroup(), this.mockServerClient.remoteAddress(), this.mockServerClient.contextPath(), this.mockServerClient.isSecure());
            MockServerEventBus.getInstance().subscribe(new MockServerEventBus.SubscriberHandler(){

                @Override
                public void handle() {
                    webSocketClient.stopClient();
                }
            }, MockServerEventBus.EventType.STOP, MockServerEventBus.EventType.RESET);
            return (String)register.get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof WebSocketException) {
                throw new ClientException(e.getCause().getMessage(), e);
            }
            throw new ClientException("Unable to retrieve client registration id", e);
        }
    }

    public void forward(HttpOverrideForwardedRequest httpOverrideForwardedRequest) {
        this.expectation.thenForward(httpOverrideForwardedRequest);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void error(HttpError httpError) {
        this.expectation.thenError(httpError);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    @VisibleForTesting
    Expectation getExpectation() {
        return this.expectation;
    }
}

