/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.testing.integration.mock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Test;
import org.mockserver.character.Character;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.file.FileReader;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.OpenAPIExpectation;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.Cookie;
import org.mockserver.model.Delay;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpRequestModifier;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpResponseModifier;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.model.HttpTemplate;
import org.mockserver.model.JsonBody;
import org.mockserver.model.MediaType;
import org.mockserver.model.Not;
import org.mockserver.model.NottableString;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.model.Parameter;
import org.mockserver.model.RegexBody;
import org.mockserver.model.RequestDefinition;
import org.mockserver.model.SocketAddress;
import org.mockserver.model.StringBody;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.testing.integration.callback.PrecannedTestExpectationForwardCallbackRequest;
import org.mockserver.testing.integration.callback.PrecannedTestExpectationForwardCallbackRequestAndResponse;
import org.mockserver.testing.integration.callback.PrecannedTestExpectationResponseCallback;
import org.mockserver.testing.integration.mock.AbstractMockingIntegrationTestBase;
import org.mockserver.uuid.UUIDService;
import org.mockserver.validator.jsonschema.JsonSchemaValidator;
import org.mockserver.verify.VerificationTimes;
import org.slf4j.event.Level;

public abstract class AbstractBasicMockingIntegrationTest
extends AbstractMockingIntegrationTestBase {
    protected HttpResponse localNotFoundResponse() {
        return HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase());
    }

    @Test
    public void shouldReturnResponseWithOnlyBody() {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)HttpRequest.request()).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("")), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request()).thenRespond(HttpResponse.response().withBody("some_body"))));
    }

    @Test
    public void shouldReturnResponseInHttpAndHttps() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_path"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseWithOnlyStatusCode() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_path"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingSchemaPathAndSchemaMethod() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethodSchema("{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"^PO[A-Z]{2}$\"" + Character.NEW_LINE + "}").withPathSchema("{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"some_[a-z]{4}$\"" + Character.NEW_LINE + "}")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_other_path")).withMethod("POST"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("PUT"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingSchemaPathVariable() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath("/some/path/{variableOne}/{variableTwo}").withPathParameters(new Parameter[]{Parameter.schemaParam((String)"variableO[a-z]{2}", (String[])new String[]{"{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"variableOneV[a-z]{4}$\"" + Character.NEW_LINE + "}"}), Parameter.schemaParam((String)"variableTwo", (String[])new String[]{"{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"variableTwoV[a-z]{4}$\"" + Character.NEW_LINE + "}"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/path/variableOneValue/variableTwoValue")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/other/path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/path/variableOneValue/variableTwoOtherValue")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/path/variableOneOtherValue/variableTwoValue")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingStringBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)StringBody.exact((String)"some_random_body"))).respond(HttpResponse.response().withBody("some_string_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_string_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_path")).withBody("some_random_body"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingSchemaHeaderCookieAndParameter() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader(Header.schemaHeader((String)"headerName", (String[])new String[]{"{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"^headerVal[a-z]{2}$\"" + Character.NEW_LINE + "}"})).withQueryStringParameter(Parameter.schemaParam((String)"parameterName", (String[])new String[]{"{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"^parameterVal[a-z]{2}$\"" + Character.NEW_LINE + "}"})).withCookie(Cookie.schemaCookie((String)"cookieName", (String)("{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"^cookieVal[a-z]{2}$\"" + Character.NEW_LINE + "}")))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path?parameterName=parameterValue")).withHeader("headerName", new String[]{"headerValue"}).withCookie("cookieName", "cookieValue"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path?parameterName=parameterOtherValue")).withHeader("headerName", new String[]{"headerValue"}).withCookie("cookieName", "cookieValue"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path?parameterName=parameterValue")).withHeader("headerName", new String[]{"headerOtherValue"}).withCookie("cookieName", "cookieValue"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path?parameterName=parameterValue")).withHeader("headerName", new String[]{"headerValue"}).withCookie("cookieName", "cookieOtherValue"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingNotBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")).withBody((Body)Not.not((Not)RegexBody.regex((String)".+")))).respond(HttpResponse.response().withBody("some_response_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_response_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_path")).withBody("some_random_body"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseFromVelocityTemplate() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path"))).respond(HttpTemplate.template((HttpTemplate.TemplateType)HttpTemplate.TemplateType.VELOCITY, (String)("{" + Character.NEW_LINE + "     \"statusCode\": 200," + Character.NEW_LINE + "     \"headers\": [ { \"name\": \"name\", \"values\": [ \"$!request.headers['name'][0]\" ] } ]," + Character.NEW_LINE + "     \"body\": \"$!request.body\"" + Character.NEW_LINE + "}" + Character.NEW_LINE)));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader("name", new String[]{"value"}).withBody("some_request_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withHeader("name", new String[]{"value"}).withBody("some_request_body"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethod() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseForExpectationWithDelay() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond((HttpResponse)HttpResponse.response().withBody("some_body1").withDelay(new Delay(TimeUnit.SECONDS, 2L)));
        long timeBeforeRequest = System.currentTimeMillis();
        HttpResponse httpResponse = this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), HEADERS_TO_IGNORE);
        long timeAfterRequest = System.currentTimeMillis();
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body1"), (Object)httpResponse);
        MatcherAssert.assertThat((Object)(timeAfterRequest - timeBeforeRequest), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toMillis(1900L))));
        MatcherAssert.assertThat((Object)(timeAfterRequest - timeBeforeRequest), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.SECONDS.toMillis(4L))));
    }

    @Test
    public void shouldReturnResponseForCallbackClassWithDelay() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("callback"))).respond((HttpClassCallback)HttpClassCallback.callback().withCallbackClass(PrecannedTestExpectationResponseCallback.class).withDelay(new Delay(TimeUnit.SECONDS, 2L)));
        long timeBeforeRequest = System.currentTimeMillis();
        HttpResponse httpResponse = this.makeRequest(HttpRequest.request().withPath(this.calculatePath("callback")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), HEADERS_TO_IGNORE);
        long timeAfterRequest = System.currentTimeMillis();
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-callback", (String[])new String[]{"test_callback_header"})}).withBody("a_callback_response"), (Object)httpResponse);
        MatcherAssert.assertThat((Object)(timeAfterRequest - timeBeforeRequest), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toMillis(1900L))));
        MatcherAssert.assertThat((Object)(timeAfterRequest - timeBeforeRequest), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.SECONDS.toMillis(4L))));
    }

    @Test
    public void shouldReturnResponseForCallbackToSpecifiedClassWithPrecannedResponse() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("callback"))).respond(HttpClassCallback.callback().withCallbackClass(PrecannedTestExpectationResponseCallback.class));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-callback", (String[])new String[]{"test_callback_header"})}).withBody("a_callback_response"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("callback")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingOpenAPIUrlWithOperationId() {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)OpenAPIDefinition.openAPI((String)"org/mockserver/mock/openapi_petstore_example.json", (String)"listPets")).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath("/pets").withQueryStringParameter("limit", new String[]{"10"}), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)OpenAPIDefinition.openAPI((String)"org/mockserver/mock/openapi_petstore_example.json", (String)"listPets")).thenRespond(HttpResponse.response().withBody("some_body"))));
    }

    @Test
    public void shouldReturnResponseByMatchingOpenAPISpecWithOperationId() throws JsonProcessingException {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)OpenAPIDefinition.openAPI((String)FileReader.readFileFromClassPathOrPath((String)"org/mockserver/mock/openapi_petstore_example.json"), (String)"listPets")).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath("/pets").withQueryStringParameter("limit", new String[]{"10"}), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)OpenAPIDefinition.openAPI((String)ObjectMapperFactory.createObjectMapper().readTree(FileReader.readFileFromClassPathOrPath((String)"org/mockserver/mock/openapi_petstore_example.json")).toPrettyString(), (String)"listPets")).thenRespond(HttpResponse.response().withBody("some_body"))));
    }

    @Test
    public void shouldReturnResponseByMatchingOpenAPIUrlWithoutOperationId() {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)OpenAPIDefinition.openAPI().withSpecUrlOrPayload("org/mockserver/mock/openapi_petstore_example.json")).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath("/pets").withQueryStringParameter("limit", new String[]{"10"}), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)OpenAPIDefinition.openAPI().withSpecUrlOrPayload("org/mockserver/mock/openapi_petstore_example.json")).thenRespond(HttpResponse.response().withBody("some_body"))));
    }

    @Test
    public void shouldReturnResponseByMatchingOpenAPIExpectationWithUrl() {
        Expectation[] upsertedExpectations = mockServerClient.upsert(new OpenAPIExpectation[]{OpenAPIExpectation.openAPIExpectation((String)"org/mockserver/mock/openapi_petstore_example.json")});
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader("x-next", new String[]{"some_string_value"}).withHeader("content-type", new String[]{"application/json"}).withBody((BodyWithContentType)JsonBody.json((String)("[ {" + Character.NEW_LINE + "  \"id\" : 0," + Character.NEW_LINE + "  \"name\" : \"some_string_value\"," + Character.NEW_LINE + "  \"tag\" : \"some_string_value\"" + Character.NEW_LINE + "} ]"), (MediaType)MediaType.APPLICATION_JSON)), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath("/pets").withQueryStringParameter("limit", new String[]{"10"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.CREATED_201.code())).withReasonPhrase(HttpStatusCode.CREATED_201.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath("/pets").withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"id\" : 0," + Character.NEW_LINE + "  \"name\" : \"some_string_value\"," + Character.NEW_LINE + "  \"tag\" : \"some_string_value\"" + Character.NEW_LINE + "}"), (MediaType)MediaType.APPLICATION_JSON)), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader("content-type", new String[]{"application/json"}).withBody((BodyWithContentType)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"id\" : 0," + Character.NEW_LINE + "  \"name\" : \"some_string_value\"," + Character.NEW_LINE + "  \"tag\" : \"some_string_value\"" + Character.NEW_LINE + "}"), (MediaType)MediaType.APPLICATION_JSON)), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath("/pets/12345").withHeader("x-request-id", new String[]{UUIDService.getUUID()}), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)4));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)Expectation.when((String)"org/mockserver/mock/openapi_petstore_example.json", (String)"listPets").thenRespond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withHeader("x-next", new String[]{"some_string_value"}).withHeader("content-type", new String[]{"application/json"}).withBody((BodyWithContentType)JsonBody.json((String)("[ {" + Character.NEW_LINE + "  \"id\" : 0," + Character.NEW_LINE + "  \"name\" : \"some_string_value\"," + Character.NEW_LINE + "  \"tag\" : \"some_string_value\"" + Character.NEW_LINE + "} ]"))))));
        MatcherAssert.assertThat((Object)upsertedExpectations[1], (Matcher)Is.is((Object)Expectation.when((String)"org/mockserver/mock/openapi_petstore_example.json", (String)"createPets").thenRespond(HttpResponse.response().withStatusCode(Integer.valueOf(201)))));
        MatcherAssert.assertThat((Object)upsertedExpectations[2], (Matcher)Is.is((Object)Expectation.when((String)"org/mockserver/mock/openapi_petstore_example.json", (String)"showPetById").thenRespond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withHeader("content-type", new String[]{"application/json"}).withBody((BodyWithContentType)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"id\" : 0," + Character.NEW_LINE + "  \"name\" : \"some_string_value\"," + Character.NEW_LINE + "  \"tag\" : \"some_string_value\"" + Character.NEW_LINE + "}"))))));
        MatcherAssert.assertThat((Object)upsertedExpectations[3], (Matcher)Is.is((Object)Expectation.when((String)"org/mockserver/mock/openapi_petstore_example.json", (String)"somePath").thenRespond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withHeader("content-type", new String[]{"application/json"}).withBody((BodyWithContentType)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"id\" : 0," + Character.NEW_LINE + "  \"name\" : \"some_string_value\"," + Character.NEW_LINE + "  \"tag\" : \"some_string_value\"" + Character.NEW_LINE + "}"))))));
    }

    @Test
    public void shouldReturnResponseByMatchingOpenAPIExpectationWithSpecAndResponse() throws JsonProcessingException {
        Expectation[] upsertedExpectations = mockServerClient.upsert(new OpenAPIExpectation[]{OpenAPIExpectation.openAPIExpectation((String)FileReader.readFileFromClassPathOrPath((String)"org/mockserver/mock/openapi_petstore_example.json"), (Map)ImmutableMap.of((Object)"listPets", (Object)"500", (Object)"createPets", (Object)"default", (Object)"showPetById", (Object)"200"))});
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.INTERNAL_SERVER_ERROR_500.code())).withReasonPhrase(HttpStatusCode.INTERNAL_SERVER_ERROR_500.reasonPhrase()).withHeader("content-type", new String[]{"application/json"}).withBody((BodyWithContentType)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"code\" : 0," + Character.NEW_LINE + "  \"message\" : \"some_string_value\"" + Character.NEW_LINE + "}"), (MediaType)MediaType.APPLICATION_JSON)), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath("/pets").withQueryStringParameter("limit", new String[]{"10"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader("content-type", new String[]{"application/json"}).withBody((BodyWithContentType)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"code\" : 0," + Character.NEW_LINE + "  \"message\" : \"some_string_value\"" + Character.NEW_LINE + "}"), (MediaType)MediaType.APPLICATION_JSON)), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath("/pets").withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"id\" : 0," + Character.NEW_LINE + "  \"name\" : \"some_string_value\"," + Character.NEW_LINE + "  \"tag\" : \"some_string_value\"" + Character.NEW_LINE + "}"))), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader("content-type", new String[]{"application/json"}).withBody((BodyWithContentType)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"id\" : 0," + Character.NEW_LINE + "  \"name\" : \"some_string_value\"," + Character.NEW_LINE + "  \"tag\" : \"some_string_value\"" + Character.NEW_LINE + "}"), (MediaType)MediaType.APPLICATION_JSON)), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath("/pets/12345").withHeader("x-request-id", new String[]{UUIDService.getUUID()}), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)3));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)Expectation.when((String)ObjectMapperFactory.createObjectMapper().readTree(FileReader.readFileFromClassPathOrPath((String)"org/mockserver/mock/openapi_petstore_example.json")).toPrettyString(), (String)"listPets").thenRespond(HttpResponse.response().withStatusCode(Integer.valueOf(500)).withHeader("content-type", new String[]{"application/json"}).withBody((BodyWithContentType)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"code\" : 0," + Character.NEW_LINE + "  \"message\" : \"some_string_value\"" + Character.NEW_LINE + "}"))))));
        MatcherAssert.assertThat((Object)upsertedExpectations[1], (Matcher)Is.is((Object)Expectation.when((String)ObjectMapperFactory.createObjectMapper().readTree(FileReader.readFileFromClassPathOrPath((String)"org/mockserver/mock/openapi_petstore_example.json")).toPrettyString(), (String)"createPets").thenRespond(HttpResponse.response().withHeader("content-type", new String[]{"application/json"}).withBody((BodyWithContentType)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"code\" : 0," + Character.NEW_LINE + "  \"message\" : \"some_string_value\"" + Character.NEW_LINE + "}"))))));
        MatcherAssert.assertThat((Object)upsertedExpectations[2], (Matcher)Is.is((Object)Expectation.when((String)ObjectMapperFactory.createObjectMapper().readTree(FileReader.readFileFromClassPathOrPath((String)"org/mockserver/mock/openapi_petstore_example.json")).toPrettyString(), (String)"showPetById").thenRespond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withHeader("content-type", new String[]{"application/json"}).withBody((BodyWithContentType)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"id\" : 0," + Character.NEW_LINE + "  \"name\" : \"some_string_value\"," + Character.NEW_LINE + "  \"tag\" : \"some_string_value\"" + Character.NEW_LINE + "}"))))));
    }

    @Test
    public void shouldSupportBatchedExpectations() throws Exception {
        HttpResponse httpResponse = (HttpResponse)httpClient.sendRequest(HttpRequest.request().withMethod("PUT").withHeader(HttpHeaderNames.HOST.toString(), new String[]{"localhost:" + this.getServerPort()}).withPath(this.addContextToPath("mockserver/expectation")).withBody("[" + new ExpectationSerializer(new MockServerLogger()).serialize(new Expectation((RequestDefinition)HttpRequest.request((String)"/path_one"), Times.once(), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body_one"))) + "," + new ExpectationSerializer(new MockServerLogger()).serialize(new Expectation((RequestDefinition)HttpRequest.request((String)"/path_two"), Times.once(), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body_two"))) + "," + new ExpectationSerializer(new MockServerLogger()).serialize(new Expectation((RequestDefinition)HttpRequest.request((String)"/path_three"), Times.once(), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body_three"))) + "]")).get(10L, TimeUnit.SECONDS);
        Expectation[] upsertedExpectations = new ExpectationSerializer(new MockServerLogger()).deserializeArray(httpResponse.getBodyAsString(), true);
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)3));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request((String)"/path_one"), Times.once(), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body_one"))));
        MatcherAssert.assertThat((Object)upsertedExpectations[1], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request((String)"/path_two"), Times.once(), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body_two"))));
        MatcherAssert.assertThat((Object)upsertedExpectations[2], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request((String)"/path_three"), Times.once(), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body_three"))));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_one"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("/path_one")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_two"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("/path_two")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_three"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("/path_three")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_other_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"}), Header.header((String)"set-cookie", (String[])new String[]{"cookieName=cookieValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingPath() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_other_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNottedHeader() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withHeaders(new Headers(new Header[]{Header.header((NottableString)NottableString.not((String)"headerName"), (NottableString[])new NottableString[0])}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withHeaders(new Header[]{Header.header((String)"otherHeaderName", (String[])new String[]{"headerValue"})}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingOpenAPI() {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)OpenAPIDefinition.openAPI((String)"org/mockserver/mock/openapi_petstore_example.json", (String)"listPets")).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withMethod("PUT").withPath("/pets").withQueryStringParameter("limit", new String[]{"10"}), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)OpenAPIDefinition.openAPI((String)"org/mockserver/mock/openapi_petstore_example.json", (String)"listPets")).thenRespond(HttpResponse.response().withBody("some_body"))));
    }

    @Test
    public void shouldVerifyReceivedRequestsSpecificTimesInHttpAndHttps() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request().withPath(this.calculatePath("some_path"))});
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.exactly((int)1));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request().withPath(this.calculatePath("some_path"))});
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.atLeast((int)1));
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.exactly((int)2));
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")).withSecure(Boolean.valueOf(true)), VerificationTimes.exactly((int)1));
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")).withSecure(Boolean.valueOf(false)), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldVerifyReceivedRequestsByExpectationId() {
        Expectation firstExpectation = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"))[0];
        Expectation secondExpectation = mockServerClient.when((RequestDefinition)HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_other_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"))[0];
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        mockServerClient.verify(firstExpectation.getId(), VerificationTimes.atLeast((int)1));
        mockServerClient.verify(firstExpectation.getId(), VerificationTimes.exactly((int)2));
        mockServerClient.verify(secondExpectation.getId(), VerificationTimes.never());
        AssertionError firstAssertionError = (AssertionError)((Object)Assert.assertThrows(AssertionError.class, () -> mockServerClient.verify(secondExpectation.getId(), VerificationTimes.atLeast((int)1))));
        MatcherAssert.assertThat((Object)((Throwable)((Object)firstAssertionError)).getMessage(), (Matcher)StringStartsWith.startsWith((String)"Request not found at least once"));
        AssertionError secondAssertionError = (AssertionError)((Object)Assert.assertThrows(AssertionError.class, () -> mockServerClient.verify(UUIDService.neverFixedUUID(), VerificationTimes.atLeast((int)1))));
        MatcherAssert.assertThat((Object)((Throwable)((Object)secondAssertionError)).getMessage(), (Matcher)StringStartsWith.startsWith((String)"No expectation found with id "));
    }

    @Test
    public void shouldVerifyNotReceivedRequestWithEmptyBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path_no_body")).withBody((Body)Not.not((Not)RegexBody.regex((String)".+")))).respond(HttpResponse.response());
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_no_body")), HEADERS_TO_IGNORE));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path_with_body")).withBody("some_request_body")).respond(HttpResponse.response().withBody("some_response_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_response_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_with_body")).withBody("some_request_body"), HEADERS_TO_IGNORE));
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request().withPath(this.calculatePath("some_path_no_body"))});
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path_no_body")).withBody((Body)RegexBody.regex((String)".+")), VerificationTimes.atMost((int)0));
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path_no_body")).withBody((Body)StringBody.exact((String)"some_random_body")), VerificationTimes.atMost((int)0));
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request().withPath(this.calculatePath("some_path_with_body"))});
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request().withPath(this.calculatePath("some_path_with_body")).withBody("some_request_body")});
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request().withPath(this.calculatePath("some_path_with_body")).withBody((Body)RegexBody.regex((String)".+"))});
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path_with_body")).withBody((Body)StringBody.exact((String)"some_other_body")), VerificationTimes.atMost((int)0));
    }

    @Test
    public void shouldVerifyNotEnoughRequestsReceived() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        try {
            mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.atLeast((int)2));
            TestCase.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found at least 2 times, expected:<{" + Character.NEW_LINE + "  \"path\" : \"" + this.calculatePath("some_path") + "\"" + Character.NEW_LINE + "}> but was:<{")));
        }
    }

    @Test
    public void shouldVerifyNotEnoughRequestsReceivedWithOpenAPI() {
        mockServerClient.when((RequestDefinition)OpenAPIDefinition.openAPI().withSpecUrlOrPayload("org/mockserver/mock/openapi_petstore_example.json"), Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("/pets")).withQueryStringParameter("limit", new String[]{"10"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("/pets")).withHeader("content-type", new String[]{"application/json"}).withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 50, " + Character.NEW_LINE + "    \"name\": \"scruffles\", " + Character.NEW_LINE + "    \"tag\": \"dog\"" + Character.NEW_LINE + "}"))), HEADERS_TO_IGNORE));
        mockServerClient.verify((RequestDefinition)OpenAPIDefinition.openAPI().withSpecUrlOrPayload("org/mockserver/mock/openapi_petstore_example.json"), VerificationTimes.atLeast((int)2));
    }

    @Test
    public void shouldVerifyNoRequestsReceived() {
        mockServerClient.reset();
        mockServerClient.verifyZeroInteractions();
    }

    @Test
    public void shouldVerifySequenceOfRequestsReceived() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)6)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_two")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), HEADERS_TO_IGNORE));
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_two"))});
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_two")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
    }

    @Test
    public void shouldVerifySequenceOfRequestsReceivedByExceptionId() {
        Expectation firstExpectation = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)6)).respond(HttpResponse.response().withBody("some_body"))[0];
        Expectation secondExpectation = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_other_path.*")), Times.exactly((int)6)).respond(HttpResponse.response().withBody("some_body"))[0];
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_two")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), HEADERS_TO_IGNORE));
        mockServerClient.verify(new String[]{firstExpectation.getId()});
        mockServerClient.verify(new String[]{firstExpectation.getId(), firstExpectation.getId()});
        mockServerClient.verify(new String[]{firstExpectation.getId(), firstExpectation.getId(), firstExpectation.getId()});
        AssertionError firstAssertionError = (AssertionError)((Object)Assert.assertThrows(AssertionError.class, () -> mockServerClient.verify(new String[]{firstExpectation.getId(), firstExpectation.getId(), firstExpectation.getId(), firstExpectation.getId(), firstExpectation.getId(), firstExpectation.getId()})));
        MatcherAssert.assertThat((Object)((Throwable)((Object)firstAssertionError)).getMessage(), (Matcher)StringStartsWith.startsWith((String)"Request sequence not found"));
        AssertionError secondAssertionError = (AssertionError)((Object)Assert.assertThrows(AssertionError.class, () -> mockServerClient.verify(new String[]{secondExpectation.getId()})));
        MatcherAssert.assertThat((Object)((Throwable)((Object)secondAssertionError)).getMessage(), (Matcher)StringStartsWith.startsWith((String)"Request sequence not found"));
        AssertionError thirdAssertionError = (AssertionError)((Object)Assert.assertThrows(AssertionError.class, () -> mockServerClient.verify(new String[]{UUIDService.neverFixedUUID(), UUIDService.neverFixedUUID()})));
        MatcherAssert.assertThat((Object)((Throwable)((Object)thirdAssertionError)).getMessage(), (Matcher)StringStartsWith.startsWith((String)"No expectation found with id "));
    }

    @Test
    public void shouldVerifySequenceOfRequestsReceivedByOpenAPI() {
        mockServerClient.when((RequestDefinition)OpenAPIDefinition.openAPI().withSpecUrlOrPayload("org/mockserver/mock/openapi_petstore_example.json"), Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("/pets")).withQueryStringParameter("limit", new String[]{"10"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("/pets")).withHeader("content-type", new String[]{"application/json"}).withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 50, " + Character.NEW_LINE + "    \"name\": \"scruffles\", " + Character.NEW_LINE + "    \"tag\": \"dog\"" + Character.NEW_LINE + "}"))), HEADERS_TO_IGNORE));
        try {
            mockServerClient.verify(new RequestDefinition[]{OpenAPIDefinition.openAPI().withSpecUrlOrPayload("org/mockserver/mock/openapi_petstore_example.json").withOperationId("createPets"), OpenAPIDefinition.openAPI().withSpecUrlOrPayload("org/mockserver/mock/openapi_petstore_example.json").withOperationId("listPets")});
            TestCase.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + Character.NEW_LINE + "  \"operationId\" : \"createPets\"," + Character.NEW_LINE + "  \"specUrlOrPayload\" : \"org/mockserver/mock/openapi_petstore_example.json\"" + Character.NEW_LINE + "}, {" + Character.NEW_LINE + "  \"operationId\" : \"listPets\"," + Character.NEW_LINE + "  \"specUrlOrPayload\" : \"org/mockserver/mock/openapi_petstore_example.json\"" + Character.NEW_LINE + "} ]> but was:<[ {")));
        }
        mockServerClient.verify(new RequestDefinition[]{OpenAPIDefinition.openAPI().withSpecUrlOrPayload("org/mockserver/mock/openapi_petstore_example.json").withOperationId("listPets"), OpenAPIDefinition.openAPI().withSpecUrlOrPayload("org/mockserver/mock/openapi_petstore_example.json").withOperationId("createPets")});
    }

    @Test
    public void shouldRetrieveRecordedRequests() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.notFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("not_found")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), HEADERS_TO_IGNORE));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))), HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_three")));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests((RequestDefinition)HttpRequest.request()), HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found")), HttpRequest.request((String)this.calculatePath("some_path_three")));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests(null), HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found")), HttpRequest.request((String)this.calculatePath("some_path_three")));
    }

    @Test
    public void shouldRetrieveRecordedRequestsByOpenAPI() {
        mockServerClient.when((RequestDefinition)OpenAPIDefinition.openAPI().withSpecUrlOrPayload("org/mockserver/mock/openapi_petstore_example.json"), Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("/pets")).withQueryStringParameter("limit", new String[]{"10"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.notFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("not_found")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("/pets")).withHeader("content-type", new String[]{"application/json"}).withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 50, " + Character.NEW_LINE + "    \"name\": \"scruffles\", " + Character.NEW_LINE + "    \"tag\": \"dog\"" + Character.NEW_LINE + "}"))), HEADERS_TO_IGNORE));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests((RequestDefinition)OpenAPIDefinition.openAPI().withSpecUrlOrPayload("org/mockserver/mock/openapi_petstore_example.json")), HttpRequest.request().withMethod("GET").withPath("/pets").withQueryStringParameter("limit", new String[]{"10"}), HttpRequest.request().withMethod("POST").withPath("/pets").withHeader("content-type", new String[]{"application/json"}).withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 50, " + Character.NEW_LINE + "    \"name\": \"scruffles\", " + Character.NEW_LINE + "    \"tag\": \"dog\"" + Character.NEW_LINE + "}"))));
    }

    @Test
    public void shouldRetrieveActiveExpectations() {
        HttpRequest complexRequest = HttpRequest.request().withPath(this.calculatePath("some_path.*")).withHeader("some", new String[]{"header"}).withQueryStringParameter("some", new String[]{"parameter"}).withCookie("some", "parameter").withBody("some_body");
        mockServerClient.when((RequestDefinition)complexRequest, Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))).respond(HttpResponse.response().withBody("some_body"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_other_path"))).respond(HttpResponse.response().withBody("some_other_body"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_forward_path"))).forward(HttpForward.forward());
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)complexRequest, Times.exactly((int)4), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))).thenRespond(HttpResponse.response().withBody("some_body"))}));
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)complexRequest, Times.exactly((int)4), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_other_path"))).thenRespond(HttpResponse.response().withBody("some_other_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_forward_path"))).thenForward(HttpForward.forward())}));
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations((RequestDefinition)HttpRequest.request()), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)complexRequest, Times.exactly((int)4), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_other_path"))).thenRespond(HttpResponse.response().withBody("some_other_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_forward_path"))).thenForward(HttpForward.forward())}));
    }

    @Test
    public void shouldRetrieveRecordedExpectations() throws InterruptedException {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4)).forward(HttpForward.forward().withHost("127.0.0.1").withPort(insecureEchoServer.getPort()));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body_one").withHeader("some", new String[]{"header"}).withHeader("cookie", new String[]{"some=parameter"}).withHeader("set-cookie", new String[]{"some=parameter"}).withCookie("some", "parameter"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")).withHeader("some", new String[]{"header"}).withQueryStringParameter("some", new String[]{"parameter"}).withCookie("some", "parameter").withBody("some_body_one"), HEADERS_TO_IGNORE));
        TimeUnit.MILLISECONDS.sleep(500L);
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body_three"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")).withBody("some_body_three"), HEADERS_TO_IGNORE));
        Expectation[] recordedExpectations = mockServerClient.retrieveRecordedExpectations((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path_one")));
        MatcherAssert.assertThat((Object)recordedExpectations.length, (Matcher)Is.is((Object)1));
        this.verifyRequestsMatches(new RequestDefinition[]{recordedExpectations[0].getHttpRequest()}, HttpRequest.request((String)this.calculatePath("some_path_one")).withBody("some_body_one"));
        MatcherAssert.assertThat((Object)recordedExpectations[0].getHttpResponse().getBodyAsString(), (Matcher)Is.is((Object)"some_body_one"));
        recordedExpectations = mockServerClient.retrieveRecordedExpectations((RequestDefinition)HttpRequest.request());
        MatcherAssert.assertThat((Object)recordedExpectations.length, (Matcher)Is.is((Object)2));
        this.verifyRequestsMatches(new RequestDefinition[]{recordedExpectations[0].getHttpRequest(), recordedExpectations[1].getHttpRequest()}, HttpRequest.request((String)this.calculatePath("some_path_one")).withBody("some_body_one"), HttpRequest.request((String)this.calculatePath("some_path_three")).withBody("some_body_three"));
        MatcherAssert.assertThat((Object)recordedExpectations[0].getHttpResponse().getBodyAsString(), (Matcher)Is.is((Object)"some_body_one"));
        MatcherAssert.assertThat((Object)recordedExpectations[1].getHttpResponse().getBodyAsString(), (Matcher)Is.is((Object)"some_body_three"));
        recordedExpectations = mockServerClient.retrieveRecordedExpectations(null);
        MatcherAssert.assertThat((Object)recordedExpectations.length, (Matcher)Is.is((Object)2));
        this.verifyRequestsMatches(new RequestDefinition[]{recordedExpectations[0].getHttpRequest(), recordedExpectations[1].getHttpRequest()}, HttpRequest.request((String)this.calculatePath("some_path_one")).withBody("some_body_one"), HttpRequest.request((String)this.calculatePath("some_path_three")).withBody("some_body_three"));
        MatcherAssert.assertThat((Object)recordedExpectations[0].getHttpResponse().getBodyAsString(), (Matcher)Is.is((Object)"some_body_one"));
        MatcherAssert.assertThat((Object)recordedExpectations[1].getHttpResponse().getBodyAsString(), (Matcher)Is.is((Object)"some_body_three"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRetrieveRecordedLogMessages() {
        Level originalLevel = ConfigurationProperties.logLevel();
        try {
            ConfigurationProperties.logLevel((String)"INFO");
            UUIDService.fixedUUID = true;
            mockServerClient.reset();
            mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
            TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), HEADERS_TO_IGNORE));
            TestCase.assertEquals((Object)HttpResponse.notFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("not_found")), HEADERS_TO_IGNORE));
            TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), HEADERS_TO_IGNORE));
            Object[] actualLogMessages = mockServerClient.retrieveLogMessagesArray((RequestDefinition)HttpRequest.request().withPath(this.calculatePath(".*")));
            Object[] expectedLogMessages = new Object[]{"resetting all expectations and request logs", "creating expectation:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"httpRequest\" : {" + Character.NEW_LINE + "      \"path\" : \"/some_path.*\"" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"httpResponse\" : {" + Character.NEW_LINE + "      \"body\" : \"some_body\"" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"id\" : \"" + UUIDService.getUUID() + "\"," + Character.NEW_LINE + "    \"priority\" : 0," + Character.NEW_LINE + "    \"timeToLive\" : {" + Character.NEW_LINE + "      \"unlimited\" : true" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"times\" : {" + Character.NEW_LINE + "      \"remainingTimes\" : 4" + Character.NEW_LINE + "    }" + Character.NEW_LINE + "  }" + Character.NEW_LINE + Character.NEW_LINE + " with id:" + Character.NEW_LINE + Character.NEW_LINE + "  " + UUIDService.getUUID() + Character.NEW_LINE, new String[]{"received request:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"method\" : \"GET\"," + Character.NEW_LINE + "    \"path\" : \"/some_path_one\"," + Character.NEW_LINE + "    \"headers\" : {"}, new String[]{"request:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"method\" : \"GET\"," + Character.NEW_LINE + "    \"path\" : \"/some_path_one\",", " matched expectation:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"httpRequest\" : {" + Character.NEW_LINE + "      \"path\" : \"/some_path.*\"" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"httpResponse\" : {" + Character.NEW_LINE + "      \"body\" : \"some_body\"" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"id\" : \"" + UUIDService.getUUID() + "\"," + Character.NEW_LINE + "    \"priority\" : 0," + Character.NEW_LINE + "    \"timeToLive\" : {" + Character.NEW_LINE + "      \"unlimited\" : true" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"times\" : {" + Character.NEW_LINE + "      \"remainingTimes\" : 4" + Character.NEW_LINE + "    }" + Character.NEW_LINE + "  }"}, new String[]{"returning response:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"body\" : \"some_body\"" + Character.NEW_LINE + "  }" + Character.NEW_LINE + Character.NEW_LINE + " for request:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"method\" : \"GET\"," + Character.NEW_LINE + "    \"path\" : \"/some_path_one\",", " for action:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"body\" : \"some_body\"" + Character.NEW_LINE + "  }" + Character.NEW_LINE}, new String[]{"received request:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"method\" : \"GET\"," + Character.NEW_LINE + "    \"path\" : \"/not_found\"," + Character.NEW_LINE + "    \"headers\" : {"}, new String[]{"request:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"method\" : \"GET\"," + Character.NEW_LINE + "    \"path\" : \"/not_found\",", " didn't match expectation:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"httpRequest\" : {" + Character.NEW_LINE + "      \"path\" : \"/some_path.*\"" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"httpResponse\" : {" + Character.NEW_LINE + "      \"body\" : \"some_body\"" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"id\" : \"" + UUIDService.getUUID() + "\"," + Character.NEW_LINE + "    \"priority\" : 0," + Character.NEW_LINE + "    \"timeToLive\" : {" + Character.NEW_LINE + "      \"unlimited\" : true" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"times\" : {" + Character.NEW_LINE + "      \"remainingTimes\" : 3" + Character.NEW_LINE + "    }" + Character.NEW_LINE + "  }" + Character.NEW_LINE + Character.NEW_LINE + " because:" + Character.NEW_LINE + Character.NEW_LINE + "  method matched" + Character.NEW_LINE + "  path didn't match" + Character.NEW_LINE}, new String[]{"no expectation for:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"method\" : \"GET\"," + Character.NEW_LINE + "    \"path\" : \"/not_found\"," + Character.NEW_LINE, " returning response:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"statusCode\" : 404," + Character.NEW_LINE + "    \"reasonPhrase\" : \"Not Found\"" + Character.NEW_LINE + "  }" + Character.NEW_LINE}, new String[]{"received request:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"method\" : \"GET\"," + Character.NEW_LINE + "    \"path\" : \"/some_path_three\"," + Character.NEW_LINE + "    \"headers\" : {"}, new String[]{"request:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"method\" : \"GET\"," + Character.NEW_LINE + "    \"path\" : \"/some_path_three\",", " matched expectation:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"httpRequest\" : {" + Character.NEW_LINE + "      \"path\" : \"/some_path.*\"" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"httpResponse\" : {" + Character.NEW_LINE + "      \"body\" : \"some_body\"" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"id\" : \"" + UUIDService.getUUID() + "\"," + Character.NEW_LINE + "    \"priority\" : 0," + Character.NEW_LINE + "    \"timeToLive\" : {" + Character.NEW_LINE + "      \"unlimited\" : true" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"times\" : {" + Character.NEW_LINE + "      \"remainingTimes\" : 3" + Character.NEW_LINE + "    }" + Character.NEW_LINE + "  }"}, new String[]{"returning response:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"body\" : \"some_body\"" + Character.NEW_LINE + "  }" + Character.NEW_LINE + Character.NEW_LINE + " for request:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"method\" : \"GET\"," + Character.NEW_LINE + "    \"path\" : \"/some_path_three\",", " for action:" + Character.NEW_LINE + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"body\" : \"some_body\"" + Character.NEW_LINE + "  }" + Character.NEW_LINE}};
            for (int i = 0; i < expectedLogMessages.length; ++i) {
                if (expectedLogMessages[i] instanceof String) {
                    MatcherAssert.assertThat((String)("matching log message " + i + "\nActual:" + Character.NEW_LINE + Arrays.toString(actualLogMessages)), (Object)actualLogMessages[i], (Matcher)Matchers.endsWith((String)((String)expectedLogMessages[i])));
                    continue;
                }
                if (!(expectedLogMessages[i] instanceof String[])) continue;
                String[] expectedLogMessage = (String[])expectedLogMessages[i];
                for (int j = 0; j < expectedLogMessage.length; ++j) {
                    MatcherAssert.assertThat((String)("matching log message " + i + "-" + j + "\nActual:" + Character.NEW_LINE + Arrays.toString(actualLogMessages)), (Object)actualLogMessages[i], (Matcher)Matchers.containsString((String)expectedLogMessage[j]));
                }
            }
        }
        finally {
            UUIDService.fixedUUID = false;
            ConfigurationProperties.logLevel((String)originalLevel.name());
        }
    }

    @Test
    public void shouldClearExpectationsAndLogs() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), HEADERS_TO_IGNORE));
        mockServerClient.clear((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1")));
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).thenRespond(HttpResponse.response().withBody("some_body2"))}));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests(null), HttpRequest.request((String)this.calculatePath("some_path2")));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldClearExpectationsAndLogsByOpenAPI() {
        mockServerClient.when((RequestDefinition)OpenAPIDefinition.openAPI().withSpecUrlOrPayload("org/mockserver/mock/openapi_petstore_example.json"), Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("/pets")).withQueryStringParameter("limit", new String[]{"10"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.notFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("not_found")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("/pets")).withHeader("content-type", new String[]{"application/json"}).withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 50, " + Character.NEW_LINE + "    \"name\": \"scruffles\", " + Character.NEW_LINE + "    \"tag\": \"dog\"" + Character.NEW_LINE + "}"))), HEADERS_TO_IGNORE));
        mockServerClient.clear((RequestDefinition)OpenAPIDefinition.openAPI().withSpecUrlOrPayload("org/mockserver/mock/openapi_petstore_example.json"));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests(null), HttpRequest.request((String)this.calculatePath("not_found")));
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).thenRespond(HttpResponse.response().withBody("some_body2"))}));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("/pets")).withQueryStringParameter("limit", new String[]{"10"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReset() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        mockServerClient.reset();
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path1")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path2")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldErrorForInvalidExpectation() throws Exception {
        HttpResponse httpResponse = (HttpResponse)httpClient.sendRequest(HttpRequest.request().withMethod("PUT").withHeader(HttpHeaderNames.HOST.toString(), new String[]{"localhost:" + this.getServerPort()}).withPath(this.addContextToPath("mockserver/expectation")).withBody("{" + Character.NEW_LINE + "  \"httpRequest\" : {" + Character.NEW_LINE + "    \"path\" : \"/path_one\"" + Character.NEW_LINE + "  }," + Character.NEW_LINE + "  \"incorrectField\" : {" + Character.NEW_LINE + "    \"body\" : \"some_body_one\"" + Character.NEW_LINE + "  }," + Character.NEW_LINE + "  \"times\" : {" + Character.NEW_LINE + "    \"remainingTimes\" : 1" + Character.NEW_LINE + "  }," + Character.NEW_LINE + "  \"timeToLive\" : {" + Character.NEW_LINE + "    \"unlimited\" : true" + Character.NEW_LINE + "  }" + Character.NEW_LINE + "}")).get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)httpResponse.getStatusCode(), (Matcher)Is.is((Object)400));
        MatcherAssert.assertThat((Object)httpResponse.getBodyAsString(), (Matcher)Is.is((Object)("incorrect expectation json format for:" + Character.NEW_LINE + "" + Character.NEW_LINE + "  {" + Character.NEW_LINE + "    \"httpRequest\" : {" + Character.NEW_LINE + "      \"path\" : \"/path_one\"" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"incorrectField\" : {" + Character.NEW_LINE + "      \"body\" : \"some_body_one\"" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"times\" : {" + Character.NEW_LINE + "      \"remainingTimes\" : 1" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"timeToLive\" : {" + Character.NEW_LINE + "      \"unlimited\" : true" + Character.NEW_LINE + "    }" + Character.NEW_LINE + "  }" + Character.NEW_LINE + "" + Character.NEW_LINE + " schema validation errors:" + Character.NEW_LINE + "" + Character.NEW_LINE + "  12 errors:\n   - $.httpError: is missing, but is required, if specifying action of type Error\n   - $.httpForward: is missing, but is required, if specifying action of type Forward\n   - $.httpForwardClassCallback: is missing, but is required, if specifying action of type ForwardClassCallback\n   - $.httpForwardObjectCallback: is missing, but is required, if specifying action of type ForwardObjectCallback\n   - $.httpForwardTemplate: is missing, but is required, if specifying action of type ForwardTemplate\n   - $.httpOverrideForwardedRequest: is missing, but is required, if specifying action of type OverrideForwardedRequest\n   - $.httpResponse: is missing, but is required, if specifying action of type Response\n   - $.httpResponseClassCallback: is missing, but is required, if specifying action of type ResponseClassCallback\n   - $.httpResponseObjectCallback: is missing, but is required, if specifying action of type ResponseObjectCallback\n   - $.httpResponseTemplate: is missing, but is required, if specifying action of type ResponseTemplate\n   - $.incorrectField: is not defined in the schema and the schema does not allow additional properties\n   - oneOf of the following must be specified [httpError, httpForward, httpForwardClassCallback, httpForwardObjectCallback, httpForwardTemplate, httpOverrideForwardedRequest, httpResponse, httpResponseClassCallback, httpResponseObjectCallback, httpResponseTemplate]" + Character.NEW_LINE + "  " + Character.NEW_LINE + "  " + JsonSchemaValidator.OPEN_API_SPECIFICATION_URL.replaceAll(Character.NEW_LINE, Character.NEW_LINE + "  "))));
    }

    @Test
    public void shouldErrorForInvalidRequest() throws Exception {
        HttpResponse httpResponse = (HttpResponse)httpClient.sendRequest(HttpRequest.request().withMethod("PUT").withHeader(HttpHeaderNames.HOST.toString(), new String[]{"localhost:" + this.getServerPort()}).withPath(this.addContextToPath("mockserver/clear")).withBody("{" + Character.NEW_LINE + "    \"path\" : 500," + Character.NEW_LINE + "    \"method\" : true," + Character.NEW_LINE + "    \"keepAlive\" : \"false\"" + Character.NEW_LINE + "  }")).get(10L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)httpResponse.getStatusCode(), (Matcher)Is.is((Object)400));
        MatcherAssert.assertThat((Object)httpResponse.getBodyAsString(), (Matcher)Is.is((Object)("incorrect request matcher json format for:" + Character.NEW_LINE + "" + Character.NEW_LINE + "  {" + Character.NEW_LINE + "      \"path\" : 500," + Character.NEW_LINE + "      \"method\" : true," + Character.NEW_LINE + "      \"keepAlive\" : \"false\"" + Character.NEW_LINE + "    }" + Character.NEW_LINE + "" + Character.NEW_LINE + " schema validation errors:" + Character.NEW_LINE + "" + Character.NEW_LINE + "  4 errors:\n   - $.keepAlive: string found, boolean expected\n   - $.method: boolean found, string expected\n   - $.path: integer found, string expected\n   - $.specUrlOrPayload: is missing, but is required, if specifying OpenAPI request matcher" + Character.NEW_LINE + "  " + Character.NEW_LINE + "  " + JsonSchemaValidator.OPEN_API_SPECIFICATION_URL.replaceAll(Character.NEW_LINE, Character.NEW_LINE + "  "))));
    }

    @Test
    public void shouldForwardRequestInHTTPWithDelay() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).forward((HttpForward)HttpForward.forward().withHost("127.0.0.1").withPort(insecureEchoServer.getPort()).withDelay(new Delay(TimeUnit.SECONDS, 2L)));
        long timeBeforeRequest = System.currentTimeMillis();
        HttpResponse httpResponse = this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), HEADERS_TO_IGNORE);
        long timeAfterRequest = System.currentTimeMillis();
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), (Object)httpResponse);
        MatcherAssert.assertThat((Object)(timeAfterRequest - timeBeforeRequest), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toMillis(1900L))));
        MatcherAssert.assertThat((Object)(timeAfterRequest - timeBeforeRequest), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.SECONDS.toMillis(4L))));
    }

    @Test
    public void shouldForwardOverriddenRequestWithDelay() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")).withSecure(Boolean.valueOf(false))).forward((HttpOverrideForwardedRequest)HttpOverrideForwardedRequest.forwardOverriddenRequest().withRequestOverride(HttpRequest.request().withHeader("Host", new String[]{"localhost:" + insecureEchoServer.getPort()}).withBody("some_overridden_body")).withDelay(TimeUnit.SECONDS, 2L));
        long timeBeforeRequest = System.currentTimeMillis();
        HttpResponse httpResponse = this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), HEADERS_TO_IGNORE);
        long timeAfterRequest = System.currentTimeMillis();
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("some_overridden_body"), (Object)httpResponse);
        MatcherAssert.assertThat((Object)(timeAfterRequest - timeBeforeRequest), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toMillis(1900L))));
        MatcherAssert.assertThat((Object)(timeAfterRequest - timeBeforeRequest), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.SECONDS.toMillis(4L))));
    }

    @Test
    public void shouldForwardOverriddenRequestWithRequestModifier() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("/some/path")).withSecure(Boolean.valueOf(false))).forward(HttpOverrideForwardedRequest.forwardOverriddenRequest().withRequestOverride(HttpRequest.request().withHeader("Host", new String[]{"localhost:" + insecureEchoServer.getPort()}).withHeader("overrideHeaderToReplace", new String[]{"originalValue"}).withHeader("overrideHeaderToRemove", new String[]{"originalValue"}).withCookie("overrideCookieToReplace", "originalValue").withBody("some_overridden_body")).withRequestModifier(HttpRequestModifier.requestModifier().withPath("^/(.+)/(.+)$", "/prefix/$1/infix/$2/postfix").withHeaders((List)ImmutableList.of((Object)Header.header((String)"headerToAddOne", (String[])new String[]{"addedValue"}), (Object)Header.header((String)"headerToAddTwo", (String[])new String[]{"addedValue"})), (List)ImmutableList.of((Object)Header.header((String)"overrideHeaderToReplace", (String[])new String[]{"replacedValue"}), (Object)Header.header((String)"requestHeaderToReplace", (String[])new String[]{"replacedValue"}), (Object)Header.header((String)"extraHeaderToReplace", (String[])new String[]{"shouldBeIgnore"})), (List)ImmutableList.of((Object)"overrideHeaderToRemove", (Object)"requestHeaderToRemove")).withCookies((List)ImmutableList.of((Object)Cookie.cookie((String)"cookieToAddOne", (String)"addedValue"), (Object)Cookie.cookie((String)"cookieToAddTwo", (String)"addedValue")), (List)ImmutableList.of((Object)Cookie.cookie((String)"overrideCookieToReplace", (String)"replacedValue"), (Object)Cookie.cookie((String)"requestCookieToReplace", (String)"replacedValue"), (Object)Cookie.cookie((String)"extraCookieToReplace", (String)"shouldBeIgnore")), (List)ImmutableList.of((Object)"overrideCookieToRemove", (Object)"requestCookieToRemove"))));
        HttpResponse httpResponse = this.makeRequest(HttpRequest.request().withPath(this.calculatePath("/some/path")).withMethod("POST").withHeader("x-test", new String[]{"test_headers_and_body"}).withHeader("requestHeaderToReplace", new String[]{"originalValue"}).withHeader("requestHeaderToRemove", new String[]{"originalValue"}).withCookie("requestCookieToReplace", "replacedValue").withBody("an_example_body_http"), HEADERS_TO_IGNORE);
        HttpRequest echoServerRequest = insecureEchoServer.getLastRequest();
        TestCase.assertEquals((Object)echoServerRequest.withHeaders(AbstractBasicMockingIntegrationTest.filterHeaders(HEADERS_TO_IGNORE, echoServerRequest.getHeaderList())), (Object)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("/prefix/some/infix/path/postfix")).withHeader("x-test", new String[]{"test_headers_and_body"}).withHeader("requestHeaderToReplace", new String[]{"replacedValue"}).withHeader("overrideHeaderToReplace", new String[]{"replacedValue"}).withHeader("headerToAddOne", new String[]{"addedValue"}).withHeader("headerToAddTwo", new String[]{"addedValue"}).withHeader("cookie", new String[]{"overrideCookieToReplace=replacedValue; requestCookieToReplace=replacedValue; cookieToAddOne=addedValue; cookieToAddTwo=addedValue"}).withCookie("cookieToAddOne", "addedValue").withCookie("cookieToAddTwo", "addedValue").withCookie("overrideCookieToReplace", "replacedValue").withCookie("requestCookieToReplace", "replacedValue").withKeepAlive(Boolean.valueOf(true)).withSecure(Boolean.valueOf(false)).withSocketAddress("localhost", insecureEchoServer.getPort(), SocketAddress.Scheme.HTTP).withBody("some_overridden_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader("x-test", new String[]{"test_headers_and_body"}).withHeader("requestHeaderToReplace", new String[]{"replacedValue"}).withHeader("overrideHeaderToReplace", new String[]{"replacedValue"}).withHeader("headerToAddOne", new String[]{"addedValue"}).withHeader("headerToAddTwo", new String[]{"addedValue"}).withHeader("set-cookie", new String[]{"cookieToAddOne=addedValue", "cookieToAddTwo=addedValue", "overrideCookieToReplace=replacedValue", "requestCookieToReplace=replacedValue"}).withHeader("cookie", new String[]{"overrideCookieToReplace=replacedValue; requestCookieToReplace=replacedValue; cookieToAddOne=addedValue; cookieToAddTwo=addedValue"}).withCookie("cookieToAddOne", "addedValue").withCookie("cookieToAddTwo", "addedValue").withCookie("overrideCookieToReplace", "replacedValue").withCookie("requestCookieToReplace", "replacedValue").withBody("some_overridden_body"), (Object)httpResponse);
    }

    @Test
    public void shouldForwardOverriddenRequestWithRequestAndResponseModifiers() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("/some/path")).withSecure(Boolean.valueOf(false))).forward(HttpOverrideForwardedRequest.forwardOverriddenRequest().withRequestOverride(HttpRequest.request().withHeader("Host", new String[]{"localhost:" + insecureEchoServer.getPort()}).withHeader("overrideHeaderToReplace", new String[]{"originalValue"}).withHeader("overrideHeaderToRemove", new String[]{"originalValue"}).withCookie("overrideCookieToReplace", "replacedValue").withCookie("requestCookieToReplace", "replacedValue").withBody("some_overridden_body")).withRequestModifier(HttpRequestModifier.requestModifier().withPath("^/(.+)/(.+)$", "/prefix/$1/infix/$2/postfix").withHeaders((List)ImmutableList.of((Object)Header.header((String)"headerToAddOne", (String[])new String[]{"addedValue"}), (Object)Header.header((String)"headerToAddTwo", (String[])new String[]{"addedValue"})), (List)ImmutableList.of((Object)Header.header((String)"overrideHeaderToReplace", (String[])new String[]{"replacedValue"}), (Object)Header.header((String)"requestHeaderToReplace", (String[])new String[]{"replacedValue"})), (List)ImmutableList.of((Object)"overrideHeaderToRemove", (Object)"requestHeaderToRemove")).withCookies((List)ImmutableList.of((Object)Cookie.cookie((String)"cookieToAddOne", (String)"addedValue"), (Object)Cookie.cookie((String)"cookieToAddTwo", (String)"addedValue")), (List)ImmutableList.of((Object)Cookie.cookie((String)"overrideCookieToReplace", (String)"replacedValue"), (Object)Cookie.cookie((String)"requestCookieToReplace", (String)"replacedValue")), (List)ImmutableList.of((Object)"overrideCookieToRemove", (Object)"requestCookieToRemove"))).withResponseModifier(HttpResponseModifier.responseModifier().withHeaders((List)ImmutableList.of((Object)Header.header((String)"responseHeaderToAddOne", (String[])new String[]{"addedValue"}), (Object)Header.header((String)"responseHeaderToAddTwo", (String[])new String[]{"addedValue"})), (List)ImmutableList.of((Object)Header.header((String)"overrideHeaderToReplace", (String[])new String[]{"responseReplacedValue"}), (Object)Header.header((String)"requestHeaderToReplace", (String[])new String[]{"responseReplacedValue"})), (List)ImmutableList.of((Object)"headerToAddOne")).withCookies((List)ImmutableList.of((Object)Cookie.cookie((String)"responseCookieToAddOne", (String)"addedValue"), (Object)Cookie.cookie((String)"responseCookieToAddTwo", (String)"addedValue")), (List)ImmutableList.of((Object)Cookie.cookie((String)"overrideCookieToReplace", (String)"responseReplacedValue"), (Object)Cookie.cookie((String)"requestCookieToReplace", (String)"responseReplacedValue")), (List)ImmutableList.of((Object)"cookieToAddOne"))));
        HttpResponse httpResponse = this.makeRequest(HttpRequest.request().withPath(this.calculatePath("/some/path")).withMethod("POST").withHeader("x-test", new String[]{"test_headers_and_body"}).withHeader("requestHeaderToReplace", new String[]{"originalValue"}).withHeader("requestHeaderToRemove", new String[]{"originalValue"}).withBody("an_example_body_http"), HEADERS_TO_IGNORE);
        HttpRequest echoServerRequest = insecureEchoServer.getLastRequest();
        TestCase.assertEquals((Object)echoServerRequest.withHeaders(AbstractBasicMockingIntegrationTest.filterHeaders(HEADERS_TO_IGNORE, echoServerRequest.getHeaderList())), (Object)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("/prefix/some/infix/path/postfix")).withHeader("x-test", new String[]{"test_headers_and_body"}).withHeader("requestHeaderToReplace", new String[]{"replacedValue"}).withHeader("overrideHeaderToReplace", new String[]{"replacedValue"}).withHeader("headerToAddOne", new String[]{"addedValue"}).withHeader("headerToAddTwo", new String[]{"addedValue"}).withHeader("cookie", new String[]{"overrideCookieToReplace=replacedValue; requestCookieToReplace=replacedValue; cookieToAddOne=addedValue; cookieToAddTwo=addedValue"}).withCookie("cookieToAddOne", "addedValue").withCookie("cookieToAddTwo", "addedValue").withCookie("overrideCookieToReplace", "replacedValue").withCookie("requestCookieToReplace", "replacedValue").withKeepAlive(Boolean.valueOf(true)).withSecure(Boolean.valueOf(false)).withSocketAddress("localhost", insecureEchoServer.getPort(), SocketAddress.Scheme.HTTP).withBody("some_overridden_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader("x-test", new String[]{"test_headers_and_body"}).withHeader("responseHeaderToAddOne", new String[]{"addedValue"}).withHeader("responseHeaderToAddTwo", new String[]{"addedValue"}).withHeader("requestHeaderToReplace", new String[]{"responseReplacedValue"}).withHeader("overrideHeaderToReplace", new String[]{"responseReplacedValue"}).withHeader("headerToAddTwo", new String[]{"addedValue"}).withHeader("set-cookie", new String[]{"cookieToAddTwo=addedValue", "overrideCookieToReplace=responseReplacedValue", "requestCookieToReplace=responseReplacedValue", "responseCookieToAddOne=addedValue", "responseCookieToAddTwo=addedValue"}).withHeader("cookie", new String[]{"overrideCookieToReplace=replacedValue; requestCookieToReplace=replacedValue; cookieToAddOne=addedValue; cookieToAddTwo=addedValue"}).withCookie("cookieToAddOne", "addedValue").withCookie("cookieToAddTwo", "addedValue").withCookie("overrideCookieToReplace", "responseReplacedValue").withCookie("requestCookieToReplace", "responseReplacedValue").withCookie("responseCookieToAddOne", "addedValue").withCookie("responseCookieToAddTwo", "addedValue").withBody("some_overridden_body"), (Object)httpResponse);
    }

    @Test
    public void shouldForwardOverriddenRequestWithEmptyRequestAndResponseModifiers() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("/some/path")).withSecure(Boolean.valueOf(false))).forward(HttpOverrideForwardedRequest.forwardOverriddenRequest().withRequestOverride(HttpRequest.request().withHeader("Host", new String[]{"localhost:" + insecureEchoServer.getPort()}).withHeader("overrideHeaderToReplace", new String[]{"originalValue"}).withHeader("overrideHeaderToRemove", new String[]{"originalValue"}).withCookie("overrideCookieToReplace", "replacedValue").withCookie("requestCookieToReplace", "replacedValue").withBody("some_overridden_body")).withRequestModifier(HttpRequestModifier.requestModifier()).withResponseModifier(HttpResponseModifier.responseModifier()));
        HttpResponse httpResponse = this.makeRequest(HttpRequest.request().withPath(this.calculatePath("/some/path")).withMethod("POST").withHeader("x-test", new String[]{"test_headers_and_body"}).withBody("an_example_body_http"), HEADERS_TO_IGNORE);
        HttpRequest echoServerRequest = insecureEchoServer.getLastRequest();
        TestCase.assertEquals((Object)echoServerRequest.withHeaders(AbstractBasicMockingIntegrationTest.filterHeaders(HEADERS_TO_IGNORE, echoServerRequest.getHeaderList())), (Object)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("/some/path")).withHeader("x-test", new String[]{"test_headers_and_body"}).withHeader("overrideHeaderToReplace", new String[]{"originalValue"}).withHeader("overrideHeaderToRemove", new String[]{"originalValue"}).withHeader("cookie", new String[]{"overrideCookieToReplace=replacedValue; requestCookieToReplace=replacedValue"}).withCookie("overrideCookieToReplace", "replacedValue").withCookie("requestCookieToReplace", "replacedValue").withKeepAlive(Boolean.valueOf(true)).withSecure(Boolean.valueOf(false)).withSocketAddress("localhost", insecureEchoServer.getPort(), SocketAddress.Scheme.HTTP).withBody("some_overridden_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader("x-test", new String[]{"test_headers_and_body"}).withHeader("overrideHeaderToReplace", new String[]{"originalValue"}).withHeader("overrideHeaderToRemove", new String[]{"originalValue"}).withHeader("set-cookie", new String[]{"overrideCookieToReplace=replacedValue", "requestCookieToReplace=replacedValue"}).withHeader("cookie", new String[]{"overrideCookieToReplace=replacedValue; requestCookieToReplace=replacedValue"}).withCookie("overrideCookieToReplace", "replacedValue").withCookie("requestCookieToReplace", "replacedValue").withBody("some_overridden_body"), (Object)httpResponse);
    }

    @Test
    public void shouldForwardRequestInHTTP() {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).forward(HttpForward.forward().withHost("127.0.0.1").withPort(insecureEchoServer.getPort()));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).thenForward(HttpForward.forward().withHost("127.0.0.1").withPort(insecureEchoServer.getPort()))));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldForwardRequestInHTTPS() {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).forward(HttpForward.forward().withHost("127.0.0.1").withPort(secureEchoServer.getPort()).withScheme(HttpForward.Scheme.HTTPS));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).thenForward(HttpForward.forward().withHost("127.0.0.1").withPort(secureEchoServer.getPort()).withScheme(HttpForward.Scheme.HTTPS))));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldForwardOverriddenRequest() {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")).withSecure(Boolean.valueOf(false))).forward((HttpOverrideForwardedRequest)HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)HttpRequest.request().withHeader("Host", new String[]{"localhost:" + insecureEchoServer.getPort()}).withBody("some_overridden_body")).withDelay(TimeUnit.MILLISECONDS, 10L));
        Expectation[] upsertedSecureExpectations = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")).withSecure(Boolean.valueOf(true))).forward((HttpOverrideForwardedRequest)HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)HttpRequest.request().withHeader("Host", new String[]{"localhost:" + secureEchoServer.getPort()}).withBody("some_overridden_body")).withDelay(TimeUnit.MILLISECONDS, 10L));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")).withSecure(Boolean.valueOf(false))).thenForward((HttpOverrideForwardedRequest)HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)HttpRequest.request().withHeader("Host", new String[]{"localhost:" + insecureEchoServer.getPort()}).withBody("some_overridden_body")).withDelay(TimeUnit.MILLISECONDS, 10L))));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("some_overridden_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedSecureExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedSecureExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")).withSecure(Boolean.valueOf(true))).thenForward((HttpOverrideForwardedRequest)HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)HttpRequest.request().withHeader("Host", new String[]{"localhost:" + secureEchoServer.getPort()}).withBody("some_overridden_body")).withDelay(TimeUnit.MILLISECONDS, 10L))));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body_https"})}).withBody("some_overridden_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body_https"})}).withBody("an_example_body_https"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldForwardOverriddenRequestWithOverriddenResponse() {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")).withSecure(Boolean.valueOf(false))).forward((HttpOverrideForwardedRequest)HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)HttpRequest.request().withHeader("Host", new String[]{"localhost:" + insecureEchoServer.getPort()}).withBody("some_overridden_body"), (HttpResponse)HttpResponse.response().withHeader("extra_header", new String[]{"some_value"}).withHeader("content-length", new String[]{"29"}).withBody("some_overridden_response_body")).withDelay(TimeUnit.MILLISECONDS, 10L));
        Expectation[] upsertedSecureExpectations = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")).withSecure(Boolean.valueOf(true))).forward((HttpOverrideForwardedRequest)HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)HttpRequest.request().withHeader("Host", new String[]{"localhost:" + secureEchoServer.getPort()}).withBody("some_overridden_body"), (HttpResponse)HttpResponse.response().withHeader("extra_header", new String[]{"some_value"}).withHeader("content-length", new String[]{"29"}).withBody("some_overridden_response_body")).withDelay(TimeUnit.MILLISECONDS, 10L));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"}), Header.header((String)"extra_header", (String[])new String[]{"some_value"})}).withBody("some_overridden_response_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")).withSecure(Boolean.valueOf(false))).thenForward((HttpOverrideForwardedRequest)HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)HttpRequest.request().withHeader("Host", new String[]{"localhost:" + insecureEchoServer.getPort()}).withBody("some_overridden_body"), (HttpResponse)HttpResponse.response().withHeader("extra_header", new String[]{"some_value"}).withHeader("content-length", new String[]{"29"}).withBody("some_overridden_response_body")).withDelay(TimeUnit.MILLISECONDS, 10L))));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body_https"}), Header.header((String)"extra_header", (String[])new String[]{"some_value"})}).withBody("some_overridden_response_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body_https"})}).withBody("an_example_body_https"), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedSecureExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedSecureExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")).withSecure(Boolean.valueOf(true))).thenForward((HttpOverrideForwardedRequest)HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)HttpRequest.request().withHeader("Host", new String[]{"localhost:" + secureEchoServer.getPort()}).withBody("some_overridden_body"), (HttpResponse)HttpResponse.response().withHeader("extra_header", new String[]{"some_value"}).withHeader("content-length", new String[]{"29"}).withBody("some_overridden_response_body")).withDelay(TimeUnit.MILLISECONDS, 10L))));
    }

    @Test
    public void shouldForwardOverriddenRequestWithSocketAddress() {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")).withSecure(Boolean.valueOf(false))).forward((HttpOverrideForwardedRequest)HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)HttpRequest.request().withHeader("Host", new String[]{"incorrect_host:1234"}).withBody("some_overridden_body").withSocketAddress("localhost", insecureEchoServer.getPort(), SocketAddress.Scheme.HTTP)).withDelay(TimeUnit.MILLISECONDS, 10L));
        Expectation[] upsertedSecureExpectations = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")).withSecure(Boolean.valueOf(true))).forward((HttpOverrideForwardedRequest)HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)HttpRequest.request().withHeader("Host", new String[]{"incorrect_host:1234"}).withBody("some_overridden_body").withSocketAddress("localhost", secureEchoServer.getPort(), SocketAddress.Scheme.HTTPS)).withDelay(TimeUnit.MILLISECONDS, 10L));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("some_overridden_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")).withSecure(Boolean.valueOf(false))).thenForward((HttpOverrideForwardedRequest)HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)HttpRequest.request().withHeader("Host", new String[]{"incorrect_host:1234"}).withBody("some_overridden_body").withSocketAddress("localhost", insecureEchoServer.getPort(), SocketAddress.Scheme.HTTP)).withDelay(TimeUnit.MILLISECONDS, 10L))));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body_https"})}).withBody("some_overridden_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body_https"})}).withBody("an_example_body_https"), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedSecureExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedSecureExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")).withSecure(Boolean.valueOf(true))).thenForward((HttpOverrideForwardedRequest)HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)HttpRequest.request().withHeader("Host", new String[]{"incorrect_host:1234"}).withBody("some_overridden_body").withSocketAddress("localhost", secureEchoServer.getPort(), SocketAddress.Scheme.HTTPS)).withDelay(TimeUnit.MILLISECONDS, 10L))));
    }

    @Test
    public void shouldForwardTemplateInVelocity() {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).forward((HttpTemplate)HttpTemplate.template((HttpTemplate.TemplateType)HttpTemplate.TemplateType.VELOCITY, (String)("{" + Character.NEW_LINE + "    'path' : \"/somePath\"," + Character.NEW_LINE + "    'headers' : [ {" + Character.NEW_LINE + "        'name' : \"Host\"," + Character.NEW_LINE + "        'values' : [ \"127.0.0.1:" + insecureEchoServer.getPort() + "\" ]" + Character.NEW_LINE + "    }, {" + Character.NEW_LINE + "        'name' : \"x-test\"," + Character.NEW_LINE + "        'values' : [ \"$!request.headers['x-test'][0]\" ]" + Character.NEW_LINE + "    } ]," + Character.NEW_LINE + "    'body': \"{'name': 'value'}\"" + Character.NEW_LINE + "}")).withDelay(TimeUnit.MILLISECONDS, 10L));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("{'name': 'value'}"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).thenForward((HttpTemplate)HttpTemplate.template((HttpTemplate.TemplateType)HttpTemplate.TemplateType.VELOCITY, (String)("{" + Character.NEW_LINE + "    'path' : \"/somePath\"," + Character.NEW_LINE + "    'headers' : [ {" + Character.NEW_LINE + "        'name' : \"Host\"," + Character.NEW_LINE + "        'values' : [ \"127.0.0.1:" + insecureEchoServer.getPort() + "\" ]" + Character.NEW_LINE + "    }, {" + Character.NEW_LINE + "        'name' : \"x-test\"," + Character.NEW_LINE + "        'values' : [ \"$!request.headers['x-test'][0]\" ]" + Character.NEW_LINE + "    } ]," + Character.NEW_LINE + "    'body': \"{'name': 'value'}\"" + Character.NEW_LINE + "}")).withDelay(TimeUnit.MILLISECONDS, 10L))));
    }

    @Test
    public void shouldForwardCallbackClassWithDelay() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).forward((HttpClassCallback)HttpClassCallback.callback().withCallbackClass(PrecannedTestExpectationForwardCallbackRequest.class).withDelay(new Delay(TimeUnit.SECONDS, 2L)));
        long timeBeforeRequest = System.currentTimeMillis();
        HttpResponse httpResponse = this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"}), Header.header((String)"x-echo-server-port", (int)insecureEchoServer.getPort())}).withBody("an_example_body_http"), HEADERS_TO_IGNORE);
        long timeAfterRequest = System.currentTimeMillis();
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("some_overridden_body"), (Object)httpResponse);
        MatcherAssert.assertThat((Object)(timeAfterRequest - timeBeforeRequest), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toMillis(1900L))));
        MatcherAssert.assertThat((Object)(timeAfterRequest - timeBeforeRequest), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.SECONDS.toMillis(4L))));
    }

    @Test
    public void shouldForwardCallbackClassToOverrideRequestInTestClasspathAsClass() {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).forward(HttpClassCallback.callback().withCallbackClass(PrecannedTestExpectationForwardCallbackRequest.class));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("some_overridden_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"}), Header.header((String)"x-echo-server-port", (int)insecureEchoServer.getPort())}).withBody("an_example_body_http"), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).thenForward(HttpClassCallback.callback().withCallbackClass(PrecannedTestExpectationForwardCallbackRequest.class))));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("some_overridden_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"}), Header.header((String)"x-echo-server-port", (int)secureEchoServer.getPort())}).withBody("an_example_body_https"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldForwardCallbackClassToOverrideRequestInTestClasspathAsString() {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).forward(HttpClassCallback.callback().withCallbackClass("org.mockserver.testing.integration.callback.PrecannedTestExpectationForwardCallbackRequest"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("some_overridden_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"}), Header.header((String)"x-echo-server-port", (int)insecureEchoServer.getPort())}).withBody("an_example_body_http"), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).thenForward(HttpClassCallback.callback().withCallbackClass(PrecannedTestExpectationForwardCallbackRequest.class))));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("some_overridden_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"}), Header.header((String)"x-echo-server-port", (int)secureEchoServer.getPort())}).withBody("an_example_body_https"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldForwardCallbackClassToOverrideRequestAndResponseInTestClasspath() {
        Expectation[] upsertedExpectations = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).forward(HttpClassCallback.callback().withCallbackClass(PrecannedTestExpectationForwardCallbackRequestAndResponse.class));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-response-test", (String[])new String[]{"x-response-test"}), Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("some_overidden_response_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"}), Header.header((String)"x-echo-server-port", (int)insecureEchoServer.getPort())}).withBody("an_example_body_http"), HEADERS_TO_IGNORE));
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo"))).thenForward(HttpClassCallback.callback().withCallbackClass(PrecannedTestExpectationForwardCallbackRequestAndResponse.class))));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-response-test", (String[])new String[]{"x-response-test"}), Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("some_overidden_response_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"}), Header.header((String)"x-echo-server-port", (int)secureEchoServer.getPort())}).withBody("an_example_body_https"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldAllowSimultaneousForwardAndResponseExpectations() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("echo")), Times.once()).forward(HttpForward.forward().withHost("127.0.0.1").withPort(insecureEchoServer.getPort()));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("test_headers_and_body")), Times.once()).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("test_headers_and_body")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("test_headers_and_body")), HEADERS_TO_IGNORE));
    }
}

