/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.testing.integration.mock;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Uninterruptibles;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringStartsWith;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockserver.character.Character;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.TimeService;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.MatchType;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.ClearType;
import org.mockserver.model.Cookie;
import org.mockserver.model.Delay;
import org.mockserver.model.Format;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonPathBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.KeyMatchStyle;
import org.mockserver.model.MediaType;
import org.mockserver.model.Not;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.ParameterStyle;
import org.mockserver.model.RegexBody;
import org.mockserver.model.RequestDefinition;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.model.XmlBody;
import org.mockserver.model.XmlSchemaBody;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.serialization.HttpRequestSerializer;
import org.mockserver.serialization.LogEntrySerializer;
import org.mockserver.serialization.java.ExpectationToJavaSerializer;
import org.mockserver.testing.integration.mock.AbstractBasicMockingIntegrationTest;
import org.mockserver.uuid.UUIDService;
import org.mockserver.verify.VerificationTimes;
import org.slf4j.event.Level;

public abstract class AbstractExtendedMockingIntegrationTest
extends AbstractBasicMockingIntegrationTest {
    @BeforeClass
    public static void fixTime() {
        TimeService.fixedTime = true;
    }

    @Test
    public void shouldReturnResponseForRequestInSsl() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withSecure(Boolean.valueOf(true))).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseForRequestNotInSsl() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withSecure(Boolean.valueOf(false))).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPath() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathExactTimes() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingOptionalSchemaQueryStringParameter() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath("/some/path").withQueryStringParameters(new Parameter[]{Parameter.schemaParam((String)"?variableO[a-z]{2}", (String[])new String[]{"{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"variableOneV[a-z]{4}$\"" + Character.NEW_LINE + "}"}), Parameter.schemaParam((String)"?variableTwo", (String[])new String[]{"{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"variableTwoV[a-z]{4}$\"" + Character.NEW_LINE + "}"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/path?variableOne=variableOneValue&variableTwo=variableTwoValue")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/path?variableOne=variableOneValue")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/path?variableTwo=variableTwoValue")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/path?otherVariable=otherVariableValue")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/path?variableOne=otherVariableValue&variableTwo=otherVariableValue")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/path?variableOne=otherVariableValue&variableTwo=variableTwoValue")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/path?variableOne=variableOneValue&variableTwo=otherVariableValue")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/path?variableOne=otherVariableValue")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some/path?variableTwo=otherVariableValue")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingOptionalHeaderWithEitherOr() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader(Header.schemaHeader((String)"headerNameOne|headerNameTwo", (String[])new String[]{"{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"^headerValue[A-z]{3}$\"" + Character.NEW_LINE + "}"})).withHeader(Header.schemaHeader((String)"?headerNameOne", (String[])new String[]{"{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"^headerValueO[a-z]{2}$\"" + Character.NEW_LINE + "}"})).withHeader(Header.schemaHeader((String)"?headerNameTwo", (String[])new String[]{"{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"^headerValueT[a-z]{2}$\"" + Character.NEW_LINE + "}"}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameOne", new String[]{"headerValueOne"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameTwo", new String[]{"headerValueTwo"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameOne", new String[]{"headerValueOne"}).withHeader("headerNameTwo", new String[]{"headerValueTwo"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameOne", new String[]{"headerOtherValue"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameTwo", new String[]{"headerOtherValue"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request(), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingHeaderNotPresent() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader(NottableString.not((String)"Authorization"), new NottableString[]{NottableString.string((String)".*")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withHeader("Authorization", new String[]{"some_value"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withHeader("Authorization", new String[]{"some_value"}).withHeader("SomeHeader", new String[]{"some_other_value"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withHeader("NotAuthorization", new String[]{"some_value"}).withHeader("SomeHeader", new String[]{"some_other_value"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withHeader("SomeHeader", new String[]{"some_other_value"}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingOptionalBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody(JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"name\": \"A \u03c3\u03c0\u03af\u03c4\u03b9 door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}")).withOptional(Boolean.valueOf(true)))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"extra ignored field\": \"some value\"," + Character.NEW_LINE + "    \"name\": \"A \u03c3\u03c0\u03af\u03c4\u03b9 door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"))), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"name\": \"A \u03c3\u03c0\u03af\u03c4\u03b9 door\"," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"))), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithSpaceDelimitedParameters() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)JsonSchemaBody.jsonSchema((String)("{" + Character.NEW_LINE + "    \"$schema\": \"http://json-schema.org/draft-04/schema#\"," + Character.NEW_LINE + "    \"title\": \"Product\"," + Character.NEW_LINE + "    \"type\": \"object\"," + Character.NEW_LINE + "    \"properties\": {" + Character.NEW_LINE + "        \"id\": {" + Character.NEW_LINE + "            \"type\": \"integer\"" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"name\": {" + Character.NEW_LINE + "            \"type\": \"string\"" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"price\": {" + Character.NEW_LINE + "            \"type\": \"number\"," + Character.NEW_LINE + "            \"minimum\": 0," + Character.NEW_LINE + "            \"exclusiveMinimum\": true" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"tags\": {" + Character.NEW_LINE + "            \"type\": \"array\"," + Character.NEW_LINE + "            \"items\": {" + Character.NEW_LINE + "                \"type\": \"string\"" + Character.NEW_LINE + "            }," + Character.NEW_LINE + "            \"minItems\": 1," + Character.NEW_LINE + "            \"maxItems\": 3," + Character.NEW_LINE + "            \"uniqueItems\": true" + Character.NEW_LINE + "        }" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"required\": [\"id\", \"name\", \"price\"]" + Character.NEW_LINE + "}")).withParameterStyles((Map)ImmutableMap.of((Object)"tags", (Object)ParameterStyle.SPACE_DELIMITED)))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withContentType(MediaType.APPLICATION_FORM_URLENCODED).withBody("id=1&name=A+green+door&price=12.5&tags=home+green"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withContentType(MediaType.APPLICATION_FORM_URLENCODED).withBody("id=1&name=A+green+door&price=12.5&tags=home+green+door+book+expensive"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingOptionalParameterBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody(ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterName", (String[])new String[]{"bodyParameterValue"})}).withOptional(Boolean.valueOf(true)))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterName", (String[])new String[]{"bodyParameterValue"})})), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyOtherParameterName", (String[])new String[]{"bodyOtherParameterValue"})})), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingMultipleHeadersWithKeyMatchDefault() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader(Header.schemaHeader((String)"headerNameOne", (String[])new String[]{"{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"^headerValueO[a-z]{2}$\"" + Character.NEW_LINE + "}"})).withHeader(Header.schemaHeader((String)"headerNameTwo", (String[])new String[]{"{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"^headerValueT[a-z]{2}$\"" + Character.NEW_LINE + "}"}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameOne", new String[]{"headerValueOne"}).withHeader("headerNameTwo", new String[]{"headerValueTwo"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameOne", new String[]{"headerValueOne", "headerOtherValueOne"}).withHeader("headerNameTwo", new String[]{"headerValueTwo"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameOne", new String[]{"headerValueOne"}).withHeader("headerNameTwo", new String[]{"headerValueTwo", "headerOtherValueTwo"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameOne", new String[]{"headerValueOne"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameTwo", new String[]{"headerValueTwo"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request(), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingMultipleHeadersWithKeyMatchByKey() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withHeaders(new Headers(new Header[]{Header.schemaHeader((String)"headerNameOne", (String[])new String[]{"{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"^headerValueO[a-z]{2}$\"" + Character.NEW_LINE + "}"}), Header.schemaHeader((String)"headerNameTwo", (String[])new String[]{"{" + Character.NEW_LINE + "   \"type\": \"string\"," + Character.NEW_LINE + "   \"pattern\": \"^headerValueT[a-z]{2}$\"" + Character.NEW_LINE + "}"})}).withKeyMatchStyle(KeyMatchStyle.MATCHING_KEY))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameOne", new String[]{"headerValueOne"}).withHeader("headerNameTwo", new String[]{"headerValueTwo"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameOne", new String[]{"headerValueOne", "headerOtherValueOne"}).withHeader("headerNameTwo", new String[]{"headerValueTwo"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameOne", new String[]{"headerValueOne"}).withHeader("headerNameTwo", new String[]{"headerValueTwo", "headerOtherValueTwo"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameOne", new String[]{"headerValueOne"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withHeader("headerNameTwo", new String[]{"headerValueTwo"}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)this.localNotFoundResponse(), (Object)this.makeRequest(HttpRequest.request(), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathInOrderOfCreationExactTimes() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)1)).respond(HttpResponse.response().withBody("some_body_one"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)1)).respond(HttpResponse.response().withBody("some_body_two"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_one"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_two"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathInOrderOfCreationBeforeExpiry() throws InterruptedException {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.unlimited(), TimeToLive.exactly((TimeUnit)TimeUnit.SECONDS, (Long)2L)).respond(HttpResponse.response().withBody("some_body_one"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.unlimited(), TimeToLive.exactly((TimeUnit)TimeUnit.SECONDS, (Long)4L)).respond(HttpResponse.response().withBody("some_body_two"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_one"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TimeUnit.MILLISECONDS.sleep(2500L);
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_two"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TimeUnit.MILLISECONDS.sleep(2250L);
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathInOrderOfPriorityExactTimes() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)1), TimeToLive.unlimited(), Integer.valueOf(0)).respond(HttpResponse.response().withBody("some_body_one"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)1), TimeToLive.unlimited(), Integer.valueOf(10)).respond(HttpResponse.response().withBody("some_body_two"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_two"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_one"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathInOrderOfPriorityWithNegativePriorities() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)1), TimeToLive.unlimited(), Integer.valueOf(-10)).respond(HttpResponse.response().withBody("some_body_one"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)1), TimeToLive.unlimited(), Integer.valueOf(0)).respond(HttpResponse.response().withBody("some_body_two"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_two"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_one"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathInOrderOfPriorityWithPriorityUpdate() {
        Expectation expectationOne = new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.unlimited(), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body_one")).withId("one");
        Expectation expectationTwo = new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.unlimited(), TimeToLive.unlimited(), 10).thenRespond(HttpResponse.response().withBody("some_body_two")).withId("two");
        Expectation[] upsertedExpectations = mockServerClient.upsert(new Expectation[]{expectationOne, expectationTwo});
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)expectationOne));
        MatcherAssert.assertThat((Object)upsertedExpectations[1], (Matcher)Is.is((Object)expectationTwo));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_two"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        Expectation expectationOneWithHigherPriority = new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.unlimited(), TimeToLive.unlimited(), 15).thenRespond(HttpResponse.response().withBody("some_body_one")).withId("one");
        upsertedExpectations = mockServerClient.upsert(new Expectation[]{expectationOneWithHigherPriority});
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)expectationOneWithHigherPriority));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_one"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathInOrderOfPriorityWithPriorityUpdateAndExactTimes() {
        Expectation expectationOne = new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)1), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body_one"));
        Expectation expectationTwo = new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)1), TimeToLive.unlimited(), 10).thenRespond(HttpResponse.response().withBody("some_body_two"));
        Expectation[] upsertedExpectations = mockServerClient.upsert(new Expectation[]{expectationOne, expectationTwo});
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)expectationOne));
        MatcherAssert.assertThat((Object)upsertedExpectations[1], (Matcher)Is.is((Object)expectationTwo));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_two"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        Expectation expectationOneWithHigherPriority = new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)1), TimeToLive.unlimited(), 15).withId(upsertedExpectations[0].getId()).thenRespond(HttpResponse.response().withBody("some_body_one"));
        upsertedExpectations = mockServerClient.upsert(new Expectation[]{expectationOneWithHigherPriority, expectationTwo});
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)expectationOneWithHigherPriority));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_one"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_two"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathInOrderOfInsertionAfterUpdate() {
        Expectation expectationOne = new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body_one"));
        Expectation expectationTwo = new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)1), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body_two"));
        Expectation[] upsertedExpectations = mockServerClient.upsert(new Expectation[]{expectationOne, expectationTwo});
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)expectationOne));
        MatcherAssert.assertThat((Object)upsertedExpectations[1], (Matcher)Is.is((Object)expectationTwo));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_one"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        Expectation expectationOneWithDifferentBody = new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)1), TimeToLive.unlimited(), 0).withId(upsertedExpectations[0].getId()).withCreated(upsertedExpectations[0].getCreated()).thenRespond(HttpResponse.response().withBody("some_body_one_updated"));
        upsertedExpectations = mockServerClient.upsert(new Expectation[]{expectationOneWithDifferentBody, expectationTwo});
        MatcherAssert.assertThat((Object)upsertedExpectations.length, (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)upsertedExpectations[0], (Matcher)Is.is((Object)expectationOneWithDifferentBody));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_one_updated"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_two"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldUpdateExistingExpectation() {
        Expectation expectationOne = new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path_one"))).thenRespond(HttpResponse.response().withBody("some_body_one"));
        Expectation expectationTwo = new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path_two"))).thenRespond(HttpResponse.response().withBody("some_body_two"));
        mockServerClient.upsert(new Expectation[]{expectationOne, expectationTwo});
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_one"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_two"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_two")), HEADERS_TO_IGNORE));
        Expectation expectationOneUpdated = new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path_updated"))).thenRespond(HttpResponse.response().withBody("some_body_one_updated"));
        mockServerClient.upsert(new Expectation[]{expectationOneUpdated});
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_one_updated"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path_updated")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body_two"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_two")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseWhenTimeToLiveHasNotExpired() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)1), TimeToLive.exactly((TimeUnit)TimeUnit.HOURS, (Long)1L)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnMatchRequestWithBodyInUTF16() {
        String body = "\u6211\u8bf4\u4e2d\u56fd\u8bdd";
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody(body, StandardCharsets.UTF_16)).respond(HttpResponse.response().withBody(body, StandardCharsets.UTF_8));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.PLAIN_TEXT_UTF_8.toString()}).withBody(body, MediaType.PLAIN_TEXT_UTF_8), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("")).withBody(body, StandardCharsets.UTF_16), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnMatchRequestWithBodyInUTF8WithContentTypeHeader() {
        String body = "\u6211\u8bf4\u4e2d\u56fd\u8bdd";
        mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.PLAIN_TEXT_UTF_8.toString()}).withBody(body)).respond(HttpResponse.response().withBody(body, StandardCharsets.UTF_8));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.PLAIN_TEXT_UTF_8.toString()}).withBody(body, MediaType.PLAIN_TEXT_UTF_8), (Object)this.makeRequest(HttpRequest.request().withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.PLAIN_TEXT_UTF_8.toString()}).withPath(this.calculatePath("")).withBody(body, StandardCharsets.UTF_8), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseWithBodyInUTF16() {
        String body = "\u6211\u8bf4\u4e2d\u56fd\u8bdd";
        mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.create((String)"text", (String)"plain").withCharset(StandardCharsets.UTF_16).toString()}).withBody(body)).respond(HttpResponse.response().withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.create((String)"text", (String)"plain").withCharset(StandardCharsets.UTF_16).toString()}).withBody(body, StandardCharsets.UTF_16));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.create((String)"text", (String)"plain").withCharset(StandardCharsets.UTF_16).toString()}).withBody(body, StandardCharsets.UTF_16), (Object)this.makeRequest(HttpRequest.request().withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.create((String)"text", (String)"plain").withCharset(StandardCharsets.UTF_16).toString()}).withPath(this.calculatePath("")).withBody(body), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseWithBodyInUTF8WithContentTypeHeader() {
        String body = "\u6211\u8bf4\u4e2d\u56fd\u8bdd";
        mockServerClient.when((RequestDefinition)HttpRequest.request()).respond(HttpResponse.response().withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.PLAIN_TEXT_UTF_8.toString()}).withBody(body));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.PLAIN_TEXT_UTF_8.toString()}).withBody(body, MediaType.PLAIN_TEXT_UTF_8), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseWithBodyInUTF8WithNoContentTypeHeader() {
        String body = "\u6211\u8bf4\u4e2d\u56fd\u8bdd";
        mockServerClient.when((RequestDefinition)HttpRequest.request()).respond(HttpResponse.response().withBody(body, StandardCharsets.UTF_8));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.PLAIN_TEXT_UTF_8.toString()}).withBody(body, StandardCharsets.UTF_8), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingSubStringBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)StringBody.subString((String)"random")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_sub_string_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_sub_string_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_path")).withBody("some_random_body"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingNotRegexBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withBody((Body)Body.not((Not)RegexBody.regex((String)"10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")))).respond(HttpResponse.response().withBody("some_not_regex_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withBody("10.2.3.123"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_not_regex_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withBody("10.2.3.1234"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingNotSubStringBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withBody((Body)Body.not((Not)StringBody.subString((String)"some_body")))).respond(HttpResponse.response().withBody("some_not_regex_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withBody("some_body_full_string"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_not_regex_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withBody("some_other_body_full_string"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingNotExactBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withBody((Body)Body.not((Not)StringBody.exact((String)"some_body")))).respond(HttpResponse.response().withBody("some_not_regex_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withBody("some_body"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_not_regex_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withBody("some_other_body"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithXPath() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)XPathBody.xpath((String)"/bookstore/book[price>30]/price")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + Character.NEW_LINE + "<bookstore>" + Character.NEW_LINE + "  <book category=\"COOKING\">" + Character.NEW_LINE + "    <title lang=\"en\">Everyday Italian</title>" + Character.NEW_LINE + "    <author>Giada De Laurentiis</author>" + Character.NEW_LINE + "    <year>2005</year>" + Character.NEW_LINE + "    <price>30.00</price>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "  <book category=\"CHILDREN\">" + Character.NEW_LINE + "    <title lang=\"en\">Harry Potter</title>" + Character.NEW_LINE + "    <author>J K. Rowling</author>" + Character.NEW_LINE + "    <year>2005</year>" + Character.NEW_LINE + "    <price>29.99</price>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "  <book category=\"WEB\">" + Character.NEW_LINE + "    <title lang=\"en\">Learning XML</title>" + Character.NEW_LINE + "    <author>Erik T. Ray</author>" + Character.NEW_LINE + "    <year>2003</year>" + Character.NEW_LINE + "    <price>31.95</price>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "</bookstore>")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithXmlSchema() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)XmlSchemaBody.xmlSchema((String)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + Character.NEW_LINE + "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">" + Character.NEW_LINE + "    <!-- XML Schema Generated from XML Document on Wed Jun 28 2017 21:52:45 GMT+0100 (BST) -->" + Character.NEW_LINE + "    <!-- with XmlGrid.net Free Online Service http://xmlgrid.net -->" + Character.NEW_LINE + "    <xs:element name=\"notes\">" + Character.NEW_LINE + "        <xs:complexType>" + Character.NEW_LINE + "            <xs:sequence>" + Character.NEW_LINE + "                <xs:element name=\"note\" maxOccurs=\"unbounded\">" + Character.NEW_LINE + "                    <xs:complexType>" + Character.NEW_LINE + "                        <xs:sequence>" + Character.NEW_LINE + "                            <xs:element name=\"to\" minOccurs=\"1\" maxOccurs=\"1\" type=\"xs:string\"></xs:element>" + Character.NEW_LINE + "                            <xs:element name=\"from\" minOccurs=\"1\" maxOccurs=\"1\" type=\"xs:string\"></xs:element>" + Character.NEW_LINE + "                            <xs:element name=\"heading\" minOccurs=\"1\" maxOccurs=\"1\" type=\"xs:string\"></xs:element>" + Character.NEW_LINE + "                            <xs:element name=\"body\" minOccurs=\"1\" maxOccurs=\"1\" type=\"xs:string\"></xs:element>" + Character.NEW_LINE + "                        </xs:sequence>" + Character.NEW_LINE + "                    </xs:complexType>" + Character.NEW_LINE + "                </xs:element>" + Character.NEW_LINE + "            </xs:sequence>" + Character.NEW_LINE + "        </xs:complexType>" + Character.NEW_LINE + "    </xs:element>" + Character.NEW_LINE + "</xs:schema>"))), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withBody("<?xml version=\"1.0\" encoding=\"utf-8\"?>" + Character.NEW_LINE + "<notes>" + Character.NEW_LINE + "    <note>" + Character.NEW_LINE + "        <to>Bob</to>" + Character.NEW_LINE + "        <heading>Reminder</heading>" + Character.NEW_LINE + "        <body>Buy Bread</body>" + Character.NEW_LINE + "    </note>" + Character.NEW_LINE + "    <note>" + Character.NEW_LINE + "        <to>Jack</to>" + Character.NEW_LINE + "        <from>Jill</from>" + Character.NEW_LINE + "        <heading>Reminder</heading>" + Character.NEW_LINE + "        <body>Wash Shirts</body>" + Character.NEW_LINE + "    </note>" + Character.NEW_LINE + "</notes>"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("<?xml version=\"1.0\" encoding=\"utf-8\"?>" + Character.NEW_LINE + "<notes>" + Character.NEW_LINE + "    <note>" + Character.NEW_LINE + "        <to>Bob</to>" + Character.NEW_LINE + "        <from>Bill</from>" + Character.NEW_LINE + "        <heading>Reminder</heading>" + Character.NEW_LINE + "        <body>Buy Bread</body>" + Character.NEW_LINE + "    </note>" + Character.NEW_LINE + "    <note>" + Character.NEW_LINE + "        <to>Jack</to>" + Character.NEW_LINE + "        <from>Jill</from>" + Character.NEW_LINE + "        <heading>Reminder</heading>" + Character.NEW_LINE + "        <body>Wash Shirts</body>" + Character.NEW_LINE + "    </note>" + Character.NEW_LINE + "</notes>"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithXmlSchemaByClasspath() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)XmlSchemaBody.xmlSchemaFromResource((String)"org/mockserver/model/testXmlSchema.xsd")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withBody("<?xml version=\"1.0\" encoding=\"utf-8\"?>" + Character.NEW_LINE + "<notes>" + Character.NEW_LINE + "    <note>" + Character.NEW_LINE + "        <to>Bob</to>" + Character.NEW_LINE + "        <heading>Reminder</heading>" + Character.NEW_LINE + "        <body>Buy Bread</body>" + Character.NEW_LINE + "    </note>" + Character.NEW_LINE + "    <note>" + Character.NEW_LINE + "        <to>Jack</to>" + Character.NEW_LINE + "        <from>Jill</from>" + Character.NEW_LINE + "        <heading>Reminder</heading>" + Character.NEW_LINE + "        <body>Wash Shirts</body>" + Character.NEW_LINE + "    </note>" + Character.NEW_LINE + "</notes>"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("<?xml version=\"1.0\" encoding=\"utf-8\"?>" + Character.NEW_LINE + "<notes>" + Character.NEW_LINE + "    <note>" + Character.NEW_LINE + "        <to>Bob</to>" + Character.NEW_LINE + "        <from>Bill</from>" + Character.NEW_LINE + "        <heading>Reminder</heading>" + Character.NEW_LINE + "        <body>Buy Bread</body>" + Character.NEW_LINE + "    </note>" + Character.NEW_LINE + "    <note>" + Character.NEW_LINE + "        <to>Jack</to>" + Character.NEW_LINE + "        <from>Jill</from>" + Character.NEW_LINE + "        <heading>Reminder</heading>" + Character.NEW_LINE + "        <body>Wash Shirts</body>" + Character.NEW_LINE + "    </note>" + Character.NEW_LINE + "</notes>"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithXmlWithSpecialCharactersDefaultingToUTF8() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)XmlBody.xml((String)("<bookstore>" + Character.NEW_LINE + "  <book nationality=\"ITALIAN\" category=\"COOKING\"><title lang=\"en\">Everyday Italian</title><author>\u00c4\u00d1\u00e7\u00ee\u00fc\u00cf</author><year>2005</year><price>30.00</price></book>" + Character.NEW_LINE + "</bookstore>"))), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + Character.NEW_LINE + "<bookstore>" + Character.NEW_LINE + "  <book category=\"COOKING\" nationality=\"ITALIAN\">" + Character.NEW_LINE + "    <title lang=\"en\">Everyday Italian</title>" + Character.NEW_LINE + "    <author>\u00c4\u00d1\u00e7\u00ee\u00fc\u00cf</author>" + Character.NEW_LINE + "    <year>2005</year>" + Character.NEW_LINE + "    <price>30.00</price>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "</bookstore>")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithXmlWithSpecialCharactersAndCharset() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)XmlBody.xml((String)("<bookstore>" + Character.NEW_LINE + "  <book nationality=\"ITALIAN\" category=\"COOKING\"><title>Everyday Italian</title><author>\u6211\u8bf4\u4e2d\u56fd\u8bdd</author></book>" + Character.NEW_LINE + "</bookstore>"), (Charset)StandardCharsets.UTF_8)), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withHeader("Content-Type", new String[]{"application/xml; charset=utf-8"}).withBody((Body)new StringBody("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + Character.NEW_LINE + "<bookstore>" + Character.NEW_LINE + "  <book category=\"COOKING\" nationality=\"ITALIAN\">" + Character.NEW_LINE + "    <title>Everyday Italian</title>" + Character.NEW_LINE + "    <author>\u6211\u8bf4\u4e2d\u56fd\u8bdd</author>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "</bookstore>")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithXmlWithSpecialCharactersClientCharsetDifferent() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)XmlBody.xml((String)("<bookstore>" + Character.NEW_LINE + "  <book nationality=\"ITALIAN\" category=\"COOKING\"><title>Everyday Italian</title><author>\u00c4\u00d1\u00e7\u00ee\u00fc\u00cf</author></book>" + Character.NEW_LINE + "</bookstore>"), (Charset)StandardCharsets.UTF_8)), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withHeader("Content-Type", new String[]{"application/xml; charset=" + StandardCharsets.ISO_8859_1.name()}).withBody((Body)BinaryBody.binary((byte[])("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + Character.NEW_LINE + "<bookstore>" + Character.NEW_LINE + "  <book category=\"COOKING\" nationality=\"ITALIAN\">" + Character.NEW_LINE + "    <title>Everyday Italian</title>" + Character.NEW_LINE + "    <author>\u00c4\u00d1\u00e7\u00ee\u00fc\u00cf</author>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "</bookstore>").getBytes(StandardCharsets.ISO_8859_1))), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnXmlResponseWithUTF8() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody("some_body"), Times.exactly((int)2)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody((BodyWithContentType)XmlBody.xml((String)("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + Character.NEW_LINE + "<bookstore>" + Character.NEW_LINE + "  <book category=\"COOKING\" nationality=\"ITALIAN\">" + Character.NEW_LINE + "    <title>Everyday Italian</title>" + Character.NEW_LINE + "    <author>\u00c4\u00d1\u00e7\u00ee\u00fc\u00cf</author>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "</bookstore>"))));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withHeader("content-type", new String[]{"application/xml; charset=utf-8"}).withBody((BodyWithContentType)XmlBody.xml((String)("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + Character.NEW_LINE + "<bookstore>" + Character.NEW_LINE + "  <book category=\"COOKING\" nationality=\"ITALIAN\">" + Character.NEW_LINE + "    <title>Everyday Italian</title>" + Character.NEW_LINE + "    <author>\u00c4\u00d1\u00e7\u00ee\u00fc\u00cf</author>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "</bookstore>"))), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("some_body"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonWithSpecialCharactersDefaultingToUTF8() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"name\": \"A \u03c3\u03c0\u03af\u03c4\u03b9 door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"))), Times.exactly((int)2)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"extra ignored field\": \"some value\"," + Character.NEW_LINE + "    \"name\": \"A \u03c3\u03c0\u03af\u03c4\u03b9 door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"))), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonAsRawBody() {
        this.makeRequest(HttpRequest.request().withPath(this.calculatePath("mockserver/expectation")).withMethod("PUT").withBody("{" + Character.NEW_LINE + "  \"httpRequest\" : {" + Character.NEW_LINE + "    \"body\" : {" + Character.NEW_LINE + "        \"id\": 1," + Character.NEW_LINE + "        \"name\": \"A green door\"," + Character.NEW_LINE + "        \"price\": 12.50," + Character.NEW_LINE + "        \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "    }" + Character.NEW_LINE + "  }," + Character.NEW_LINE + "  \"httpResponse\" : {" + Character.NEW_LINE + "    \"body\" : {" + Character.NEW_LINE + "        \"id\": 1," + Character.NEW_LINE + "        \"name\": \"A green door\"," + Character.NEW_LINE + "        \"price\": 12.50," + Character.NEW_LINE + "        \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "    }" + Character.NEW_LINE + "  }" + Character.NEW_LINE + "}"), HEADERS_TO_IGNORE);
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.APPLICATION_JSON_UTF_8.toString()}).withBody((BodyWithContentType)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"id\" : 1," + Character.NEW_LINE + "  \"name\" : \"A green door\"," + Character.NEW_LINE + "  \"price\" : 12.5," + Character.NEW_LINE + "  \"tags\" : [ \"home\", \"green\" ]" + Character.NEW_LINE + "}"))), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + Character.NEW_LINE + "  \"id\" : 1," + Character.NEW_LINE + "  \"name\" : \"A green door\"," + Character.NEW_LINE + "  \"price\" : 12.5," + Character.NEW_LINE + "  \"tags\" : [ \"home\", \"green\" ]" + Character.NEW_LINE + "}"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonWithBlankFields() {
        this.makeRequest(HttpRequest.request().withPath(this.calculatePath("mockserver/expectation")).withMethod("PUT").withBody("{" + Character.NEW_LINE + "  \"httpRequest\" : {" + Character.NEW_LINE + "    \"body\" : {" + Character.NEW_LINE + "        \"id\": 1," + Character.NEW_LINE + "        \"name\": \"\"," + Character.NEW_LINE + "        \"price\": 0," + Character.NEW_LINE + "        \"null\": null," + Character.NEW_LINE + "        \"tags\": []" + Character.NEW_LINE + "    }" + Character.NEW_LINE + "  }," + Character.NEW_LINE + "  \"httpResponse\" : {" + Character.NEW_LINE + "    \"body\" : {" + Character.NEW_LINE + "        \"id\": 1," + Character.NEW_LINE + "        \"name\": \"\"," + Character.NEW_LINE + "        \"price\": 0," + Character.NEW_LINE + "        \"null\": null," + Character.NEW_LINE + "        \"tags\": []" + Character.NEW_LINE + "    }" + Character.NEW_LINE + "  }" + Character.NEW_LINE + "}"), HEADERS_TO_IGNORE);
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.APPLICATION_JSON_UTF_8.toString()}).withBody((BodyWithContentType)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"id\" : 1," + Character.NEW_LINE + "  \"name\" : \"\"," + Character.NEW_LINE + "  \"price\" : 0," + Character.NEW_LINE + "  \"null\" : null," + Character.NEW_LINE + "  \"tags\" : [ ]" + Character.NEW_LINE + "}"))), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"id\" : 1," + Character.NEW_LINE + "  \"name\" : \"\"," + Character.NEW_LINE + "  \"price\" : 0," + Character.NEW_LINE + "  \"null\" : null," + Character.NEW_LINE + "  \"tags\" : [ ]" + Character.NEW_LINE + "}"))), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonWithCharsetUTF16() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + Character.NEW_LINE + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + Character.NEW_LINE + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + Character.NEW_LINE + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + Character.NEW_LINE + "}"), (Charset)StandardCharsets.UTF_16, (MatchType)MatchType.ONLY_MATCHING_FIELDS)), Times.exactly((int)2)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + Character.NEW_LINE + "    \"\u03b5\u03c0\u03b9\u03c0\u03bb\u03ad\u03bf\u03bd \u03b1\u03b3\u03bd\u03bf\u03bf\u03cd\u03bd\u03c4\u03b1\u03b9 \u03c4\u03bf\u03bc\u03ad\u03b1\": \"\u03ba\u03ac\u03c0\u03bf\u03b9\u03b1 \u03b1\u03be\u03af\u03b1\"," + Character.NEW_LINE + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + Character.NEW_LINE + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + Character.NEW_LINE + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + Character.NEW_LINE + "}"), (Charset)StandardCharsets.UTF_16, (MatchType)MatchType.ONLY_MATCHING_FIELDS)), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonWithContentTypeHeaderAndCharsetUTF16() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + Character.NEW_LINE + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + Character.NEW_LINE + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + Character.NEW_LINE + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + Character.NEW_LINE + "}"), (Charset)StandardCharsets.UTF_16, (MatchType)MatchType.ONLY_MATCHING_FIELDS)), Times.exactly((int)2)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MediaType.create((String)"text", (String)"plain").withCharset(StandardCharsets.UTF_16).toString()}).withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + Character.NEW_LINE + "    \"\u03b5\u03c0\u03b9\u03c0\u03bb\u03ad\u03bf\u03bd \u03b1\u03b3\u03bd\u03bf\u03bf\u03cd\u03bd\u03c4\u03b1\u03b9 \u03c4\u03bf\u03bc\u03ad\u03b1\": \"\u03ba\u03ac\u03c0\u03bf\u03b9\u03b1 \u03b1\u03be\u03af\u03b1\"," + Character.NEW_LINE + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + Character.NEW_LINE + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + Character.NEW_LINE + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + Character.NEW_LINE + "}"), (Charset)StandardCharsets.UTF_16)), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonWithUTF8() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + Character.NEW_LINE + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + Character.NEW_LINE + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + Character.NEW_LINE + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + Character.NEW_LINE + "}"), (MatchType)MatchType.ONLY_MATCHING_FIELDS)), Times.exactly((int)2)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + Character.NEW_LINE + "    \"\u03b5\u03c0\u03b9\u03c0\u03bb\u03ad\u03bf\u03bd \u03b1\u03b3\u03bd\u03bf\u03bf\u03cd\u03bd\u03c4\u03b1\u03b9 \u03c4\u03bf\u03bc\u03ad\u03b1\": \"\u03ba\u03ac\u03c0\u03bf\u03b9\u03b1 \u03b1\u03be\u03af\u03b1\"," + Character.NEW_LINE + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + Character.NEW_LINE + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + Character.NEW_LINE + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + Character.NEW_LINE + "}"), (Charset)StandardCharsets.UTF_8)), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonWithNoCharset() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + Character.NEW_LINE + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + Character.NEW_LINE + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + Character.NEW_LINE + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + Character.NEW_LINE + "}"), (MatchType)MatchType.ONLY_MATCHING_FIELDS)), Times.exactly((int)2)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + Character.NEW_LINE + "    \"\u03b5\u03c0\u03b9\u03c0\u03bb\u03ad\u03bf\u03bd \u03b1\u03b3\u03bd\u03bf\u03bf\u03cd\u03bd\u03c4\u03b1\u03b9 \u03c4\u03bf\u03bc\u03ad\u03b1\": \"\u03ba\u03ac\u03c0\u03bf\u03b9\u03b1 \u03b1\u03be\u03af\u03b1\"," + Character.NEW_LINE + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + Character.NEW_LINE + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + Character.NEW_LINE + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + Character.NEW_LINE + "}"))), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnJsonResponseWithJsonWithUTF8() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody("some_body"), Times.exactly((int)2)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody((BodyWithContentType)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + Character.NEW_LINE + "  \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + Character.NEW_LINE + "  \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + Character.NEW_LINE + "  \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + Character.NEW_LINE + "}"))));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withHeader("content-type", new String[]{"application/json; charset=utf-8"}).withBody((BodyWithContentType)JsonBody.json((String)("{" + Character.NEW_LINE + "  \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\" : 1," + Character.NEW_LINE + "  \"\u03cc\u03bd\u03bf\u03bc\u03b1\" : \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + Character.NEW_LINE + "  \"\u03c4\u03b9\u03bc\u03ae\" : 12.5," + Character.NEW_LINE + "  \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\" : [ \"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\" ]" + Character.NEW_LINE + "}"))), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("some_body"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonWithMatchType() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"name\": \"A green door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"), (MatchType)MatchType.ONLY_MATCHING_FIELDS)), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"extra field\": \"some value\"," + Character.NEW_LINE + "    \"name\": \"A green door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonSchema() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)JsonSchemaBody.jsonSchema((String)("{" + Character.NEW_LINE + "    \"$schema\": \"http://json-schema.org/draft-04/schema#\"," + Character.NEW_LINE + "    \"title\": \"Product\"," + Character.NEW_LINE + "    \"type\": \"object\"," + Character.NEW_LINE + "    \"properties\": {" + Character.NEW_LINE + "        \"id\": {" + Character.NEW_LINE + "            \"type\": \"integer\"" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"name\": {" + Character.NEW_LINE + "            \"type\": \"string\"" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"price\": {" + Character.NEW_LINE + "            \"type\": \"number\"," + Character.NEW_LINE + "            \"minimum\": 0," + Character.NEW_LINE + "            \"exclusiveMinimum\": true" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"tags\": {" + Character.NEW_LINE + "            \"type\": \"array\"," + Character.NEW_LINE + "            \"items\": {" + Character.NEW_LINE + "                \"type\": \"string\"" + Character.NEW_LINE + "            }," + Character.NEW_LINE + "            \"minItems\": 1," + Character.NEW_LINE + "            \"uniqueItems\": true" + Character.NEW_LINE + "        }" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"required\": [\"id\", \"name\", \"price\"]" + Character.NEW_LINE + "}"))), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"name\": \"A green door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonPath() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)JsonPathBody.jsonPath((String)"$..book[?(@.price <= $['expensive'])]")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("{" + Character.NEW_LINE + "    \"store\": {" + Character.NEW_LINE + "        \"book\": [" + Character.NEW_LINE + "            {" + Character.NEW_LINE + "                \"category\": \"reference\"," + Character.NEW_LINE + "                \"author\": \"Nigel Rees\"," + Character.NEW_LINE + "                \"title\": \"Sayings of the Century\"," + Character.NEW_LINE + "                \"price\": 8.95" + Character.NEW_LINE + "            }," + Character.NEW_LINE + "            {" + Character.NEW_LINE + "                \"category\": \"fiction\"," + Character.NEW_LINE + "                \"author\": \"Herman Melville\"," + Character.NEW_LINE + "                \"title\": \"Moby Dick\"," + Character.NEW_LINE + "                \"isbn\": \"0-553-21311-3\"," + Character.NEW_LINE + "                \"price\": 8.99" + Character.NEW_LINE + "            }" + Character.NEW_LINE + "        ]," + Character.NEW_LINE + "        \"bicycle\": {" + Character.NEW_LINE + "            \"color\": \"red\"," + Character.NEW_LINE + "            \"price\": 19.95" + Character.NEW_LINE + "        }" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"expensive\": 10" + Character.NEW_LINE + "}")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnPDFResponseByMatchingPath() throws IOException {
        byte[] pdfBytes = IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.pdf"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("ws/rest/user/[0-9]+/document/[0-9]+\\.pdf"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{MediaType.PDF.toString()}), Header.header((String)HttpHeaderNames.CONTENT_DISPOSITION.toString(), (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)HttpHeaderNames.CACHE_CONTROL.toString(), (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"})}).withBody((BodyWithContentType)BinaryBody.binary((byte[])pdfBytes)));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)HttpHeaderNames.CONTENT_DISPOSITION.toString(), (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)HttpHeaderNames.CACHE_CONTROL.toString(), (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"}), Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{MediaType.PDF.toString()})}).withBody((BodyWithContentType)BinaryBody.binary((byte[])pdfBytes, (MediaType)MediaType.PDF)), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/1/document/2.pdf")).withMethod("GET"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnPNGResponseByMatchingPath() throws IOException {
        byte[] pngBytes = IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.png"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("ws/rest/user/[0-9]+/icon/[0-9]+\\.png"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{MediaType.PNG.toString()}), Header.header((String)HttpHeaderNames.CONTENT_DISPOSITION.toString(), (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""})}).withBody((BodyWithContentType)BinaryBody.binary((byte[])pngBytes)));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)HttpHeaderNames.CONTENT_DISPOSITION.toString(), (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""}), Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{MediaType.PNG.toString()})}).withBody((BodyWithContentType)BinaryBody.binary((byte[])pngBytes, (MediaType)MediaType.PNG)), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/1/icon/1.png")).withMethod("GET"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnPDFResponseByMatchingBinaryPDFBody() throws IOException {
        byte[] pdfBytes = IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.pdf"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)BinaryBody.binary((byte[])pdfBytes, (MediaType)MediaType.PDF))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{MediaType.PDF.toString()}), Header.header((String)HttpHeaderNames.CONTENT_DISPOSITION.toString(), (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)HttpHeaderNames.CACHE_CONTROL.toString(), (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"})}).withBody((BodyWithContentType)BinaryBody.binary((byte[])pdfBytes)));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)HttpHeaderNames.CONTENT_DISPOSITION.toString(), (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)HttpHeaderNames.CACHE_CONTROL.toString(), (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"}), Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{MediaType.PDF.toString()})}).withBody((BodyWithContentType)BinaryBody.binary((byte[])pdfBytes, (MediaType)MediaType.PDF)), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/1/document/2.pdf")).withBody((Body)BinaryBody.binary((byte[])pdfBytes, (MediaType)MediaType.PDF)).withMethod("POST"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnPNGResponseByMatchingBinaryPNGBody() throws IOException {
        byte[] pngBytes = IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.png"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)BinaryBody.binary((byte[])pngBytes, (MediaType)MediaType.ANY_IMAGE_TYPE))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{MediaType.PNG.toString()}), Header.header((String)HttpHeaderNames.CONTENT_DISPOSITION.toString(), (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""})}).withBody((BodyWithContentType)BinaryBody.binary((byte[])pngBytes)));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withHeaders(new Header[]{Header.header((String)HttpHeaderNames.CONTENT_DISPOSITION.toString(), (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""}), Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{MediaType.PNG.toString()})}).withBody((BodyWithContentType)BinaryBody.binary((byte[])pngBytes, (MediaType)MediaType.PNG)), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/1/icon/1.png")).withBody((Body)BinaryBody.binary((byte[])pngBytes, (MediaType)MediaType.ANY_IMAGE_TYPE)).withMethod("POST"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByNotMatchingPathWithNotOperator() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(NottableString.not((String)this.calculatePath("some_path")))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_other_path")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByNotMatchingMethodWithNotOperator() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod(NottableString.not((String)"GET"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody("some_bodyRequest")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndQueryStringParameters() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)HttpHeaderNames.SET_COOKIE.toString(), (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndHeaders() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne_One", "requestHeaderValueOne_Two"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)HttpHeaderNames.SET_COOKIE.toString(), (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne_One", "requestHeaderValueOne_Two"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndCookies() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"requestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"responseCookieNameOne", (String)"responseCookieValueOne"), Cookie.cookie((String)"responseCookieNameTwo", (String)"responseCookieValueTwo")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"responseCookieNameOne", (String)"responseCookieValueOne"), Cookie.cookie((String)"responseCookieNameTwo", (String)"responseCookieValueTwo")}).withHeaders(new Header[]{Header.header((String)HttpHeaderNames.SET_COOKIE.toString(), (String[])new String[]{"responseCookieNameOne=responseCookieValueOne", "responseCookieNameTwo=responseCookieValueTwo"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"}), Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{MediaType.create((String)"text", (String)"plain").toString()})}).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"requestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"responseCookieNameOne", (String)"responseCookieValueOne"), Cookie.cookie((String)"responseCookieNameTwo", (String)"responseCookieValueTwo")}).withHeaders(new Header[]{Header.header((String)HttpHeaderNames.SET_COOKIE.toString(), (String[])new String[]{"responseCookieNameOne=responseCookieValueOne", "responseCookieNameTwo=responseCookieValueTwo"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"}), Header.header((String)"Cookie", (String[])new String[]{"requestCookieNameOne=requestCookieValueOne; requestCookieNameTwo=requestCookieValueTwo"})}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndQueryStringParametersAndBodyParameters() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterName", (String[])new String[]{"bodyParameterValue"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterName", (String[])new String[]{"bodyParameterValue"})})), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterName", (String[])new String[]{"bodyParameterValue"})})), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndQueryStringParametersAndBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)HttpHeaderNames.SET_COOKIE.toString(), (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)HttpHeaderNames.SET_COOKIE.toString(), (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)HttpHeaderNames.SET_COOKIE.toString(), (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndBodyParameters() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)HttpHeaderNames.SET_COOKIE.toString(), (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)HttpHeaderNames.SET_COOKIE.toString(), (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterTwoName=Parameter+Two&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterOneName=Parameter+One+Value+One")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)HttpHeaderNames.SET_COOKIE.toString(), (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)HttpHeaderNames.SET_COOKIE.toString(), (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"}), Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value Two", "Parameter One Value One"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndParametersAndHeadersAndCookies() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)HttpHeaderNames.SET_COOKIE.toString(), (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"}), Header.header((String)"Cookie", (String[])new String[]{"cookieNameRequest=cookieValueRequest"})}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)HttpHeaderNames.SET_COOKIE.toString(), (String[])new String[]{"cookieNameResponse=cookieValueResponse"})}), (Object)this.makeRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByNotMatchingBodyParameterWithNotOperatorForName() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((NottableString)NottableString.not((String)"bodyParameterOneName"), (NottableString[])new NottableString[]{NottableString.string((String)"Parameter One Value One"), NottableString.string((String)"Parameter One Value Two")}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"OTHERBodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("OTHERBodyParameterOneName=Parameter+One+Value+One&OTHERBodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByNotMatchingBodyParameterWithNotOperatorForValue() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((NottableString)NottableString.string((String)"bodyParameterOneName"), (NottableString[])new NottableString[]{NottableString.string((String)"!Parameter One Value One"), NottableString.not((String)"Parameter One Value Two")}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Other Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Other+Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Other Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Parameter+One+Value+One&bodyParameterOneName=Other+Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Other Parameter One Value One", "Other Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Other+Parameter+One+Value+One&bodyParameterOneName=Other+Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByNotMatchingQueryStringParameterWithNotOperatorForNameAndValue() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((NottableString)NottableString.string((String)"queryStringParameterOneName"), (NottableString[])new NottableString[]{NottableString.not((String)"Parameter One Value One"), NottableString.string((String)"!Parameter One Value Two")}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"Other Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"Parameter One Value One", "Other Parameter One Value Two"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByNotMatchingQueryStringParameterWithNotOperatorForName() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((NottableString)NottableString.not((String)"queryStringParameterOneName"), (NottableString[])new NottableString[]{NottableString.string((String)"Parameter One Value One"), NottableString.string((String)"Parameter One Value Two")}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"OTHERQueryStringParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByNotMatchingQueryStringParameterWithNotOperatorForValue() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((NottableString)NottableString.string((String)"queryStringParameterOneName"), (NottableString[])new NottableString[]{NottableString.not((String)"Parameter One Value One"), NottableString.string((String)"!Parameter One Value Two")}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"Other Parameter One Value One", "Other Parameter One Value Two"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByNotMatchingCookieWithNotOperatorForNameAndValue() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"!requestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"OTHERrequestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByNotMatchingCookieWithNotOperatorForName() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((NottableString)NottableString.not((String)"requestCookieNameOne"), (NottableString)NottableString.string((String)"requestCookieValueOne")), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"OTHERrequestCookieNameOne", (String)"requestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByNotMatchingCookieWithNotOperatorForValue() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((NottableString)NottableString.string((String)"requestCookieNameOne"), (NottableString)NottableString.not((String)"requestCookieValueOne")), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"OTHERrequestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByNotMatchingHeaderWithNotOperatorForNameAndValue() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((NottableString)NottableString.not((String)"requestHeaderNameOne"), (NottableString[])new NottableString[]{NottableString.not((String)"requestHeaderValueOne")}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"OTHERrequestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"OTHERrequestHeaderNameOne", (String[])new String[]{"OTHERrequestHeaderValueOne"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByNotMatchingHeaderWithNotOperatorForName() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((NottableString)NottableString.not((String)"requestHeaderNameOne"), (NottableString[])new NottableString[]{NottableString.string((String)"requestHeaderValueOne")}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"OTHERrequestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldReturnResponseByNotMatchingHeaderWithNotOperatorForValue() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((NottableString)NottableString.string((String)"requestHeaderNameOne"), (NottableString[])new NottableString[]{NottableString.not((String)"requestHeaderValueOne")}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"OTHERrequestHeaderValueOne"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForWhenTimeToLiveExpired() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2), TimeToLive.exactly((TimeUnit)TimeUnit.SECONDS, (Long)3L)).respond((HttpResponse)HttpResponse.response().withBody("some_body").withDelay(TimeUnit.SECONDS, 3L));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForMatchingBodyWithNotOperator() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)Not.not((Not)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"name\": \"A green door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}")))), Times.exactly((int)2)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"extra_ignored_field\": \"some value\"," + Character.NEW_LINE + "    \"name\": \"A green door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingXPathBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)new XPathBody("/bookstore/book[price>35]/price")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + Character.NEW_LINE + "<bookstore>" + Character.NEW_LINE + "  <book category=\"COOKING\">" + Character.NEW_LINE + "    <title lang=\"en\">Everyday Italian</title>" + Character.NEW_LINE + "    <author>Giada De Laurentiis</author>" + Character.NEW_LINE + "    <year>2005</year>" + Character.NEW_LINE + "    <price>30.00</price>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "  <book category=\"CHILDREN\">" + Character.NEW_LINE + "    <title lang=\"en\">Harry Potter</title>" + Character.NEW_LINE + "    <author>J K. Rowling</author>" + Character.NEW_LINE + "    <year>2005</year>" + Character.NEW_LINE + "    <price>29.99</price>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "  <book category=\"WEB\">" + Character.NEW_LINE + "    <title lang=\"en\">Learning XML</title>" + Character.NEW_LINE + "    <author>Erik T. Ray</author>" + Character.NEW_LINE + "    <year>2003</year>" + Character.NEW_LINE + "    <price>31.95</price>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "</bookstore>")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingXmlBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)XmlBody.xml((String)("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + Character.NEW_LINE + "<bookstore>" + Character.NEW_LINE + "  <book category=\"COOKING\" nationality=\"ITALIAN\">" + Character.NEW_LINE + "    <title lang=\"en\">Everyday Italian</title>" + Character.NEW_LINE + "    <author>Giada De Laurentiis</author>" + Character.NEW_LINE + "    <year>2005</year>" + Character.NEW_LINE + "    <price>30.00</price>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "</bookstore>"))), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + Character.NEW_LINE + "<bookstore>" + Character.NEW_LINE + "  <book category=\"COOKING\">" + Character.NEW_LINE + "    <title lang=\"en\">Everyday Italian</title>" + Character.NEW_LINE + "    <author>Giada De Laurentiis</author>" + Character.NEW_LINE + "    <year>2005</year>" + Character.NEW_LINE + "    <price>30.00</price>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "</bookstore>")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingJsonBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"name\": \"A green door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"))), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"name\": \"---- XXXX WRONG VALUE XXXX ----\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingJsonBodyWithMatchType() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"name\": \"A green door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"), (MatchType)MatchType.STRICT)), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"extra field\": \"some value\"," + Character.NEW_LINE + "    \"name\": \"A green door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingJsonSchema() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)JsonSchemaBody.jsonSchema((String)("{" + Character.NEW_LINE + "    \"$schema\": \"http://json-schema.org/draft-04/schema#\"," + Character.NEW_LINE + "    \"title\": \"Product\"," + Character.NEW_LINE + "    \"type\": \"object\"," + Character.NEW_LINE + "    \"properties\": {" + Character.NEW_LINE + "        \"id\": {" + Character.NEW_LINE + "            \"type\": \"integer\"" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"name\": {" + Character.NEW_LINE + "            \"type\": \"string\"" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"price\": {" + Character.NEW_LINE + "            \"type\": \"number\"," + Character.NEW_LINE + "            \"minimum\": 0," + Character.NEW_LINE + "            \"exclusiveMinimum\": true" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"tags\": {" + Character.NEW_LINE + "            \"type\": \"array\"," + Character.NEW_LINE + "            \"items\": {" + Character.NEW_LINE + "                \"type\": \"string\"" + Character.NEW_LINE + "            }," + Character.NEW_LINE + "            \"minItems\": 1," + Character.NEW_LINE + "            \"uniqueItems\": true" + Character.NEW_LINE + "        }" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"required\": [\"id\", \"name\", \"price\"]" + Character.NEW_LINE + "}"))), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"wrong field name\": \"A green door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingJsonPathBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)new JsonPathBody("$..book[?(@.price > $['expensive'])]")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("{" + Character.NEW_LINE + "    \"store\": {" + Character.NEW_LINE + "        \"book\": [" + Character.NEW_LINE + "            {" + Character.NEW_LINE + "                \"category\": \"reference\"," + Character.NEW_LINE + "                \"author\": \"Nigel Rees\"," + Character.NEW_LINE + "                \"title\": \"Sayings of the Century\"," + Character.NEW_LINE + "                \"price\": 8.95" + Character.NEW_LINE + "            }," + Character.NEW_LINE + "            {" + Character.NEW_LINE + "                \"category\": \"fiction\"," + Character.NEW_LINE + "                \"author\": \"Herman Melville\"," + Character.NEW_LINE + "                \"title\": \"Moby Dick\"," + Character.NEW_LINE + "                \"isbn\": \"0-553-21311-3\"," + Character.NEW_LINE + "                \"price\": 8.99" + Character.NEW_LINE + "            }" + Character.NEW_LINE + "        ]," + Character.NEW_LINE + "        \"bicycle\": {" + Character.NEW_LINE + "            \"color\": \"red\"," + Character.NEW_LINE + "            \"price\": 19.95" + Character.NEW_LINE + "        }" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"expensive\": 10" + Character.NEW_LINE + "}")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForMatchingPathWithNotOperator() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(NottableString.not((String)this.calculatePath("some_path")))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForMatchingMethodWithNotOperator() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod(NottableString.not((String)"GET"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("GET"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingBodyParameterName() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"OTHERBodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("OTHERBodyParameterOneName=Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForMatchingBodyParameterWithNotOperator() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((NottableString)NottableString.not((String)"bodyParameterOneName"), (NottableString[])new NottableString[]{NottableString.not((String)"Parameter One Value One"), NottableString.not((String)"Parameter One Value Two")}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Other Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingBodyParameterValue() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Other Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Other Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingQueryStringParameterName() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"OTHERQueryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingQueryStringParameterValue() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"OTHERqueryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForMatchingQueryStringParameterWithNotOperator() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((NottableString)NottableString.not((String)"queryStringParameterOneName"), (NottableString[])new NottableString[]{NottableString.not((String)"Parameter One Value One"), NottableString.not((String)"Parameter One Value Two")}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingCookieName() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieOtherName", (String)"cookieValue")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingCookieValue() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieOtherValue")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForMatchingCookieWithNotOperator() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((NottableString)NottableString.not((String)"requestCookieNameOne"), (NottableString)NottableString.not((String)"requestCookieValueOne")), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"requestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"requestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingHeaderName() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerOtherName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingHeaderValue() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerOtherValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldNotReturnResponseForMatchingHeaderWithNotOperator() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((NottableString)NottableString.string((String)"requestHeaderNameOne"), (NottableString[])new NottableString[]{NottableString.not((String)"requestHeaderValueOne")}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withReasonPhrase(HttpStatusCode.ACCEPTED_202.reasonPhrase()).withBody("some_body_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldVerifyReceivedRequestInSsl() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some.*path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request().withPath(this.calculatePath("some_path")).withSecure(Boolean.valueOf(false))});
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")).withSecure(Boolean.valueOf(false)), VerificationTimes.exactly((int)1));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_secure_path")).withSecure(Boolean.valueOf(true)), HEADERS_TO_IGNORE));
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request().withPath(this.calculatePath("some_secure_path")).withSecure(Boolean.valueOf(true))});
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_secure_path")).withSecure(Boolean.valueOf(true)), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldVerifyReceivedRequestsWithRegexBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_path")).withBody("{type: 'some_random_type', value: 'some_random_value'}"), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_response"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_path")).withBody("{type: 'some_random_type', value: 'some_random_value'}"), HEADERS_TO_IGNORE));
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request().withBody((Body)RegexBody.regex((String)"\\{type\\: \\'some_random_type\\'\\, value\\: \\'some_random_value\\'\\}"))});
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withBody((Body)RegexBody.regex((String)"\\{type\\: \\'some_random_type\\'\\, value\\: \\'some_random_value\\'\\}")), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldVerifyReceivedRequestsWithNoBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response());
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request().withPath(this.calculatePath("some_path"))});
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldVerifyReceivedRequestsWithNoMatchingExpectation() {
        this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE);
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request().withPath(this.calculatePath("some_path"))});
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.exactly((int)1));
        mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.once());
    }

    @Test
    public void shouldVerifyTooManyRequestsReceived() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        try {
            mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.exactly((int)0));
            TestCase.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found exactly 0 times, expected:<{" + Character.NEW_LINE + "  \"path\" : \"" + this.calculatePath("some_path") + "\"" + Character.NEW_LINE + "}> but was:<{")));
        }
    }

    @Test
    public void shouldVerifyNoMatchingRequestsReceived() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        try {
            mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_other_path")), VerificationTimes.exactly((int)2));
            TestCase.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found exactly 2 times, expected:<{" + Character.NEW_LINE + "  \"path\" : \"" + this.calculatePath("some_other_path") + "\"" + Character.NEW_LINE + "}> but was:<{")));
        }
    }

    @Test
    public void shouldNotVerifyNoRequestsReceived() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        try {
            mockServerClient.verifyZeroInteractions();
            TestCase.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)"Request not found exactly 0 times, expected:<{ }> but was:<{"));
        }
    }

    @Test
    public void shouldVerifyNoMatchingRequestsReceivedInSsl() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some.*path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        try {
            mockServerClient.verify((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path")).withSecure(Boolean.valueOf(true)), VerificationTimes.atLeast((int)1));
            TestCase.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found at least once, expected:<{" + Character.NEW_LINE + "  \"path\" : \"" + this.calculatePath("some_path") + "\"," + Character.NEW_LINE + "  \"secure\" : true" + Character.NEW_LINE + "}> but was:<{")));
        }
    }

    @Test
    public void shouldVerifySequenceOfRequestsReceivedIncludingThoseNotMatchingAnException() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.notFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("not_found")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), HEADERS_TO_IGNORE));
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found"))});
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
    }

    @Test
    public void shouldVerifySequenceOfRequestsNotReceived() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)6)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_two")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), HEADERS_TO_IGNORE));
        try {
            mockServerClient.verify(new RequestDefinition[]{HttpRequest.request((String)this.calculatePath("some_path_two")), HttpRequest.request((String)this.calculatePath("some_path_one"))});
            TestCase.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + Character.NEW_LINE + "  \"path\" : \"" + this.calculatePath("some_path_two") + "\"" + Character.NEW_LINE + "}, {" + Character.NEW_LINE + "  \"path\" : \"" + this.calculatePath("some_path_one") + "\"" + Character.NEW_LINE + "} ]> but was:<[ {")));
        }
        try {
            mockServerClient.verify(new RequestDefinition[]{HttpRequest.request((String)this.calculatePath("some_path_three")), HttpRequest.request((String)this.calculatePath("some_path_two"))});
            TestCase.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + Character.NEW_LINE + "  \"path\" : \"" + this.calculatePath("some_path_three") + "\"" + Character.NEW_LINE + "}, {" + Character.NEW_LINE + "  \"path\" : \"" + this.calculatePath("some_path_two") + "\"" + Character.NEW_LINE + "} ]> but was:<[ {")));
        }
        try {
            mockServerClient.verify(new RequestDefinition[]{HttpRequest.request((String)this.calculatePath("some_path_four"))});
            TestCase.fail((String)"expected exception to be thrown");
        }
        catch (AssertionError ae) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + Character.NEW_LINE + "  \"path\" : \"" + this.calculatePath("some_path_four") + "\"" + Character.NEW_LINE + "} ]> but was:<[ {")));
        }
    }

    @Test
    public void shouldRetrieveRecordedRequestsAsJson() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.notFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("not_found")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), HEADERS_TO_IGNORE));
        this.verifyRequestsMatches((RequestDefinition[])new HttpRequestSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Format.JSON)), HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_three")));
        this.verifyRequestsMatches((RequestDefinition[])new HttpRequestSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedRequests((RequestDefinition)HttpRequest.request(), Format.JSON)), HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found")), HttpRequest.request((String)this.calculatePath("some_path_three")));
        this.verifyRequestsMatches((RequestDefinition[])new HttpRequestSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedRequests(null, Format.JSON)), HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found")), HttpRequest.request((String)this.calculatePath("some_path_three")));
    }

    @Test
    public void shouldRetrieveRecordedRequestsAsJsonWithJsonBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request()).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withBody("{\"digests\": [ ]}"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withBody("{\"digests\": [\"sha256:one\"]}"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withBody("{\"digests\": [ ]}"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withBody("{\"digests\": [\"sha256:two\"]}"), HEADERS_TO_IGNORE));
        this.verifyRequestsMatches((RequestDefinition[])new HttpRequestSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withBody("{\"digests\": [ ]}"), Format.JSON)), HttpRequest.request().withBody("{\"digests\": [ ]}"), HttpRequest.request().withBody("{\"digests\": [ ]}"));
        this.verifyRequestsMatches((RequestDefinition[])new HttpRequestSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withBody((Body)JsonBody.json((String)"{\"digests\": [ ]}")), Format.JSON)), HttpRequest.request().withBody("{\"digests\": [ ]}"), HttpRequest.request().withBody("{\"digests\": [\"sha256:one\"]}"), HttpRequest.request().withBody("{\"digests\": [ ]}"), HttpRequest.request().withBody("{\"digests\": [\"sha256:two\"]}"));
        this.verifyRequestsMatches((RequestDefinition[])new HttpRequestSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withBody("{\"digests\": [\"sha256:one\"]}"), Format.JSON)), HttpRequest.request().withBody("{\"digests\": [\"sha256:one\"]}"));
        this.verifyRequestsMatches((RequestDefinition[])new HttpRequestSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withBody((Body)JsonBody.json((String)"{\"digests\": [\"sha256:one\"]}")), Format.JSON)), HttpRequest.request().withBody("{\"digests\": [\"sha256:one\"]}"));
        this.verifyRequestsMatches((RequestDefinition[])new HttpRequestSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withBody("{\"digests\": [\"sha256:two\"]}"), Format.JSON)), HttpRequest.request().withBody("{\"digests\": [\"sha256:two\"]}"));
        this.verifyRequestsMatches((RequestDefinition[])new HttpRequestSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withBody((Body)JsonBody.json((String)"{\"digests\": [\"sha256:two\"]}")), Format.JSON)), HttpRequest.request().withBody("{\"digests\": [\"sha256:two\"]}"));
        this.verifyRequestsMatches((RequestDefinition[])new HttpRequestSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withBody((Body)JsonBody.json((String)"{ }")), Format.JSON)), HttpRequest.request().withBody("{\"digests\": [ ]}"), HttpRequest.request().withBody("{\"digests\": [\"sha256:one\"]}"), HttpRequest.request().withBody("{\"digests\": [ ]}"), HttpRequest.request().withBody("{\"digests\": [\"sha256:two\"]}"));
        this.verifyRequestsMatches((RequestDefinition[])new HttpRequestSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedRequests((RequestDefinition)HttpRequest.request(), Format.JSON)), HttpRequest.request().withBody("{\"digests\": [ ]}"), HttpRequest.request().withBody("{\"digests\": [\"sha256:one\"]}"), HttpRequest.request().withBody("{\"digests\": [ ]}"), HttpRequest.request().withBody("{\"digests\": [\"sha256:two\"]}"));
    }

    @Test
    public void shouldRetrieveRecordedRequestsAsLogEntries() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.notFoundResponse(), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("not_found")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), HEADERS_TO_IGNORE));
        String logEntriesActual = mockServerClient.retrieveRecordedRequests((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Format.LOG_ENTRIES);
        HttpRequest requestOne = HttpRequest.request((String)"/some_path_one").withMethod("GET").withHeader("host", new String[]{"localhost:" + this.getServerPort()}).withHeader("accept-encoding", new String[]{"gzip,deflate"}).withHeader("content-length", new String[]{"0"}).withHeader("connection", new String[]{"keep-alive"}).withKeepAlive(Boolean.valueOf(true)).withSecure(Boolean.valueOf(false));
        HttpRequest requestTwo = HttpRequest.request((String)"/some_path_three").withMethod("GET").withHeader("host", new String[]{"localhost:" + this.getServerPort()}).withHeader("accept-encoding", new String[]{"gzip,deflate"}).withHeader("content-length", new String[]{"0"}).withHeader("connection", new String[]{"keep-alive"}).withKeepAlive(Boolean.valueOf(true)).withSecure(Boolean.valueOf(false));
        List<LogEntry> logEntriesExpected = Arrays.asList(new LogEntry().setType(LogEntry.LogMessageType.RECEIVED_REQUEST).setLogLevel(Level.INFO).setHttpRequest((RequestDefinition)requestOne).setMessageFormat("received request:{}").setArguments(new Object[]{requestOne}), new LogEntry().setType(LogEntry.LogMessageType.RECEIVED_REQUEST).setLogLevel(Level.INFO).setHttpRequest((RequestDefinition)requestTwo).setMessageFormat("received request:{}").setArguments(new Object[]{requestTwo}));
        MatcherAssert.assertThat((Object)logEntriesActual, (Matcher)Is.is((Object)new LogEntrySerializer(new MockServerLogger()).serialize(logEntriesExpected)));
    }

    @Test
    public void shouldRetrieveActiveExpectationsAsJson() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))).respond(HttpResponse.response().withBody("some_body"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_other_path"))).respond(HttpResponse.response().withBody("some_other_body"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_forward_path"))).forward(HttpForward.forward());
        MatcherAssert.assertThat((Object)new ExpectationSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveActiveExpectations((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Format.JSON), false), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))).thenRespond(HttpResponse.response().withBody("some_body"))}));
        MatcherAssert.assertThat((Object)new ExpectationSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveActiveExpectations(null, Format.JSON), false), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_other_path"))).thenRespond(HttpResponse.response().withBody("some_other_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_forward_path"))).thenForward(HttpForward.forward())}));
        MatcherAssert.assertThat((Object)new ExpectationSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveActiveExpectations((RequestDefinition)HttpRequest.request(), Format.JSON), false), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_other_path"))).thenRespond(HttpResponse.response().withBody("some_other_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_forward_path"))).thenForward(HttpForward.forward())}));
    }

    @Test
    public void shouldRetrieveActiveExpectationsAsJava() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))).respond(HttpResponse.response().withBody("some_body"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_other_path"))).respond(HttpResponse.response().withBody("some_other_body"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_forward_path"))).forward(HttpForward.forward());
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Format.JAVA), (Matcher)Is.is((Object)new ExpectationToJavaSerializer().serialize(Arrays.asList(new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))).thenRespond(HttpResponse.response().withBody("some_body"))))));
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null, Format.JAVA), (Matcher)Is.is((Object)new ExpectationToJavaSerializer().serialize(Arrays.asList(new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_other_path"))).thenRespond(HttpResponse.response().withBody("some_other_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_forward_path"))).thenForward(HttpForward.forward())))));
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations((RequestDefinition)HttpRequest.request(), Format.JAVA), (Matcher)Is.is((Object)new ExpectationToJavaSerializer().serialize(Arrays.asList(new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4), TimeToLive.unlimited(), 0).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*"))).thenRespond(HttpResponse.response().withBody("some_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_other_path"))).thenRespond(HttpResponse.response().withBody("some_other_body")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_forward_path"))).thenForward(HttpForward.forward())))));
    }

    @Test
    public void shouldRetrieveRecordedExpectationsAsJson() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4)).forward(HttpForward.forward().withHost("127.0.0.1").withPort(insecureEchoServer.getPort()));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body_one"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")).withBody("some_body_one"), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response((String)"some_body_three"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")).withBody("some_body_three"), HEADERS_TO_IGNORE));
        Expectation[] recordedExpectations = new ExpectationSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedExpectations((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path_one")), Format.JSON), false);
        MatcherAssert.assertThat((Object)recordedExpectations.length, (Matcher)Is.is((Object)1));
        this.verifyRequestsMatches(new RequestDefinition[]{recordedExpectations[0].getHttpRequest()}, HttpRequest.request((String)this.calculatePath("some_path_one")).withBody("some_body_one"));
        MatcherAssert.assertThat((Object)recordedExpectations[0].getHttpResponse().getBodyAsString(), (Matcher)Is.is((Object)"some_body_one"));
        recordedExpectations = new ExpectationSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedExpectations((RequestDefinition)HttpRequest.request(), Format.JSON), false);
        MatcherAssert.assertThat((Object)recordedExpectations.length, (Matcher)Is.is((Object)2));
        this.verifyRequestsMatches(new RequestDefinition[]{recordedExpectations[0].getHttpRequest(), recordedExpectations[1].getHttpRequest()}, HttpRequest.request((String)this.calculatePath("some_path_one")).withBody("some_body_one"), HttpRequest.request((String)this.calculatePath("some_path_three")).withBody("some_body_three"));
        MatcherAssert.assertThat((Object)recordedExpectations[0].getHttpResponse().getBodyAsString(), (Matcher)Is.is((Object)"some_body_one"));
        MatcherAssert.assertThat((Object)recordedExpectations[1].getHttpResponse().getBodyAsString(), (Matcher)Is.is((Object)"some_body_three"));
        recordedExpectations = new ExpectationSerializer(new MockServerLogger()).deserializeArray(mockServerClient.retrieveRecordedExpectations(null, Format.JSON), false);
        MatcherAssert.assertThat((Object)recordedExpectations.length, (Matcher)Is.is((Object)2));
        this.verifyRequestsMatches(new RequestDefinition[]{recordedExpectations[0].getHttpRequest(), recordedExpectations[1].getHttpRequest()}, HttpRequest.request((String)this.calculatePath("some_path_one")).withBody("some_body_one"), HttpRequest.request((String)this.calculatePath("some_path_three")).withBody("some_body_three"));
        MatcherAssert.assertThat((Object)recordedExpectations[0].getHttpResponse().getBodyAsString(), (Matcher)Is.is((Object)"some_body_one"));
        MatcherAssert.assertThat((Object)recordedExpectations[1].getHttpResponse().getBodyAsString(), (Matcher)Is.is((Object)"some_body_three"));
    }

    @Test
    public void shouldClearExpectationsOnly() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), HEADERS_TO_IGNORE));
        mockServerClient.clear((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1")), ClearType.EXPECTATIONS);
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).thenRespond(HttpResponse.response().withBody("some_body2"))}));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests(null), HttpRequest.request((String)this.calculatePath("some_path1")), HttpRequest.request((String)this.calculatePath("some_path2")));
    }

    @Test
    public void shouldClearExpectationsOnlyByExpectationId() {
        Expectation firstExpectation = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"))[0];
        Expectation secondExpectation = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"))[0];
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), HEADERS_TO_IGNORE));
        IllegalArgumentException illegalArgumentException = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> mockServerClient.clear(UUIDService.neverFixedUUID(), ClearType.EXPECTATIONS));
        MatcherAssert.assertThat((Object)illegalArgumentException.getMessage(), (Matcher)StringStartsWith.startsWith((String)"No expectation found with id "));
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{firstExpectation, secondExpectation}));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests(null), HttpRequest.request((String)this.calculatePath("some_path1")), HttpRequest.request((String)this.calculatePath("some_path2")));
        mockServerClient.clear(firstExpectation.getId(), ClearType.EXPECTATIONS);
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{secondExpectation}));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests(null), HttpRequest.request((String)this.calculatePath("some_path1")), HttpRequest.request((String)this.calculatePath("some_path2")));
        mockServerClient.clear(secondExpectation.getId(), ClearType.EXPECTATIONS);
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.emptyArray());
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests(null), HttpRequest.request((String)this.calculatePath("some_path1")), HttpRequest.request((String)this.calculatePath("some_path2")));
    }

    @Test
    public void shouldClearExpectationsWithIdenticalRequestMatchersByExpectationId() {
        Expectation firstExpectation = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path"))).respond(HttpResponse.response().withBody("some_body1"))[0];
        Expectation secondExpectation = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path"))).respond(HttpResponse.response().withBody("some_body2"))[0];
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), HEADERS_TO_IGNORE));
        IllegalArgumentException illegalArgumentException = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> mockServerClient.clear(UUIDService.neverFixedUUID(), ClearType.EXPECTATIONS));
        MatcherAssert.assertThat((Object)illegalArgumentException.getMessage(), (Matcher)StringStartsWith.startsWith((String)"No expectation found with id "));
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{firstExpectation, secondExpectation}));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests(null), HttpRequest.request((String)this.calculatePath("some_path")), HttpRequest.request((String)this.calculatePath("some_path")));
        mockServerClient.clear(firstExpectation.getId(), ClearType.EXPECTATIONS);
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{secondExpectation}));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests(null), HttpRequest.request((String)this.calculatePath("some_path")), HttpRequest.request((String)this.calculatePath("some_path")));
        mockServerClient.clear(secondExpectation.getId(), ClearType.EXPECTATIONS);
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.emptyArray());
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests(null), HttpRequest.request((String)this.calculatePath("some_path")), HttpRequest.request((String)this.calculatePath("some_path")));
    }

    @Test
    public void shouldClearLogsOnly() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), HEADERS_TO_IGNORE));
        mockServerClient.clear((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1")), ClearType.LOG);
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1"))).thenRespond(HttpResponse.response().withBody("some_body1")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).thenRespond(HttpResponse.response().withBody("some_body2"))}));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests(null), HttpRequest.request((String)this.calculatePath("some_path2")));
    }

    @Test
    public void shouldClearLogsOnlyByExpectationId() {
        Expectation firstExpectation = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"))[0];
        Expectation secondExpectation = mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"))[0];
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), HEADERS_TO_IGNORE));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), HEADERS_TO_IGNORE));
        mockServerClient.clear(firstExpectation.getId(), ClearType.LOG);
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1"))).thenRespond(HttpResponse.response().withBody("some_body1")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).thenRespond(HttpResponse.response().withBody("some_body2"))}));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests(null), HttpRequest.request((String)this.calculatePath("some_path2")));
        mockServerClient.clear(secondExpectation.getId(), ClearType.LOG);
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1"))).thenRespond(HttpResponse.response().withBody("some_body1")), new Expectation((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).thenRespond(HttpResponse.response().withBody("some_body2"))}));
        this.verifyRequestsMatches((RequestDefinition[])mockServerClient.retrieveRecordedRequests(null), new HttpRequest[0]);
    }

    @Test
    public void shouldClearAllExpectationsWithNull() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), HEADERS_TO_IGNORE));
        mockServerClient.clear((RequestDefinition)null);
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.emptyArray());
        MatcherAssert.assertThat((Object)mockServerClient.retrieveRecordedRequests(null), (Matcher)Matchers.emptyArray());
    }

    @Test
    public void shouldClearAllExpectationsWithEmptyRequest() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), HEADERS_TO_IGNORE));
        mockServerClient.clear((RequestDefinition)HttpRequest.request());
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.emptyArray());
        MatcherAssert.assertThat((Object)mockServerClient.retrieveRecordedRequests(null), (Matcher)Matchers.emptyArray());
    }

    @Test
    public void shouldClearExpectationsWithXPathBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)XPathBody.xpath((String)"/bookstore/book[year=2005]/price"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)XPathBody.xpath((String)"/bookstore/book[year=2006]/price"))).respond(HttpResponse.response().withBody("some_body2"));
        StringBody xmlBody = new StringBody("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + Character.NEW_LINE + "<bookstore>" + Character.NEW_LINE + "  <book category=\"COOKING\">" + Character.NEW_LINE + "    <title lang=\"en\">Everyday Italian</title>" + Character.NEW_LINE + "    <author>Giada De Laurentiis</author>" + Character.NEW_LINE + "    <year>2005</year>" + Character.NEW_LINE + "    <price>30.00</price>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "  <book category=\"CHILDREN\">" + Character.NEW_LINE + "    <title lang=\"en\">Harry Potter</title>" + Character.NEW_LINE + "    <author>J K. Rowling</author>" + Character.NEW_LINE + "    <year>2006</year>" + Character.NEW_LINE + "    <price>29.99</price>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "  <book category=\"WEB\">" + Character.NEW_LINE + "    <title lang=\"en\">Learning XML</title>" + Character.NEW_LINE + "    <author>Erik T. Ray</author>" + Character.NEW_LINE + "    <year>2003</year>" + Character.NEW_LINE + "    <price>31.95</price>" + Character.NEW_LINE + "  </book>" + Character.NEW_LINE + "</bookstore>");
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withBody((Body)xmlBody), HEADERS_TO_IGNORE));
        mockServerClient.clear((RequestDefinition)HttpRequest.request().withBody((Body)XPathBody.xpath((String)"/bookstore/book[year=2005]/price")));
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)HttpRequest.request().withBody((Body)XPathBody.xpath((String)"/bookstore/book[year=2006]/price"))).thenRespond(HttpResponse.response().withBody("some_body2"))}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withBody((Body)xmlBody), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldClearExpectationsWithJsonSchemaBody() {
        JsonSchemaBody jsonSchemaBodyOne = JsonSchemaBody.jsonSchema((String)("{" + Character.NEW_LINE + "    \"$schema\": \"http://json-schema.org/draft-04/schema#\"," + Character.NEW_LINE + "    \"title\": \"Product\"," + Character.NEW_LINE + "    \"type\": \"object\"," + Character.NEW_LINE + "    \"properties\": {" + Character.NEW_LINE + "        \"id\": {" + Character.NEW_LINE + "            \"type\": \"integer\"" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"name\": {" + Character.NEW_LINE + "            \"type\": \"string\"" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"price\": {" + Character.NEW_LINE + "            \"type\": \"number\"," + Character.NEW_LINE + "            \"minimum\": 0," + Character.NEW_LINE + "            \"exclusiveMinimum\": true" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        \"tags\": {" + Character.NEW_LINE + "            \"type\": \"array\"," + Character.NEW_LINE + "            \"items\": {" + Character.NEW_LINE + "                \"type\": \"string\"" + Character.NEW_LINE + "            }," + Character.NEW_LINE + "            \"minItems\": 1," + Character.NEW_LINE + "            \"uniqueItems\": true" + Character.NEW_LINE + "        }" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"required\": [\"id\", \"name\", \"price\"]" + Character.NEW_LINE + "}"));
        JsonSchemaBody jsonSchemaBodyTwo = JsonSchemaBody.jsonSchema((String)("{" + Character.NEW_LINE + "  \"$schema\" : \"http://json-schema.org/draft-04/schema#\"," + Character.NEW_LINE + "  \"title\" : \"Product\"," + Character.NEW_LINE + "  \"description\" : \"A product from Acme's catalog\"," + Character.NEW_LINE + "  \"type\" : \"object\"," + Character.NEW_LINE + "  \"properties\" : {" + Character.NEW_LINE + "    \"id\" : {" + Character.NEW_LINE + "      \"description\" : \"The unique identifier for a product\"," + Character.NEW_LINE + "      \"type\" : \"integer\"" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"name\" : {" + Character.NEW_LINE + "      \"description\" : \"Name of the product\"," + Character.NEW_LINE + "      \"type\" : \"string\"" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"price\" : {" + Character.NEW_LINE + "      \"type\" : \"number\"," + Character.NEW_LINE + "      \"minimum\" : 10," + Character.NEW_LINE + "      \"exclusiveMinimum\" : true" + Character.NEW_LINE + "    }," + Character.NEW_LINE + "    \"tags\" : {" + Character.NEW_LINE + "      \"type\" : \"array\"," + Character.NEW_LINE + "      \"items\" : {" + Character.NEW_LINE + "        \"type\" : \"string\"" + Character.NEW_LINE + "      }," + Character.NEW_LINE + "      \"minItems\" : 1," + Character.NEW_LINE + "      \"uniqueItems\" : true" + Character.NEW_LINE + "    }" + Character.NEW_LINE + "  }," + Character.NEW_LINE + "  \"required\" : [ \"id\", \"name\", \"price\" ]" + Character.NEW_LINE + "}"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)jsonSchemaBodyOne)).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)jsonSchemaBodyTwo)).respond(HttpResponse.response().withBody("some_body2"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withBody("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"name\": \"A green door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"), HEADERS_TO_IGNORE));
        mockServerClient.clear((RequestDefinition)HttpRequest.request().withBody((Body)jsonSchemaBodyOne));
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)HttpRequest.request().withBody((Body)jsonSchemaBodyTwo)).thenRespond(HttpResponse.response().withBody("some_body2"))}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withBody("{" + Character.NEW_LINE + "    \"id\": 1," + Character.NEW_LINE + "    \"name\": \"A green door\"," + Character.NEW_LINE + "    \"price\": 12.50," + Character.NEW_LINE + "    \"tags\": [\"home\", \"green\"]" + Character.NEW_LINE + "}"), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldClearExpectationsWithParameterBody() {
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterNameOne", (String[])new String[]{"bodyParameterValueOne"})}))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when((RequestDefinition)HttpRequest.request().withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterNameTwo", (String[])new String[]{"bodyParameterValueTwo"})}))).respond(HttpResponse.response().withBody("some_body2"));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterNameOne", (String[])new String[]{"bodyParameterValueOne"})})), HEADERS_TO_IGNORE));
        mockServerClient.clear((RequestDefinition)HttpRequest.request().withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterNameOne", (String[])new String[]{"bodyParameterValueOne"})})));
        MatcherAssert.assertThat((Object)mockServerClient.retrieveActiveExpectations(null), (Matcher)Matchers.arrayContaining((Object[])new Expectation[]{new Expectation((RequestDefinition)HttpRequest.request().withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterNameTwo", (String[])new String[]{"bodyParameterValueTwo"})}))).thenRespond(HttpResponse.response().withBody("some_body2"))}));
        TestCase.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterNameTwo", (String[])new String[]{"bodyParameterValueTwo"})})), HEADERS_TO_IGNORE));
    }

    @Test
    public void shouldEnsureThatInterruptedRequestsAreVerifiable() {
        mockServerClient.when((RequestDefinition)HttpRequest.request((String)this.calculatePath("delayed"))).respond((HttpResponse)HttpResponse.response((String)"delayed data").withDelay(new Delay(TimeUnit.SECONDS, 3L)));
        Future<HttpResponse> delayedFuture = Executors.newSingleThreadExecutor().submit(() -> (HttpResponse)httpClient.sendRequest(HttpRequest.request((String)this.addContextToPath(this.calculatePath("delayed"))).withHeader(HttpHeaderNames.HOST.toString(), new String[]{"localhost:" + this.getServerPort()})).get(10L, TimeUnit.SECONDS));
        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        delayedFuture.cancel(true);
        mockServerClient.verify(new RequestDefinition[]{HttpRequest.request((String)this.calculatePath("delayed"))});
    }

    @Test
    public void shouldEnsureThatRequestDelaysDoNotAffectOtherRequests() throws Exception {
        mockServerClient.when((RequestDefinition)HttpRequest.request((String)"/slow")).respond((HttpResponse)HttpResponse.response((String)"super slow").withDelay(new Delay(TimeUnit.SECONDS, 5L)));
        mockServerClient.when((RequestDefinition)HttpRequest.request((String)"/fast")).respond(HttpResponse.response((String)"quite fast"));
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future<Long> slowFuture = executorService.submit(() -> {
            long start = System.currentTimeMillis();
            this.makeRequest(HttpRequest.request((String)"/slow"), Collections.emptySet());
            return System.currentTimeMillis() - start;
        });
        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        Future<Long> fastFuture = executorService.submit(() -> {
            long start = System.currentTimeMillis();
            this.makeRequest(HttpRequest.request((String)"/fast"), Collections.emptySet());
            return System.currentTimeMillis() - start;
        });
        Long slowRequestElapsedMillis = slowFuture.get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
        Long fastRequestElapsedMillis = fastFuture.get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((String)"Slow request takes less than expected", (Object)slowRequestElapsedMillis, (Matcher)Is.is((Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(4000L))));
        MatcherAssert.assertThat((String)"Fast request takes longer than expected", (Object)fastRequestElapsedMillis, (Matcher)Is.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(1000L))));
    }
}

