/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.junit.jupiter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.mockserver.client.MockServerClient;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.junit.jupiter.MockServerSettings;
import org.mockserver.scheduler.Scheduler;

public class MockServerExtension
implements ParameterResolver,
BeforeAllCallback,
AfterAllCallback {
    protected static ClientAndServer perTestSuiteClientAndServer;
    protected ClientAndServer customClientAndServer;
    protected ClientAndServer clientAndServer;
    protected boolean perTestSuite;

    public MockServerExtension() {
    }

    public MockServerExtension(ClientAndServer clientAndServer) {
        this.customClientAndServer = clientAndServer;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return MockServerClient.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.clientAndServer;
    }

    public void beforeAll(ExtensionContext context) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        Optional<MockServerSettings> mockServerSettingsOptional = this.retrieveAnnotationFromTestClass(context);
        if (mockServerSettingsOptional.isPresent()) {
            MockServerSettings mockServerSettings = mockServerSettingsOptional.get();
            this.perTestSuite = mockServerSettings.perTestSuite();
            for (int port : mockServerSettings.ports()) {
                ports.add(port);
            }
        }
        this.clientAndServer = this.instantiateClient(ports);
    }

    ClientAndServer instantiateClient(List<Integer> ports) {
        if (this.perTestSuite) {
            if (perTestSuiteClientAndServer == null) {
                perTestSuiteClientAndServer = ClientAndServer.startClientAndServer(ports);
                Runtime.getRuntime().addShutdownHook(new Scheduler.SchedulerThreadFactory("MockServer Test Extension ShutdownHook").newThread(() -> perTestSuiteClientAndServer.stop()));
            }
            return perTestSuiteClientAndServer;
        }
        if (this.customClientAndServer != null) {
            return this.customClientAndServer;
        }
        return ClientAndServer.startClientAndServer(ports);
    }

    public void afterAll(ExtensionContext extensionContext) {
        if (!this.perTestSuite && this.clientAndServer.isRunning()) {
            this.clientAndServer.stop();
        }
    }

    private Optional<MockServerSettings> retrieveAnnotationFromTestClass(ExtensionContext context) {
        Optional annotation;
        ExtensionContext currentContext = context;
        do {
            annotation = AnnotationSupport.findAnnotation((Optional)currentContext.getElement(), MockServerSettings.class);
            if (!currentContext.getParent().isPresent()) break;
            currentContext = (ExtensionContext)currentContext.getParent().get();
        } while (!annotation.isPresent() && currentContext != context.getRoot());
        return annotation;
    }
}

