/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.junit.jupiter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.mockserver.client.MockServerClient;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.junit.jupiter.MockServerSettings;
import org.mockserver.socket.PortFactory;

public class MockServerExtension
implements ParameterResolver,
BeforeAllCallback,
AfterAllCallback {
    private static ClientAndServer perTestSuiteClient;
    private final ClientAndServer clientAndServerFactory;
    private ClientAndServer client;
    private boolean perTestSuite;

    public MockServerExtension() {
        this.clientAndServerFactory = new ClientAndServer(new Integer[0]);
    }

    public MockServerExtension(ClientAndServer clientAndServerFactory) {
        this.clientAndServerFactory = clientAndServerFactory;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().equals(MockServerClient.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.client;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        Optional<MockServerSettings> mockServerSettingsOptional = this.retrieveAnnotationFromTestClass(context);
        if (mockServerSettingsOptional.isPresent()) {
            MockServerSettings mockServerSettings = mockServerSettingsOptional.get();
            this.perTestSuite = mockServerSettings.perTestSuite();
            for (int port : mockServerSettings.ports()) {
                ports.add(port);
            }
        }
        if (ports.isEmpty()) {
            ports.add(PortFactory.findFreePort());
        }
        this.client = this.instantiateClient(ports);
    }

    private ClientAndServer instantiateClient(List<Integer> ports) {
        if (this.perTestSuite) {
            if (perTestSuiteClient == null) {
                perTestSuiteClient = this.clientAndServerFactory.startClientAndServer(ports);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> perTestSuiteClient.stop()));
            }
            return perTestSuiteClient;
        }
        return this.clientAndServerFactory.startClientAndServer(ports);
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        if (!this.perTestSuite && this.client.isRunning()) {
            this.client.stop();
        }
    }

    private Optional<MockServerSettings> retrieveAnnotationFromTestClass(ExtensionContext context) {
        Optional annotation;
        ExtensionContext currentContext = context;
        do {
            annotation = AnnotationSupport.findAnnotation((Optional)currentContext.getElement(), MockServerSettings.class);
            if (!currentContext.getParent().isPresent()) break;
            currentContext = (ExtensionContext)currentContext.getParent().get();
        } while (!annotation.isPresent() && currentContext != context.getRoot());
        return annotation;
    }
}

