/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mockserver.client.proxy.ProxyClient;
import org.mockserver.client.server.MockServerClient;
import org.mockserver.initialize.ExpectationInitializer;
import org.mockserver.mockserver.MockServer;
import org.mockserver.mockserver.MockServerBuilder;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.ProxyBuilder;

public class InstanceHolder
extends ObjectWithReflectiveEqualsHashCodeToString {
    @VisibleForTesting
    static Map<Integer, MockServerClient> mockServerClients = new ConcurrentHashMap<Integer, MockServerClient>();
    @VisibleForTesting
    static Map<Integer, ProxyClient> proxyClients = new ConcurrentHashMap<Integer, ProxyClient>();
    private ProxyBuilder proxyBuilder = new ProxyBuilder();
    private MockServerBuilder mockServerBuilder = new MockServerBuilder();
    private Proxy proxy;
    private MockServer mockServer;

    public static void runInitializationClass(Integer[] mockServerPorts, ExpectationInitializer expectationInitializer) {
        if (mockServerPorts != null && mockServerPorts.length > 0 && expectationInitializer != null) {
            expectationInitializer.initializeExpectations(InstanceHolder.getMockServerClient(mockServerPorts[0]));
        }
    }

    private static ProxyClient getProxyClient(int proxyPort) {
        if (!proxyClients.containsKey(proxyPort)) {
            proxyClients.put(proxyPort, new ProxyClient("127.0.0.1", proxyPort));
        }
        return proxyClients.get(proxyPort);
    }

    private static MockServerClient getMockServerClient(int mockServerPort) {
        if (!mockServerClients.containsKey(mockServerPort)) {
            mockServerClients.put(mockServerPort, new MockServerClient("127.0.0.1", mockServerPort));
        }
        return mockServerClients.get(mockServerPort);
    }

    public void start(Integer[] mockServerPorts, Integer proxyPort, ExpectationInitializer expectationInitializer) {
        if (this.mockServer == null || !this.mockServer.isRunning()) {
            if (mockServerPorts != null && mockServerPorts.length > 0) {
                this.mockServer = this.mockServerBuilder.withHTTPPort(mockServerPorts).build();
            }
        } else {
            throw new IllegalStateException("MockServer is already running!");
        }
        InstanceHolder.runInitializationClass(mockServerPorts, expectationInitializer);
        if (this.proxy == null || !this.proxy.isRunning()) {
            if (proxyPort != -1) {
                this.proxy = this.proxyBuilder.withLocalPort(proxyPort).build();
            }
        } else {
            throw new IllegalStateException("Proxy is already running!");
        }
    }

    public void stop(Integer[] mockServerPorts, int proxyPort, boolean ignoreFailure) {
        if (mockServerPorts != null && mockServerPorts.length > 0) {
            InstanceHolder.getMockServerClient(mockServerPorts[0]).stop(ignoreFailure);
        }
        if (proxyPort != -1) {
            InstanceHolder.getProxyClient(proxyPort).stop(ignoreFailure);
        }
    }

    public void stop() {
        if (this.mockServer != null && this.mockServer.isRunning()) {
            this.mockServer.stop();
        }
        if (this.proxy != null && this.proxy.isRunning()) {
            this.proxy.stop();
        }
    }
}

