/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mockserver.initialize.ExpectationInitializer;
import org.mockserver.maven.InstanceHolder;

public abstract class MockServerAbstractMojo
extends AbstractMojo {
    @VisibleForTesting
    protected static InstanceHolder embeddedJettyHolder;
    @Parameter(property="mockserver.serverPort", defaultValue="")
    protected String serverPort = "";
    @Parameter(property="mockserver.proxyPort", defaultValue="-1")
    protected Integer proxyPort = -1;
    @Parameter(property="mockserver.timeout")
    protected Integer timeout;
    @Parameter(property="mockserver.logLevel", defaultValue="INFO")
    protected String logLevel;
    @Parameter(property="mockserver.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="mockserver.pipeLogToConsole", defaultValue="false")
    protected boolean pipeLogToConsole;
    @Parameter(property="mockserver.initializationClass")
    protected String initializationClass;
    @Parameter(property="project.compileClasspathElements", required=true, readonly=true)
    protected List<String> compileClasspath;
    @Parameter(property="project.testClasspathElements", required=true, readonly=true)
    protected List<String> testClasspath;
    @Parameter(property="pluginDescriptor.plugin.dependencies", required=true, readonly=true)
    protected List<Dependency> dependencies;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession session;
    private Integer[] serverPorts;

    protected Integer[] getServerPorts() {
        if (this.serverPorts == null && StringUtils.isNotEmpty((CharSequence)this.serverPort)) {
            ArrayList<Integer> ports = new ArrayList<Integer>();
            for (String port : Splitter.on((char)',').split((CharSequence)this.serverPort)) {
                ports.add(Integer.parseInt(port));
            }
            this.serverPorts = ports.toArray(new Integer[ports.size()]);
        }
        return this.serverPorts;
    }

    protected InstanceHolder getEmbeddedJettyHolder() {
        if (embeddedJettyHolder == null) {
            embeddedJettyHolder = new InstanceHolder();
        }
        return embeddedJettyHolder;
    }

    protected ExpectationInitializer createInitializer() {
        try {
            Constructor<?> initializerClassConstructor;
            Object expectationInitializer;
            ClassLoader contextClassLoader = this.setupClasspath();
            if (contextClassLoader != null && StringUtils.isNotEmpty((CharSequence)this.initializationClass) && (expectationInitializer = (initializerClassConstructor = contextClassLoader.loadClass(this.initializationClass).getDeclaredConstructor(new Class[0])).newInstance(new Object[0])) instanceof ExpectationInitializer) {
                return (ExpectationInitializer)expectationInitializer;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private ClassLoader setupClasspath() throws MalformedURLException {
        if (this.compileClasspath != null && this.testClasspath != null) {
            int i;
            URL[] urls = new URL[this.compileClasspath.size() + this.testClasspath.size()];
            for (i = 0; i < this.compileClasspath.size(); ++i) {
                urls[i] = new File(this.compileClasspath.get(i)).toURI().toURL();
            }
            for (i = this.compileClasspath.size(); i < this.compileClasspath.size() + this.testClasspath.size(); ++i) {
                urls[i] = new File(this.testClasspath.get(i - this.compileClasspath.size())).toURI().toURL();
            }
            URLClassLoader contextClassLoader = URLClassLoader.newInstance(urls, Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            return contextClassLoader;
        }
        return null;
    }
}

