/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.maven.MockServerAbstractMojo;
import org.mockserver.maven.SettableFuture;

@Mojo(name="run", requiresProject=false, threadSafe=false)
public class MockServerRunAndWaitMojo
extends MockServerAbstractMojo {
    private SettableFuture settableFuture = SettableFuture.create();

    public void execute() throws MojoExecutionException {
        ConfigurationProperties.overrideLogLevel((String)this.logLevel);
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
        } else {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("mockserver:runAndWait about to start MockServer on: " + (this.getServerPorts() != null ? " serverPort " + Arrays.toString((Object[])this.getServerPorts()) : "") + (this.proxyPort != -1 ? " proxyPort " + this.proxyPort : "")));
            }
            try {
                if (this.timeout != null && this.timeout > 0) {
                    this.getEmbeddedJettyHolder().start(this.getServerPorts(), this.proxyPort, this.createInitializer());
                    try {
                        this.settableFuture.get(this.timeout.intValue(), TimeUnit.SECONDS);
                    }
                    catch (TimeoutException timeoutException) {}
                } else {
                    this.getEmbeddedJettyHolder().start(this.getServerPorts(), this.proxyPort, this.createInitializer());
                    this.settableFuture.get();
                }
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Exception while running MockServer", (Throwable)e);
            }
        }
    }
}

