/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.mockserver.cli.Main;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.maven.InstanceHolder;
import org.mockserver.maven.MockServerAbstractMojo;
import org.mockserver.maven.ProcessBuildFactory;

@Mojo(name="runForked", requiresProject=false, threadSafe=false)
public class MockServerRunForkedMojo
extends MockServerAbstractMojo {
    @Parameter(defaultValue="${plugin.artifacts}", required=true, readonly=true)
    protected List<Artifact> pluginArtifacts;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected ArtifactResolver artifactResolver;
    private ProcessBuildFactory processBuildFactory = new ProcessBuildFactory();

    public static String fileSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
        } else {
            this.getEmbeddedJettyHolder().stop(this.getServerPorts(), this.proxyPort, true);
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Exception while waiting for existing mock server JVM to stop", e);
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("mockserver:runForked about to start MockServer on: " + (this.getServerPorts() != null ? " serverPort " + Arrays.toString((Object[])this.getServerPorts()) : "") + (this.proxyPort != -1 ? " proxyPort " + this.proxyPort : "")));
            }
            ArrayList<String> arguments = new ArrayList<String>(Collections.singletonList(this.getJavaBin()));
            arguments.add("-Dfile.encoding=UTF-8");
            arguments.add("-Dmockserver.logLevel=" + this.logLevel);
            arguments.add("-cp");
            StringBuilder classPath = new StringBuilder(this.resolvePathForJarWithDependencies());
            if (this.dependencies != null && !this.dependencies.isEmpty()) {
                for (Dependency dependency : this.dependencies) {
                    classPath.append(System.getProperty("path.separator"));
                    classPath.append(this.resolvePathForDependencyJar(dependency));
                }
            }
            arguments.add(classPath.toString());
            arguments.add(Main.class.getName());
            if (this.getServerPorts() != null) {
                arguments.add("-serverPort");
                arguments.add("" + Joiner.on((String)",").join((Object[])this.getServerPorts()));
                ConfigurationProperties.mockServerPort((Integer[])this.getServerPorts());
            }
            if (this.proxyPort != -1) {
                arguments.add("-proxyPort");
                arguments.add("" + this.proxyPort);
                ConfigurationProperties.proxyPort((Integer[])new Integer[]{this.proxyPort});
            }
            this.getLog().info((CharSequence)" ");
            String message = "Running: " + Joiner.on((String)" ").join(arguments);
            this.getLog().info((CharSequence)StringUtils.rightPad((String)"", (int)message.length(), (String)"-"));
            this.getLog().info((CharSequence)message);
            this.getLog().info((CharSequence)StringUtils.rightPad((String)"", (int)message.length(), (String)"-"));
            this.getLog().info((CharSequence)" ");
            ProcessBuilder processBuilder = this.processBuildFactory.create(arguments);
            if (this.pipeLogToConsole) {
                processBuilder.redirectErrorStream(true);
            }
            try {
                processBuilder.start();
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Exception while starting MockServer", (Throwable)e);
            }
            try {
                TimeUnit.SECONDS.sleep(this.timeout == null ? 2 : this.timeout);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Exception while waiting for mock server JVM to start", e);
            }
            InstanceHolder.runInitializationClass(this.getServerPorts(), this.createInitializer());
        }
    }

    @VisibleForTesting
    String getJavaBin() {
        String javaBinary = "java";
        File javaHomeDirectory = new File(System.getProperty("java.home"));
        for (String javaExecutable : new String[]{"java", "java.exe"}) {
            File javaExeLocation = new File(javaHomeDirectory, MockServerRunForkedMojo.fileSeparators("bin/" + javaExecutable));
            if (!javaExeLocation.exists() || !javaExeLocation.isFile()) continue;
            javaBinary = javaExeLocation.getAbsolutePath();
            break;
        }
        return javaBinary;
    }

    private String resolvePathForDependencyJar(Dependency dependency) {
        String path = "";
        try {
            Artifact dependencyArtifact = this.repositorySystem.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
            this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), dependencyArtifact);
            if (dependencyArtifact != null) {
                ArtifactRepository localRepository = this.session.getLocalRepository();
                path = localRepository.getBasedir() + "/" + localRepository.pathOf(dependencyArtifact);
            }
        }
        catch (ArtifactResolverException e) {
            this.getLog().warn((CharSequence)("Exception while resolving file path for dependency " + dependency), (Throwable)e);
        }
        return path;
    }

    private String resolvePathForJarWithDependencies() {
        Dependency dependency = new Dependency();
        dependency.setGroupId("org.mock-server");
        dependency.setArtifactId("mockserver-netty");
        dependency.setVersion(this.getVersion());
        dependency.setType("jar");
        dependency.setClassifier("jar-with-dependencies");
        return this.resolvePathForDependencyJar(dependency);
    }

    @VisibleForTesting
    String getVersion() {
        String version = "5.2.3";
        try {
            Properties p = new Properties();
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/org.mock-server/mockserver-maven-plugin/pom.properties");
            if (is != null) {
                p.load(is);
                version = p.getProperty("version", "5.2.3");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getLog().info((CharSequence)("Using org.mock-server:mockserver-netty:" + version + ":jar-with-dependencies"));
        return version;
    }
}

