/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.filters.LogFilter;
import org.mockserver.logging.LogFormatter;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.mockserver.MockServer;
import org.mockserver.model.Action;
import org.mockserver.model.Body;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.Header;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.socket.SSLFactory;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MockServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private LogFormatter logFormatter = new LogFormatter(this.logger);
    private MockServer server;
    private LogFilter logFilter;
    private MockServerMatcher mockServerMatcher;
    private ActionHandler actionHandler;
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();

    public MockServerHandler(MockServer server, MockServerMatcher mockServerMatcher, LogFilter logFilter) {
        this.mockServerMatcher = mockServerMatcher;
        this.server = server;
        this.logFilter = logFilter;
        this.actionHandler = new ActionHandler(logFilter);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        try {
            if (request.matches("PUT", "/status")) {
                this.writeResponse(ctx, request, HttpResponseStatus.OK);
            } else if (request.matches("PUT", "/expectation")) {
                Expectation expectation = this.expectationSerializer.deserialize(request.getBodyAsString());
                SSLFactory.addSubjectAlternativeName((String)expectation.getHttpRequest().getFirstHeader("Host"));
                this.mockServerMatcher.when(expectation.getHttpRequest(), expectation.getTimes(), expectation.getTimeToLive()).thenRespond(expectation.getHttpResponse(false)).thenForward(expectation.getHttpForward()).thenError(expectation.getHttpError()).thenCallback(expectation.getHttpCallback());
                this.logFormatter.infoLog("creating expectation:{}", new Object[]{expectation});
                this.writeResponse(ctx, request, HttpResponseStatus.CREATED);
            } else if (request.matches("PUT", "/clear")) {
                HttpRequest httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
                this.logFilter.clear(httpRequest);
                this.mockServerMatcher.clear(httpRequest);
                this.logFormatter.infoLog("clearing expectations and request logs that match:{}", new Object[]{httpRequest});
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/reset")) {
                this.logFilter.reset();
                this.mockServerMatcher.reset();
                this.logFormatter.infoLog("resetting all expectations and request logs", new Object[0]);
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/dumpToLog")) {
                this.mockServerMatcher.dumpToLog(this.httpRequestSerializer.deserialize(request.getBodyAsString()));
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/retrieve")) {
                if (request.hasQueryStringParameter("type", "expectation")) {
                    Expectation[] expectations = this.mockServerMatcher.retrieve(this.httpRequestSerializer.deserialize(request.getBodyAsString()));
                    this.writeResponse(ctx, request, HttpResponseStatus.OK, this.expectationSerializer.serialize(expectations), "application/json");
                } else {
                    HttpRequest[] requests = this.logFilter.retrieve(this.httpRequestSerializer.deserialize(request.getBodyAsString()));
                    this.writeResponse(ctx, request, HttpResponseStatus.OK, this.httpRequestSerializer.serialize(requests), "application/json");
                }
            } else if (request.matches("PUT", "/verify")) {
                Verification verification = this.verificationSerializer.deserialize(request.getBodyAsString());
                this.logFormatter.infoLog("verifying:{}", new Object[]{verification});
                String result = this.logFilter.verify(verification);
                if (result.isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else {
                    this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
                }
            } else if (request.matches("PUT", "/verifySequence")) {
                VerificationSequence verificationSequence = this.verificationSequenceSerializer.deserialize(request.getBodyAsString());
                String result = this.logFilter.verify(verificationSequence);
                this.logFormatter.infoLog("verifying sequence:{}", new Object[]{verificationSequence});
                if (result.isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else {
                    this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
                }
            } else if (request.matches("PUT", "/stop")) {
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                ctx.flush();
                ctx.close();
                this.server.stop();
            } else {
                Action handle = this.mockServerMatcher.handle(request);
                if (handle instanceof HttpError) {
                    ChannelHandlerContext httpCodecContext;
                    HttpError httpError = ((HttpError)handle).applyDelay();
                    if (httpError.getResponseBytes() != null && (httpCodecContext = ctx.pipeline().context(HttpServerCodec.class)) != null) {
                        httpCodecContext.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])httpError.getResponseBytes())).awaitUninterruptibly();
                    }
                    if (httpError.getDropConnection().booleanValue()) {
                        ctx.close();
                    }
                } else {
                    HttpResponse response = this.actionHandler.processAction(handle, request);
                    this.logFormatter.infoLog("returning response:{}" + System.getProperty("line.separator") + " for request:{}", new Object[]{response, request});
                    this.writeResponse(ctx, request, response);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Exception processing " + request, (Throwable)e);
            this.writeResponse(ctx, request, HttpResponseStatus.BAD_REQUEST);
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(ctx, request, responseStatus, "", "application/json");
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(responseStatus.code())).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.updateHeader(Header.header((String)"Content-Type", (String[])new String[]{contentType + "; charset=utf-8"}));
        }
        this.writeResponse(ctx, request, response);
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        if (response == null) {
            response = HttpResponse.notFoundResponse();
        }
        this.addContentLengthHeader(response);
        this.addConnectionHeader(request, response);
        this.addContentTypeHeader(response);
        this.writeAndCloseSocket(ctx, request, response);
    }

    private void addContentTypeHeader(HttpResponse response) {
        if (response.getBody() != null && Strings.isNullOrEmpty((String)response.getFirstHeader("Content-Type"))) {
            Charset bodyCharset = response.getBody().getCharset(null);
            String bodyContentType = response.getBody().getContentType();
            if (bodyCharset != null) {
                response.updateHeader(Header.header((String)"Content-Type", (String[])new String[]{bodyContentType + "; charset=" + bodyCharset.name().toLowerCase()}));
            } else if (bodyContentType != null) {
                response.updateHeader(Header.header((String)"Content-Type", (String[])new String[]{bodyContentType}));
            }
        }
    }

    private void addContentLengthHeader(HttpResponse response) {
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        if (connectionOptions != null && connectionOptions.getContentLengthHeaderOverride() != null) {
            response.updateHeader(Header.header((String)"Content-Length", (int)connectionOptions.getContentLengthHeaderOverride()));
        } else if (connectionOptions == null || ConnectionOptions.isFalseOrNull((Boolean)connectionOptions.getSuppressContentLengthHeader())) {
            Body body = response.getBody();
            byte[] bodyBytes = new byte[]{};
            if (body != null) {
                Object bodyContents = body.getValue();
                Charset bodyCharset = body.getCharset(ContentTypeMapper.determineCharsetForMessage((HttpResponse)response));
                if (bodyContents instanceof byte[]) {
                    bodyBytes = (byte[])bodyContents;
                } else if (bodyContents instanceof String) {
                    bodyBytes = ((String)bodyContents).getBytes(bodyCharset);
                } else if (body.toString() != null) {
                    bodyBytes = body.toString().getBytes(bodyCharset);
                }
            }
            response.updateHeader(Header.header((String)"Content-Length", (int)bodyBytes.length));
        } else {
            response.updateHeader(Header.header((String)"Content-Length", (String[])new String[]{""}));
        }
    }

    private void addConnectionHeader(HttpRequest request, HttpResponse response) {
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        if (connectionOptions != null && connectionOptions.getKeepAliveOverride() != null) {
            if (connectionOptions.getKeepAliveOverride().booleanValue()) {
                response.updateHeader(Header.header((String)"Connection", (String[])new String[]{"keep-alive"}));
            } else {
                response.updateHeader(Header.header((String)"Connection", (String[])new String[]{"close"}));
            }
        } else if (connectionOptions == null || ConnectionOptions.isFalseOrNull((Boolean)connectionOptions.getSuppressConnectionHeader())) {
            if (request.isKeepAlive() != null && request.isKeepAlive().booleanValue() && (connectionOptions == null || ConnectionOptions.isFalseOrNull((Boolean)connectionOptions.getCloseSocket()))) {
                response.updateHeader(Header.header((String)"Connection", (String[])new String[]{"keep-alive"}));
            } else {
                response.updateHeader(Header.header((String)"Connection", (String[])new String[]{"close"}));
            }
        }
    }

    private void writeAndCloseSocket(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        boolean closeChannel;
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        if (connectionOptions != null && connectionOptions.getCloseSocket() != null) {
            closeChannel = connectionOptions.getCloseSocket();
        } else {
            boolean bl = closeChannel = request.isKeepAlive() == null || request.isKeepAlive() == false;
        }
        if (closeChannel) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.write((Object)response);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!cause.getMessage().contains("Connection reset by peer")) {
            this.logger.warn("Exception caught by MockServer handler closing pipeline", cause);
        }
        ctx.close();
    }
}

