/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver.callback.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.mockserver.mockserver.callback.client.WebSocketClientException;
import org.mockserver.mockserver.callback.client.WebSocketClientHandler;

public class WebSocketClient {
    private Channel ch;
    private EventLoopGroup group = new NioEventLoopGroup();

    public WebSocketClient() {
        try {
            URI uri = new URI("ws://localhost:1234/websocket");
            final WebSocketClientHandler handler = new WebSocketClientHandler(uri);
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(Integer.MAX_VALUE), handler});
                }
            });
            this.ch = b.connect(uri.getHost(), uri.getPort()).sync().channel();
            handler.handshakeFuture().sync();
            this.sendWebSocketFrame((WebSocketFrame)new TextWebSocketFrame("connect" + UUID.randomUUID().toString()));
        }
        catch (InterruptedException e) {
            throw new WebSocketClientException(e);
        }
        catch (URISyntaxException e) {
            throw new WebSocketClientException(e);
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        WebSocketClient webSocketClient = new WebSocketClient();
        TimeUnit.SECONDS.sleep(20L);
        webSocketClient.stopClient();
    }

    public void stopClient() {
        this.sendWebSocketFrame((WebSocketFrame)new CloseWebSocketFrame());
        this.group.shutdownGracefully();
    }

    public void sendWebSocketFrame(WebSocketFrame webSocketFrame) {
        this.ch.writeAndFlush((Object)webSocketFrame);
        if (webSocketFrame instanceof CloseWebSocketFrame) {
            try {
                this.ch.closeFuture().sync();
            }
            catch (InterruptedException e) {
                throw new WebSocketClientException(e);
            }
        }
    }
}

