/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.mockserver.filters.RequestLogFilter;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mockserver.MockServerInitializer;
import org.mockserver.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.stop.StopEventQueue;
import org.mockserver.stop.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServer
implements Stoppable {
    static final AttributeKey<RequestLogFilter> LOG_FILTER = AttributeKey.valueOf((String)"SERVER_LOG_FILTER");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MockServerMatcher mockServerMatcher = new MockServerMatcher();
    private final RequestLogFilter requestLogFilter = new RequestLogFilter();
    private final WebSocketClientRegistry webSocketClientRegistry = new WebSocketClientRegistry();
    private final List<Future<Channel>> channelOpenedFutures = new ArrayList<Future<Channel>>();
    private final SettableFuture<String> stopping = SettableFuture.create();
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private final ServerBootstrap serverBootstrap;
    private StopEventQueue stopEventQueue = new StopEventQueue();

    public MockServer(Integer ... requestedPortBindings) {
        if (requestedPortBindings == null || requestedPortBindings.length == 0) {
            throw new IllegalArgumentException("You must specify at least one port");
        }
        this.serverBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)32768).childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)8192).childHandler((ChannelHandler)new MockServerInitializer(this.mockServerMatcher, this, this.webSocketClientRegistry)).childAttr(LOG_FILTER, (Object)this.requestLogFilter);
        this.bindToPorts(Arrays.asList(requestedPortBindings));
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                MockServer.this.bossGroup.shutdownGracefully();
                MockServer.this.workerGroup.shutdownGracefully();
            }
        }));
    }

    List<Integer> bindToPorts(List<Integer> requestedPortBindings) {
        ArrayList<Integer> actualPortBindings = new ArrayList<Integer>();
        for (final Integer port : requestedPortBindings) {
            try {
                final SettableFuture channelOpened = SettableFuture.create();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        MockServer.this.channelOpenedFutures.add(channelOpened);
                        try {
                            Channel channel = MockServer.this.serverBootstrap.bind(port.intValue()).addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) throws Exception {
                                    if (future.isSuccess()) {
                                        channelOpened.set((Object)future.channel());
                                    } else {
                                        channelOpened.setException(future.cause());
                                    }
                                }
                            }).channel();
                            MockServer.this.logger.info("MockServer started on port: {}", (Object)((InetSocketAddress)((Channel)channelOpened.get()).localAddress()).getPort());
                            channel.closeFuture().syncUninterruptibly();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Exception while binding MockServer to port " + port, e.getCause());
                        }
                    }
                }, "MockServer thread for port: " + port).start();
                actualPortBindings.add(((InetSocketAddress)((Channel)channelOpened.get()).localAddress()).getPort());
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while binding MockServer to port " + port, e.getCause());
            }
        }
        return actualPortBindings;
    }

    @Override
    public Future<?> stop() {
        try {
            for (Future<Channel> channelOpened : new ArrayList<Future<Channel>>(this.channelOpenedFutures)) {
                channelOpened.get().close().sync();
            }
            this.bossGroup.shutdownGracefully().sync();
            this.workerGroup.shutdownGracefully().sync();
            this.stopEventQueue.stopOthers(this).get();
            this.stopping.set((Object)"stopped");
        }
        catch (Exception ie) {
            this.logger.trace("Exception while stopping MockServer", (Throwable)ie);
            this.stopping.setException((Throwable)ie);
        }
        return this.stopping;
    }

    MockServer withStopEventQueue(StopEventQueue stopEventQueue) {
        this.stopEventQueue = stopEventQueue;
        this.stopEventQueue.register(this);
        return this;
    }

    public boolean isRunning() {
        return !this.bossGroup.isShuttingDown() || !this.workerGroup.isShuttingDown() || !this.stopping.isDone();
    }

    public List<Integer> getPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Future<Channel> channelOpened : this.channelOpenedFutures) {
            try {
                ports.add(((InetSocketAddress)channelOpened.get(2L, TimeUnit.SECONDS).localAddress()).getPort());
            }
            catch (Exception e) {
                this.logger.trace("Exception while retrieving port from channel future, ignoring port for this channel", (Throwable)e);
            }
        }
        return ports;
    }

    public int getPort() {
        for (Future<Channel> channelOpened : this.channelOpenedFutures) {
            try {
                return ((InetSocketAddress)channelOpened.get(2L, TimeUnit.SECONDS).localAddress()).getPort();
            }
            catch (Exception e) {
                this.logger.trace("Exception while retrieving port from channel future, ignoring port for this channel", (Throwable)e);
            }
        }
        return -1;
    }
}

