/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mockserver.MockServer;
import org.mockserver.mockserver.MockServerHandler;
import org.mockserver.proxy.filters.LogFilter;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final MockServerMatcher mockServerMatcher;
    private final LogFilter logFilter;
    private final MockServer server;
    private final boolean secure;

    public MockServerInitializer(MockServerMatcher mockServerMatcher, LogFilter logFilter, MockServer server, boolean secure) {
        this.mockServerMatcher = mockServerMatcher;
        this.logFilter = logFilter;
        this.server = server;
        this.secure = secure;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.secure) {
            SSLEngine engine = SSLFactory.getInstance().sslContext().createSSLEngine();
            engine.setUseClientMode(false);
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        }
        if (this.logger.isDebugEnabled()) {
            pipeline.addLast("logger", (ChannelHandler)new LoggingHandler());
        }
        pipeline.addLast("decoder-encoder", (ChannelHandler)new HttpServerCodec());
        pipeline.addLast("handler", (ChannelHandler)new MockServerHandler(this.mockServerMatcher, this.logFilter, this.server, this.secure));
    }
}

