/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http.relay;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import org.mockserver.proxy.http.relay.BasicHttpDecoder;
import org.mockserver.proxy.interceptor.Interceptor;
import org.slf4j.Logger;

public class ProxyRelayHandler
extends ChannelDuplexHandler {
    private final Logger logger;
    private final Interceptor interceptor;
    private final int bufferedCapacity;
    private volatile Channel relayChannel;
    private volatile ByteBuf channelBuffer;
    private volatile boolean bufferedMode;
    private volatile boolean flushedBuffer;
    private volatile Integer contentLength;
    private volatile int contentSoFar;
    private volatile boolean flushContent;

    public ProxyRelayHandler(Channel relayChannel, int bufferedCapacity, Interceptor interceptor, Logger logger) {
        this.relayChannel = relayChannel;
        this.bufferedCapacity = bufferedCapacity;
        this.interceptor = interceptor;
        this.logger = logger;
        this.bufferedMode = bufferedCapacity > 0;
        this.flushedBuffer = false;
        this.contentLength = null;
        this.contentSoFar = 0;
        this.flushContent = false;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.channelBuffer = Unpooled.directBuffer((int)this.bufferedCapacity);
        super.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.channelBuffer.refCnt() >= 1) {
            this.channelBuffer.release();
        }
        super.handlerRemoved(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
        ctx.write((Object)Unpooled.EMPTY_BUFFER);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.relayChannel.isActive()) {
            if (this.bufferedMode && this.channelBuffer.isReadable()) {
                this.flushedBuffer = true;
                this.logger.debug("CHANNEL INACTIVE: " + this.channelBuffer.toString(Charsets.UTF_8));
                this.relayChannel.writeAndFlush((Object)this.interceptor.intercept(ctx, this.channelBuffer, this.logger)).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            ProxyRelayHandler.this.channelBuffer.clear();
                            ProxyRelayHandler.this.relayChannel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        } else {
                            ProxyRelayHandler.this.logger.warn("Failed to send flush channel buffer", future.cause());
                            future.channel().close();
                        }
                    }
                });
            } else {
                this.relayChannel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.bufferedMode && this.relayChannel.isActive() && this.channelBuffer.isReadable()) {
            this.flushedBuffer = true;
            this.relayChannel.writeAndFlush((Object)this.interceptor.intercept(ctx, this.channelBuffer, this.logger)).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        ProxyRelayHandler.this.channelBuffer.clear();
                    } else {
                        ProxyRelayHandler.this.logger.warn("Failed to send flush channel buffer", future.cause());
                        future.channel().close();
                    }
                }
            });
        }
        super.channelReadComplete(ctx);
    }

    public void channelRead(final ChannelHandlerContext ctx, final Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            final ByteBuf chunk = (ByteBuf)msg;
            if (this.flushedBuffer) {
                this.bufferedMode = false;
            }
            if (this.bufferedMode) {
                this.flushContent = false;
                if (this.contentLength != null) {
                    this.contentSoFar += chunk.readableBytes();
                } else {
                    BasicHttpDecoder basicHttpDecoder = new BasicHttpDecoder(Unpooled.copiedBuffer((ByteBuf)chunk));
                    this.contentLength = basicHttpDecoder.getContentLength();
                    this.contentSoFar = chunk.readableBytes() - basicHttpDecoder.getContentStart();
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("CHUNK:                     ---\n-" + System.getProperty("line.separator") + Unpooled.copiedBuffer((ByteBuf)chunk).toString(Charsets.UTF_8) + "\n-" + System.getProperty("line.separator"));
                    this.logger.trace("CONTENT-SO-FAR-PRE-CHUNK:  --- " + (this.contentSoFar - Unpooled.copiedBuffer((ByteBuf)chunk).toString(Charsets.UTF_8).length()));
                    this.logger.trace("CHUNK-SIZE:                --- " + chunk.readableBytes());
                    this.logger.trace("CONTENT-SO-FAR-PRE-CHUNK:  --- " + this.contentSoFar);
                    if (this.contentLength != null) {
                        this.logger.trace("CONTENT-REMAINING:         --- " + (this.contentLength - this.contentSoFar));
                        this.logger.trace("CONTENT-LENGTH:            --- " + this.contentLength);
                    }
                }
                if (this.contentLength != null) {
                    this.logger.trace("Flushing buffer as all content received");
                    this.flushContent = this.contentSoFar >= this.contentLength || chunk.readableBytes() == 0;
                }
                try {
                    this.channelBuffer.writeBytes(chunk);
                    ctx.channel().read();
                }
                catch (IndexOutOfBoundsException iobe) {
                    this.logger.trace("Flushing buffer and switching to chunked mode as buffer full");
                    this.flushContent = true;
                }
                if (this.flushContent) {
                    this.flushedBuffer = true;
                    if (this.relayChannel.isActive() && this.channelBuffer.isReadable()) {
                        this.logger.debug("CHANNEL READ EX: " + chunk.toString(Charsets.UTF_8));
                        this.relayChannel.writeAndFlush((Object)this.channelBuffer).addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (future.isSuccess()) {
                                    ProxyRelayHandler.this.channelBuffer.clear();
                                    ProxyRelayHandler.this.channelRead(ctx, chunk);
                                } else {
                                    ProxyRelayHandler.this.logger.warn("Failed to send flush channel buffer [" + ProxyRelayHandler.this.channelBuffer + "]", future.cause());
                                    future.channel().close();
                                }
                            }
                        });
                    }
                }
            } else {
                this.bufferedMode = false;
                if (this.relayChannel.isActive()) {
                    this.logger.debug("CHANNEL READ NOT-BUFFERING: " + chunk.toString(Charsets.UTF_8));
                    this.relayChannel.writeAndFlush((Object)chunk).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isSuccess()) {
                                ctx.channel().read();
                            } else {
                                ProxyRelayHandler.this.logger.warn("Failed to send flush chunk [" + chunk + "]", future.cause());
                                future.channel().close();
                            }
                        }
                    });
                }
            }
        } else if (this.relayChannel.isActive()) {
            this.relayChannel.writeAndFlush(msg).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        ProxyRelayHandler.this.logger.warn("Failed to send flush msg [" + msg + "]", future.cause());
                        future.channel().close();
                    }
                }
            });
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.warn("Exception caught by http proxy relay handler closing pipeline", cause);
        Channel ch = ctx.channel();
        if (ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

