/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.ServerCookieEncoder;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;

public class MockServerResponseEncoder
extends MessageToMessageEncoder<HttpResponse> {
    protected void encode(ChannelHandlerContext ctx, HttpResponse httpResponse, List<Object> out) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)(httpResponse.getStatusCode() != null ? httpResponse.getStatusCode() : 200)), this.getBody(httpResponse));
        this.setHeaders(httpResponse, defaultFullHttpResponse);
        this.setCookies(httpResponse, defaultFullHttpResponse);
        out.add(defaultFullHttpResponse);
    }

    private ByteBuf getBody(HttpResponse httpResponse) {
        ByteBuf content = Unpooled.buffer((int)0);
        if (httpResponse.getBodyAsString() != null) {
            content = httpResponse.getBody() instanceof BinaryBody ? Unpooled.copiedBuffer((byte[])Base64Converter.base64StringToBytes((String)httpResponse.getBodyAsString())) : Unpooled.copiedBuffer((byte[])httpResponse.getBodyAsString().getBytes());
        }
        return content;
    }

    private void setHeaders(HttpResponse httpResponse, DefaultFullHttpResponse httpServletResponse) {
        if (httpResponse.getHeaders() != null) {
            for (Header header : httpResponse.getHeaders()) {
                for (String value : header.getValues()) {
                    httpServletResponse.headers().add(header.getName(), (Object)value);
                }
            }
        }
    }

    private void setCookies(HttpResponse httpResponse, DefaultFullHttpResponse httpServletResponse) {
        if (httpResponse.getCookies() != null) {
            ArrayList<String> cookieValues = new ArrayList<String>();
            for (org.mockserver.model.Cookie cookie : httpResponse.getCookies()) {
                for (String value : cookie.getValues()) {
                    cookieValues.add(ServerCookieEncoder.encode((Cookie)new DefaultCookie(cookie.getName(), value)));
                }
            }
            if (!cookieValues.isEmpty()) {
                httpServletResponse.headers().add("Set-Cookie", cookieValues);
            }
        }
    }
}

