/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import org.mockserver.codec.MockServerServerCodec;
import org.mockserver.filters.LogFilter;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mockserver.MockServer;
import org.mockserver.mockserver.MockServerHandler;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final MockServerMatcher mockServerMatcher;
    private final LogFilter logFilter;
    private final boolean secure;
    private final MockServer mockServer;

    public MockServerInitializer(MockServerMatcher mockServerMatcher, LogFilter logFilter, MockServer mockServer, boolean secure) {
        this.mockServerMatcher = mockServerMatcher;
        this.logFilter = logFilter;
        this.secure = secure;
        this.mockServer = mockServer;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.secure) {
            SSLEngine engine = SSLFactory.getInstance().sslContext().createSSLEngine();
            engine.setUseClientMode(false);
            pipeline.addLast(new ChannelHandler[]{new SslHandler(engine)});
        }
        if (this.logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler()});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        pipeline.addLast(new ChannelHandler[]{new MockServerServerCodec(this.secure)});
        pipeline.addLast(new ChannelHandler[]{new MockServerHandler(this.mockServerMatcher, this.logFilter, this.mockServer)});
    }
}

