/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import com.google.common.base.Strings;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.filters.Filter;
import org.mockserver.filters.Filters;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.filters.LogFilter;
import org.mockserver.mock.Expectation;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.OutboundHttpRequest;
import org.mockserver.proxy.http.HttpProxy;
import org.mockserver.proxy.http.connect.HttpConnectHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpProxyHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final InetSocketAddress connectSocket;
    private final HttpProxy server;
    private final LogFilter logFilter;
    private final Filters filters = new Filters();
    private NettyHttpClient httpClient = new NettyHttpClient();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();

    public HttpProxyHandler(LogFilter logFilter, HttpProxy server, InetSocketAddress connectSocket) {
        super(false);
        this.logFilter = logFilter;
        this.server = server;
        this.connectSocket = connectSocket;
        this.filters.withFilter(new HttpRequest(), (Filter)new HopByHopHeaderFilter());
        this.filters.withFilter(new HttpRequest(), (Filter)logFilter);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        try {
            if (this.connectSocket != null && request.getMethod().equals("CONNECT")) {
                ctx.pipeline().addAfter(ctx.name(), HttpConnectHandler.class.getSimpleName(), (ChannelHandler)new HttpConnectHandler(this.connectSocket, true));
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.fireChannelRead((Object)request);
            } else if (request.matches("PUT", "/status")) {
                this.writeResponse(ctx, request, HttpResponseStatus.OK);
            } else if (request.matches("PUT", "/clear")) {
                this.logFilter.clear(this.httpRequestSerializer.deserialize(request.getBodyAsString()));
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/reset")) {
                this.logFilter.reset();
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/dumpToLog")) {
                this.logFilter.dumpToLog(this.httpRequestSerializer.deserialize(request.getBodyAsString()), request.hasQueryStringParameter("type", "java"));
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/retrieve")) {
                Expectation[] expectations = this.logFilter.retrieve(this.httpRequestSerializer.deserialize(request.getBodyAsString()));
                this.writeResponse(ctx, request, HttpResponseStatus.OK, this.expectationSerializer.serialize(expectations), "application/json");
            } else if (request.matches("PUT", "/verify")) {
                String result = this.logFilter.verify(this.verificationSerializer.deserialize(request.getBodyAsString()));
                if (result.isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else {
                    this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, "plain/text");
                }
            } else if (request.matches("PUT", "/verifySequence")) {
                String result = this.logFilter.verify(this.verificationSequenceSerializer.deserialize(request.getBodyAsString()));
                if (result.isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else {
                    this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, "plain/text");
                }
            } else if (request.matches("PUT", "/stop")) {
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                ctx.flush();
                ctx.close();
                this.server.stop();
            } else {
                this.writeResponse(ctx, request, this.forwardRequest(request));
            }
        }
        catch (Exception e) {
            this.logger.error("Exception processing " + request, (Throwable)e);
            this.writeResponse(ctx, request, HttpResponseStatus.BAD_REQUEST);
        }
    }

    private HttpResponse forwardRequest(HttpRequest httpRequest) {
        return this.sendRequest(this.filters.applyOnRequestFilters(httpRequest));
    }

    private HttpResponse sendRequest(HttpRequest httpRequest) {
        if (httpRequest != null) {
            String hostHeader = httpRequest.getFirstHeader("Host");
            if (!Strings.isNullOrEmpty((String)hostHeader)) {
                HttpResponse httpResponse;
                String[] hostHeaderParts = hostHeader.split(":");
                Integer port = httpRequest.isSecure() ? 443 : 80;
                if (hostHeaderParts.length > 1) {
                    port = Integer.parseInt(hostHeaderParts[1]);
                }
                if ((httpResponse = this.filters.applyOnResponseFilters(httpRequest, this.httpClient.sendRequest(OutboundHttpRequest.outboundRequest((String)hostHeaderParts[0], (Integer)port, (String)"", (HttpRequest)httpRequest)))) != null) {
                    return httpResponse;
                }
            } else {
                this.logger.error("Host header must be provided for requests being forwarded, the following request does not include the \"Host\" header:\n" + httpRequest);
                throw new IllegalArgumentException("Host header must be provided for requests being forwarded");
            }
        }
        return HttpResponse.notFoundResponse();
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(ctx, request, responseStatus, "", "application/json");
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        this.writeResponse(ctx, request, HttpResponse.response().withStatusCode(Integer.valueOf(responseStatus.code())).withBody(body).withHeader(Header.header((String)"Content-Type", (String[])new String[]{contentType + "; charset=utf-8"})));
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        response.withHeader(Header.header((String)"Content-Length", (int)response.getBodyAsString().getBytes().length));
        if (request.isKeepAlive()) {
            response.withHeader(Header.header((String)"Connection", (String[])new String[]{"keep-alive"}));
            ctx.write((Object)response);
        } else {
            response.withHeader(Header.header((String)"Connection", (String[])new String[]{"close"}));
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!cause.getMessage().contains("Connection reset by peer")) {
            this.logger.warn("Exception caught by MockServer handler closing pipeline", cause);
        }
        ctx.close();
    }
}

