/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.socks.SocksAuthScheme;
import io.netty.handler.codec.socks.SocksInitRequestDecoder;
import io.netty.handler.codec.socks.SocksMessageEncoder;
import io.netty.handler.codec.socks.SocksProtocolVersion;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.mockserver.codec.MockServerServerCodec;
import org.mockserver.filters.LogFilter;
import org.mockserver.proxy.http.HttpProxyHandler;
import org.mockserver.socket.SSLFactory;

public class ProxyUnificationHandler
extends ByteToMessageDecoder {
    private final boolean sslEnabled;
    private final boolean socksEnabled;
    private final LogFilter logFilter = new LogFilter();
    private final int port;

    public ProxyUnificationHandler(int port) {
        this(true, true, port);
    }

    private ProxyUnificationHandler(boolean sslEnabled, boolean socksEnabled, int port) {
        this.sslEnabled = sslEnabled;
        this.socksEnabled = socksEnabled;
        this.port = port;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        if (msg.readableBytes() < 5) {
            return;
        }
        if (this.isSsl(msg)) {
            this.enableSsl(ctx);
        } else if (this.isSocks(msg)) {
            this.enableSocks(ctx);
        } else if (this.isHttp(msg)) {
            this.switchToHttp(ctx);
        } else {
            msg.clear();
            ctx.close();
        }
    }

    private boolean isSsl(ByteBuf buf) {
        return this.sslEnabled && SslHandler.isEncrypted((ByteBuf)buf);
    }

    private boolean isSocks(ByteBuf msg) {
        if (this.socksEnabled) {
            switch (SocksProtocolVersion.fromByte((byte)msg.getByte(msg.readerIndex()))) {
                case SOCKS5: 
                case SOCKS4a: {
                    break;
                }
                default: {
                    return false;
                }
            }
            int numberOfAuthenticationMethods = msg.getByte(msg.readerIndex() + 1);
            block6: for (int i = 0; i < numberOfAuthenticationMethods; ++i) {
                switch (SocksAuthScheme.fromByte((byte)msg.getByte(msg.readerIndex() + 1 + i))) {
                    case NO_AUTH: 
                    case AUTH_PASSWORD: 
                    case AUTH_GSSAPI: {
                        continue block6;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return false;
    }

    private boolean isHttp(ByteBuf msg) {
        short letterOne = msg.getUnsignedByte(msg.readerIndex());
        short letterTwo = msg.getUnsignedByte(msg.readerIndex() + 1);
        short letterThree = msg.getUnsignedByte(msg.readerIndex() + 2);
        return letterOne == 71 && letterTwo == 69 && letterThree == 84 || letterOne == 80 && letterTwo == 79 && letterThree == 83 || letterOne == 80 && letterTwo == 85 && letterThree == 84 || letterOne == 72 && letterTwo == 69 && letterThree == 65 || letterOne == 79 && letterTwo == 80 && letterThree == 84 || letterOne == 80 && letterTwo == 65 && letterThree == 84 || letterOne == 68 && letterTwo == 69 && letterThree == 76 || letterOne == 84 && letterTwo == 82 && letterThree == 65 || letterOne == 67 && letterTwo == 79 && letterThree == 78;
    }

    private void enableSsl(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        SSLEngine engine = SSLFactory.getInstance().sslContext().createSSLEngine();
        engine.setUseClientMode(false);
        pipeline.addLast(new ChannelHandler[]{new SslHandler(engine)});
        pipeline.addLast(new ChannelHandler[]{new ProxyUnificationHandler(false, this.socksEnabled, this.port)});
        pipeline.remove((ChannelHandler)this);
    }

    private void enableSocks(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addLast(new ChannelHandler[]{new SocksInitRequestDecoder()});
        pipeline.addLast(new ChannelHandler[]{new SocksMessageEncoder()});
        pipeline.addLast(new ChannelHandler[]{new MockServerServerCodec(this.socksEnabled)});
        pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler(this.logFilter, null, new InetSocketAddress(this.port))});
        pipeline.addLast(new ChannelHandler[]{new ProxyUnificationHandler(this.sslEnabled, false, this.port)});
        pipeline.remove((ChannelHandler)this);
    }

    private void switchToHttp(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new MockServerServerCodec(this.socksEnabled)});
        pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler(this.logFilter, null, new InetSocketAddress(this.port))});
        pipeline.remove((ChannelHandler)this);
    }
}

