/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.junit;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockserver.client.server.MockServerClient;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.socket.PortFactory;

public class MockServerRule
implements TestRule {
    private static ClientAndServer perTestSuiteClientAndServer;
    private final Object target;
    private final Integer port;
    private final boolean perTestSuite;
    private ClientAndServerFactory clientAndServerFactory;

    public MockServerRule(Object target) {
        this(PortFactory.findFreePort(), target);
    }

    public MockServerRule(Object target, boolean perTestSuite) {
        this(PortFactory.findFreePort(), target, perTestSuite);
    }

    public MockServerRule(Integer port, Object target) {
        this(port, target, false);
    }

    public MockServerRule(Integer port, Object target, boolean perTestSuite) {
        this.port = port;
        this.target = target;
        this.perTestSuite = perTestSuite;
        this.clientAndServerFactory = new ClientAndServerFactory(port);
    }

    public Integer getHttpPort() {
        return this.port;
    }

    public Statement apply(Statement base, Description description) {
        return this.statement(base);
    }

    private Statement statement(final Statement base) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ClientAndServer clientAndServer;
                if (MockServerRule.this.perTestSuite) {
                    if (perTestSuiteClientAndServer == null) {
                        perTestSuiteClientAndServer = MockServerRule.this.clientAndServerFactory.newClientAndServer();
                        Runtime.getRuntime().addShutdownHook(new Thread(){

                            @Override
                            public void run() {
                                perTestSuiteClientAndServer.stop();
                            }
                        });
                    }
                    clientAndServer = perTestSuiteClientAndServer;
                } else {
                    clientAndServer = MockServerRule.this.clientAndServerFactory.newClientAndServer();
                }
                MockServerRule.this.setMockServerClient(MockServerRule.this.target, clientAndServer);
                try {
                    base.evaluate();
                }
                finally {
                    if (!MockServerRule.this.perTestSuite) {
                        clientAndServer.stop();
                    }
                }
            }
        };
    }

    private void setMockServerClient(Object target, ClientAndServer clientAndServer) {
        for (Field field : target.getClass().getDeclaredFields()) {
            if (!field.getType().equals(MockServerClient.class)) continue;
            field.setAccessible(true);
            try {
                field.set(target, (Object)clientAndServer);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error setting MockServerClient field on " + target.getClass().getName(), e);
            }
        }
    }

    @VisibleForTesting
    class ClientAndServerFactory {
        private final Integer port;

        public ClientAndServerFactory(Integer port) {
            this.port = port;
        }

        public ClientAndServer newClientAndServer() {
            return ClientAndServer.startClientAndServer(this.port);
        }
    }
}

