/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import com.google.common.net.MediaType;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.client.serialization.curl.OutboundRequestToCurlSerializer;
import org.mockserver.filters.Filter;
import org.mockserver.filters.Filters;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.filters.LogFilter;
import org.mockserver.logging.LogFormatter;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.mock.Expectation;
import org.mockserver.model.Body;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.OutboundHttpRequest;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.connect.HttpConnectHandler;
import org.mockserver.proxy.error.Logging;
import org.mockserver.proxy.http.HttpProxy;
import org.mockserver.proxy.unification.PortUnificationHandler;
import org.mockserver.socket.SSLFactory;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpProxyHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Proxy server;
    private final LogFilter logFilter;
    private final boolean onwardSslStatusUnknown;
    private final Filters filters = new Filters();
    private LogFormatter logFormatter = new LogFormatter(this.logger);
    private NettyHttpClient httpClient = new NettyHttpClient();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private OutboundRequestToCurlSerializer outboundRequestToCurlSerializer = new OutboundRequestToCurlSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();

    public HttpProxyHandler(Proxy server, LogFilter logFilter, Boolean onwardSslStatusUnknown) {
        super(false);
        this.server = server;
        this.logFilter = logFilter;
        this.onwardSslStatusUnknown = onwardSslStatusUnknown != null ? onwardSslStatusUnknown : false;
        this.filters.withFilter(new HttpRequest(), (Filter)new HopByHopHeaderFilter());
        this.filters.withFilter(new HttpRequest(), (Filter)logFilter);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        try {
            this.logFormatter.traceLog("received request:{}" + System.getProperty("line.separator"), new Object[]{request});
            if (request.getMethod().getValue().equals("CONNECT")) {
                PortUnificationHandler.enabledSslUpstreamAndDownstream(ctx.channel());
                SSLFactory.addSubjectAlternativeName((String)request.getPath().getValue());
                ctx.pipeline().addLast(new ChannelHandler[]{new HttpConnectHandler()});
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.fireChannelRead((Object)request);
            } else if (request.matches("PUT", "/status")) {
                this.writeResponse(ctx, request, HttpResponseStatus.OK);
            } else if (request.matches("PUT", "/clear")) {
                HttpRequest httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
                this.logFilter.clear(httpRequest);
                this.logFormatter.infoLog("clearing expectations and request logs that match:{}", new Object[]{httpRequest});
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/reset")) {
                this.logFilter.reset();
                this.logFormatter.infoLog("resetting all expectations and request logs", new Object[0]);
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/dumpToLog")) {
                this.logFilter.dumpToLog(this.httpRequestSerializer.deserialize(request.getBodyAsString()), request.hasQueryStringParameter("type", "java"));
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/retrieve")) {
                Expectation[] expectations = this.logFilter.retrieve(this.httpRequestSerializer.deserialize(request.getBodyAsString()));
                this.writeResponse(ctx, request, HttpResponseStatus.OK, this.expectationSerializer.serialize(expectations), "application/json");
            } else if (request.matches("PUT", "/verify")) {
                Verification verification = this.verificationSerializer.deserialize(request.getBodyAsString());
                this.logFormatter.infoLog("verifying:{}", new Object[]{verification});
                String result = this.logFilter.verify(verification);
                if (result.isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else {
                    this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
                }
            } else if (request.matches("PUT", "/verifySequence")) {
                VerificationSequence verificationSequence = this.verificationSequenceSerializer.deserialize(request.getBodyAsString());
                String result = this.logFilter.verify(verificationSequence);
                this.logFormatter.infoLog("verifying sequence:{}", new Object[]{verificationSequence});
                if (result.isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else {
                    this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
                }
            } else if (request.matches("PUT", "/stop")) {
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                ctx.flush();
                ctx.close();
                this.server.stop();
            } else {
                OutboundHttpRequest outboundHttpRequest = OutboundHttpRequest.outboundRequest((InetSocketAddress)((InetSocketAddress)ctx.channel().attr(HttpProxy.REMOTE_SOCKET).get()), (String)"", (HttpRequest)this.filters.applyOnRequestFilters(request));
                if (outboundHttpRequest != null) {
                    HttpResponse response = this.sendRequest(outboundHttpRequest);
                    this.logFormatter.infoLog("returning response:{}" + System.getProperty("line.separator") + " for request as json:{}" + System.getProperty("line.separator") + " as curl:{}", new Object[]{response, request, this.outboundRequestToCurlSerializer.toCurl(outboundHttpRequest)});
                    this.writeResponse(ctx, request, response);
                } else {
                    this.writeResponse(ctx, request, HttpResponse.notFoundResponse());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Exception processing " + request, (Throwable)e);
            this.writeResponse(ctx, request, HttpResponseStatus.BAD_REQUEST);
        }
    }

    private HttpResponse sendRequest(OutboundHttpRequest outboundHttpRequest) {
        HttpResponse httpResponse = this.filters.applyOnResponseFilters((HttpRequest)outboundHttpRequest, this.httpClient.sendRequest(outboundHttpRequest, this.onwardSslStatusUnknown));
        if (httpResponse == null) {
            httpResponse = HttpResponse.notFoundResponse();
        }
        return httpResponse;
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(ctx, request, responseStatus, "", "application/json");
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        this.writeResponse(ctx, request, HttpResponse.response().withStatusCode(Integer.valueOf(responseStatus.code())).withBody(body).updateHeader(Header.header((String)"Content-Type", (String[])new String[]{contentType + "; charset=utf-8"})));
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        this.addContentLengthHeader(response);
        if (request.isKeepAlive() != null && request.isKeepAlive().booleanValue()) {
            response.updateHeader(Header.header((String)"Connection", (String[])new String[]{"keep-alive"}));
            ctx.write((Object)response);
        } else {
            response.updateHeader(Header.header((String)"Connection", (String[])new String[]{"close"}));
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void addContentLengthHeader(HttpResponse response) {
        Body body = response.getBody();
        byte[] bodyBytes = new byte[]{};
        if (body != null) {
            Object bodyContents = body.getValue();
            Charset bodyCharset = body.getCharset(ContentTypeMapper.determineCharsetForMessage((HttpResponse)response));
            if (bodyContents instanceof byte[]) {
                bodyBytes = (byte[])bodyContents;
            } else if (bodyContents instanceof String) {
                bodyBytes = ((String)bodyContents).getBytes(bodyCharset);
            } else if (body.toString() != null) {
                bodyBytes = body.toString().getBytes(bodyCharset);
            }
        }
        response.updateHeader(Header.header((String)"Content-Length", (int)bodyBytes.length));
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!Logging.shouldIgnoreException(cause)) {
            this.logger.warn("Exception caught by HTTP proxy handler -> closing pipeline " + ctx.channel(), cause);
        }
        ctx.close();
    }
}

