/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import com.google.common.net.MediaType;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.serialization.PortBindingSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.client.serialization.curl.HttpRequestToCurlSerializer;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.cors.CORSHeaders;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.filters.Filter;
import org.mockserver.filters.Filters;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.filters.RequestLogFilter;
import org.mockserver.filters.RequestResponseLogFilter;
import org.mockserver.logging.LogFormatter;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.PortBinding;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.connect.HttpConnectHandler;
import org.mockserver.proxy.unification.PortUnificationHandler;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpProxyHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final LogFormatter logFormatter = new LogFormatter(this.logger);
    private Proxy server;
    private RequestLogFilter requestLogFilter;
    private Filters filters = new Filters();
    private NettyHttpClient httpClient = new NettyHttpClient();
    private HttpStateHandler httpStateHandler;
    private HttpRequestToCurlSerializer httpRequestToCurlSerializer = new HttpRequestToCurlSerializer();
    private PortBindingSerializer portBindingSerializer = new PortBindingSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();
    private CORSHeaders addCORSHeaders = new CORSHeaders();

    public HttpProxyHandler(Proxy server, RequestLogFilter requestLogFilter, RequestResponseLogFilter requestResponseLogFilter) {
        super(false);
        this.server = server;
        this.requestLogFilter = requestLogFilter;
        this.filters.withFilter(HttpRequest.request(), (Filter)requestLogFilter);
        this.filters.withFilter(HttpRequest.request(), (Filter)requestResponseLogFilter);
        this.filters.withFilter(HttpRequest.request(), (Filter)new HopByHopHeaderFilter());
        this.httpStateHandler = new HttpStateHandler(requestLogFilter, requestResponseLogFilter, null);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        block24: {
            try {
                this.logFormatter.traceLog("received request:{}" + Character.NEW_LINE, new Object[]{request});
                if (request.getMethod().getValue().equals("CONNECT")) {
                    PortUnificationHandler.enabledSslUpstreamAndDownstream(ctx.channel());
                    KeyAndCertificateFactory.addSubjectAlternativeName((String)request.getPath().getValue());
                    ctx.pipeline().addLast(new ChannelHandler[]{new HttpConnectHandler(request.getPath().getValue(), -1)});
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.fireChannelRead((Object)request);
                    break block24;
                }
                if ((ConfigurationProperties.enableCORSForAPI() || ConfigurationProperties.enableCORSForAllResponses()) && request.getMethod().getValue().equals("OPTIONS") && !request.getFirstHeader("Origin").isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.OK);
                    break block24;
                }
                if (request.matches("PUT", "/status")) {
                    this.writeResponse(ctx, request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(this.server.getPorts())), "application/json");
                    break block24;
                }
                if (request.matches("PUT", "/bind")) {
                    PortBinding requestedPortBindings = this.portBindingSerializer.deserialize(request.getBodyAsString());
                    try {
                        List<Integer> actualPortBindings = this.server.bindToPorts(requestedPortBindings.getPorts());
                        this.writeResponse(ctx, request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                        break block24;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof BindException) {
                            this.writeResponse(ctx, request, HttpResponseStatus.BAD_REQUEST, e.getMessage() + " port already in use", MediaType.create((String)"text", (String)"plain").toString());
                            break block24;
                        }
                        throw e;
                    }
                }
                if (request.matches("PUT", "/clear")) {
                    this.httpStateHandler.clear(request);
                    this.writeResponse(ctx, request, HttpResponseStatus.OK);
                } else if (request.matches("PUT", "/reset")) {
                    this.httpStateHandler.reset();
                    this.writeResponse(ctx, request, HttpResponseStatus.OK);
                } else if (request.matches("PUT", "/dumpToLog")) {
                    this.httpStateHandler.dumpRecordedRequestResponsesToLog(request);
                    this.writeResponse(ctx, request, HttpResponseStatus.OK);
                } else if (request.matches("PUT", "/retrieve")) {
                    this.writeResponse(ctx, request, HttpResponseStatus.OK, this.httpStateHandler.retrieve(request), MediaType.JSON_UTF_8.toString().replace(request.hasQueryStringParameter("format", "java") ? "json" : "", "java"));
                } else if (request.matches("PUT", "/verify")) {
                    Verification verification = this.verificationSerializer.deserialize(request.getBodyAsString());
                    String result = this.requestLogFilter.verify(verification);
                    this.verifyResponse(ctx, request, result);
                    this.logFormatter.infoLog("verifying requests that match:{}", new Object[]{verification});
                } else if (request.matches("PUT", "/verifySequence")) {
                    VerificationSequence verificationSequence = this.verificationSequenceSerializer.deserialize(request.getBodyAsString());
                    String result = this.requestLogFilter.verify(verificationSequence);
                    this.verifyResponse(ctx, request, result);
                    this.logFormatter.infoLog("verifying sequence that match:{}", new Object[]{verificationSequence});
                } else if (request.matches("PUT", "/stop")) {
                    ctx.writeAndFlush((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.OK.code())));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            HttpProxyHandler.this.server.stop();
                        }
                    }).start();
                } else {
                    InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().attr(Proxy.REMOTE_SOCKET).get();
                    HttpResponse response = this.sendRequest(request, remoteAddress);
                    this.writeResponse(ctx, request, response);
                }
            }
            catch (IllegalArgumentException iae) {
                this.logger.error("Exception processing " + request, (Throwable)iae);
                this.writeResponse(ctx, request, HttpResponseStatus.BAD_REQUEST, iae.getMessage(), MediaType.create((String)"text", (String)"plain").toString());
            }
            catch (Exception e) {
                this.logger.error("Exception processing " + request, (Throwable)e);
                this.writeResponse(ctx, request, HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.BAD_REQUEST.code())).withBody(e.getMessage()));
            }
        }
    }

    private void verifyResponse(ChannelHandlerContext ctx, HttpRequest request, String result) {
        if (result.isEmpty()) {
            this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
        } else {
            this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(ctx, request, responseStatus, "", "application/json");
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(responseStatus.code())).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.updateHeader(Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{contentType + "; charset=utf-8"}));
        }
        if (ConfigurationProperties.enableCORSForAPI()) {
            this.addCORSHeaders.addCORSHeaders(response);
        }
        this.writeResponse(ctx, request, response);
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        if (ConfigurationProperties.enableCORSForAllResponses()) {
            this.addCORSHeaders.addCORSHeaders(response);
        }
        if (request.isKeepAlive() != null && request.isKeepAlive().booleanValue()) {
            response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.KEEP_ALIVE.toString()}));
            ctx.write((Object)response);
        } else {
            response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.CLOSE.toString()}));
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private HttpResponse sendRequest(HttpRequest httpRequest, InetSocketAddress remoteAddress) {
        HttpResponse httpResponse = HttpResponse.notFoundResponse();
        HttpRequest filteredRequest = this.filters.applyOnRequestFilters(httpRequest);
        if (filteredRequest != null) {
            httpResponse = this.filters.applyOnResponseFilters(httpRequest, this.httpClient.sendRequest(filteredRequest, remoteAddress));
            if (httpResponse == null) {
                httpResponse = HttpResponse.notFoundResponse();
            }
            this.logFormatter.infoLog("returning response:{}" + Character.NEW_LINE + " for request as json:{}" + Character.NEW_LINE + " as curl:{}", new Object[]{httpResponse, httpRequest, this.httpRequestToCurlSerializer.toCurl(httpRequest, remoteAddress)});
        }
        return httpResponse;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!ExceptionHandler.shouldIgnoreException(cause)) {
            this.logger.warn("Exception caught by " + this.server.getClass() + " handler -> closing pipeline " + ctx.channel(), cause);
        }
        ExceptionHandler.closeOnFlush(ctx.channel());
    }
}

