/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.cors.CORSHeaders;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.responsewriter.ResponseWriter;

public class NettyResponseWriter
implements ResponseWriter {
    private CORSHeaders addCORSHeaders = new CORSHeaders();
    private final ChannelHandlerContext ctx;

    public NettyResponseWriter(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(request, responseStatus, "", "application/json");
    }

    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(responseStatus.code())).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.updateHeader(Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{contentType + "; charset=utf-8"}));
        }
        if (ConfigurationProperties.enableCORSForAPI()) {
            this.addCORSHeaders.addCORSHeaders(response);
        }
        this.writeResponse(request, response);
    }

    public void writeResponse(HttpRequest request, HttpResponse response) {
        if (response == null) {
            response = HttpResponse.notFoundResponse();
        }
        if (ConfigurationProperties.enableCORSForAllResponses()) {
            this.addCORSHeaders.addCORSHeaders(response);
        }
        this.addConnectionHeader(request, response);
        this.writeAndCloseSocket(this.ctx, request, response);
    }

    private void addConnectionHeader(HttpRequest request, HttpResponse response) {
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        if (connectionOptions != null && connectionOptions.getKeepAliveOverride() != null) {
            if (connectionOptions.getKeepAliveOverride().booleanValue()) {
                response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.KEEP_ALIVE.toString()}));
            } else {
                response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.CLOSE.toString()}));
            }
        } else if (connectionOptions == null || ConnectionOptions.isFalseOrNull((Boolean)connectionOptions.getSuppressConnectionHeader())) {
            if (request.isKeepAlive() != null && request.isKeepAlive().booleanValue() && (connectionOptions == null || ConnectionOptions.isFalseOrNull((Boolean)connectionOptions.getCloseSocket()))) {
                response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.KEEP_ALIVE.toString()}));
            } else {
                response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.CLOSE.toString()}));
            }
        }
    }

    private void writeAndCloseSocket(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        boolean closeChannel;
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        if (connectionOptions != null && connectionOptions.getCloseSocket() != null) {
            closeChannel = connectionOptions.getCloseSocket();
        } else {
            boolean bl = closeChannel = request.isKeepAlive() == null || request.isKeepAlive() == false;
        }
        if (closeChannel) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.writeAndFlush((Object)response);
        }
    }
}

