/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import com.google.common.net.MediaType;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.serialization.PortBindingSerializer;
import org.mockserver.client.serialization.curl.HttpRequestToCurlSerializer;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.log.model.RequestResponseLogEntry;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mockserver.NettyResponseWriter;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.PortBinding;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.connect.HttpConnectHandler;
import org.mockserver.proxy.unification.PortUnificationHandler;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpProxyHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private HttpStateHandler httpStateHandler;
    private PortBindingSerializer portBindingSerializer = new PortBindingSerializer();
    private Proxy server;
    private NettyHttpClient httpClient = new NettyHttpClient();
    private HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();
    private LoggingFormatter logFormatter = new LoggingFormatter(this.logger);
    private HttpRequestToCurlSerializer httpRequestToCurlSerializer = new HttpRequestToCurlSerializer();

    public HttpProxyHandler(Proxy server, HttpStateHandler httpStateHandler) {
        super(false);
        this.server = server;
        this.httpStateHandler = httpStateHandler;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        block13: {
            NettyResponseWriter responseWriter = new NettyResponseWriter(ctx);
            try {
                if (this.httpStateHandler.handle(request, (ResponseWriter)responseWriter, false)) break block13;
                if (request.matches("PUT", "/status")) {
                    responseWriter.writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(this.server.getPorts())), "application/json");
                    break block13;
                }
                if (request.matches("PUT", "/bind")) {
                    PortBinding requestedPortBindings = this.portBindingSerializer.deserialize(request.getBodyAsString());
                    try {
                        List<Integer> actualPortBindings = this.server.bindToPorts(requestedPortBindings.getPorts());
                        responseWriter.writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                        break block13;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof BindException) {
                            responseWriter.writeResponse(request, HttpResponseStatus.BAD_REQUEST, e.getMessage() + " port already in use", MediaType.create((String)"text", (String)"plain").toString());
                            break block13;
                        }
                        throw e;
                    }
                }
                if (request.matches("PUT", "/stop")) {
                    ctx.writeAndFlush((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.OK.code())));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            HttpProxyHandler.this.server.stop();
                        }
                    }).start();
                } else if (request.getMethod().getValue().equals("CONNECT")) {
                    PortUnificationHandler.enabledSslUpstreamAndDownstream(ctx.channel());
                    KeyAndCertificateFactory.addSubjectAlternativeName((String)request.getPath().getValue());
                    ctx.pipeline().addLast(new ChannelHandler[]{new HttpConnectHandler(request.getPath().getValue(), -1)});
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.fireChannelRead((Object)request);
                } else {
                    InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().attr(Proxy.REMOTE_SOCKET).get();
                    HttpResponse response = this.httpClient.sendRequest(this.hopByHopHeaderFilter.onRequest(request), remoteAddress);
                    if (response == null) {
                        response = HttpResponse.notFoundResponse();
                    }
                    responseWriter.writeResponse(request, response);
                    this.httpStateHandler.log((LogEntry)new RequestResponseLogEntry(request, response));
                    this.logFormatter.infoLog("returning response:{}" + Character.NEW_LINE + " for request as json:{}" + Character.NEW_LINE + " as curl:{}", new Object[]{response, request, this.httpRequestToCurlSerializer.toCurl(request, remoteAddress)});
                }
            }
            catch (IllegalArgumentException iae) {
                this.logger.error("Exception processing " + request, (Throwable)iae);
                responseWriter.writeResponse(request, HttpResponseStatus.BAD_REQUEST, iae.getMessage(), MediaType.create((String)"text", (String)"plain").toString());
            }
            catch (Exception e) {
                this.logger.error("Exception processing " + request, (Throwable)e);
                responseWriter.writeResponse(request, HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.BAD_REQUEST.code())).withBody(e.getMessage()));
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!ExceptionHandler.shouldIgnoreException(cause)) {
            this.logger.warn("Exception caught by " + this.server.getClass() + " handler -> closing pipeline " + ctx.channel(), cause);
        }
        ExceptionHandler.closeOnFlush(ctx.channel());
    }
}

