/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.integration;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.mockserver.client.MockServerClient;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;
import org.mockserver.netty.MockServer;
import org.slf4j.event.Level;

public class ClientAndServer
extends MockServerClient {
    private final MockServer mockServer;

    public static void main(String[] args) {
        ConfigurationProperties.logLevel((String)"DEBUG");
        ClientAndServer clientAndServer = ClientAndServer.startClientAndServer(1080);
        clientAndServer.when((RequestDefinition)HttpRequest.request()).respond(HttpResponse.response());
        clientAndServer.stop();
    }

    public ClientAndServer(Integer ... ports) {
        super(new CompletableFuture());
        this.mockServer = new MockServer(ports);
        this.completePortFutureAndOpenUI();
    }

    public ClientAndServer(String remoteHost, Integer remotePort, Integer ... ports) {
        super(new CompletableFuture());
        this.mockServer = new MockServer(remotePort, remoteHost, ports);
        this.completePortFutureAndOpenUI();
    }

    private void completePortFutureAndOpenUI() {
        if (MockServerLogger.isEnabled((Level)Level.DEBUG) && ConfigurationProperties.launchUIForLogLevelDebug()) {
            this.portFuture.whenComplete((integer, throwable) -> this.openUI());
        }
        this.portFuture.complete(this.mockServer.getLocalPort());
    }

    public static ClientAndServer startClientAndServer(List<Integer> ports) {
        return ClientAndServer.startClientAndServer(ports.toArray(new Integer[0]));
    }

    public static ClientAndServer startClientAndServer(Integer ... port) {
        return new ClientAndServer(port);
    }

    public static ClientAndServer startClientAndServer(String remoteHost, Integer remotePort, Integer ... port) {
        return new ClientAndServer(remoteHost, remotePort, port);
    }

    public ClientAndServer openUI() {
        super.openUI();
        return this;
    }

    public ClientAndServer openUI(TimeUnit timeUnit, long pause) {
        super.openUI(timeUnit, pause);
        return this;
    }

    public boolean isRunning() {
        return this.mockServer.isRunning();
    }

    public boolean hasStarted() {
        return this.mockServer.isRunning();
    }

    public Future stopAsync() {
        Future<String> stopAsync = this.mockServer.stopAsync();
        if (stopAsync instanceof CompletableFuture) {
            ((CompletableFuture)stopAsync).thenAccept(ignore -> super.stop());
        } else {
            super.stopAsync();
        }
        return stopAsync;
    }

    public void stop() {
        this.mockServer.stop();
        super.stop();
    }

    public Integer getPort() {
        return this.mockServer.getLocalPort();
    }

    public Integer getLocalPort() {
        return this.mockServer.getLocalPort();
    }

    public List<Integer> getLocalPorts() {
        return this.mockServer.getLocalPorts();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.mockServer.getRemoteAddress();
    }
}

