/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.lifecycle;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpState;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.RequestDefinition;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.stop.Stoppable;
import org.slf4j.event.Level;

public abstract class LifeCycle
implements Stoppable {
    protected final MockServerLogger mockServerLogger;
    protected EventLoopGroup bossGroup = new NioEventLoopGroup(5, (ThreadFactory)new Scheduler.SchedulerThreadFactory(this.getClass().getSimpleName() + "-bossEventLoop"));
    protected EventLoopGroup workerGroup = new NioEventLoopGroup(ConfigurationProperties.nioEventLoopThreadCount(), (ThreadFactory)new Scheduler.SchedulerThreadFactory(this.getClass().getSimpleName() + "-workerEventLoop"));
    protected HttpState httpStateHandler;
    protected ServerBootstrap serverServerBootstrap;
    private List<Future<Channel>> serverChannelFutures = new ArrayList<Future<Channel>>();
    private Scheduler scheduler;

    protected LifeCycle() {
        this.mockServerLogger = new MockServerLogger(MockServerEventLog.class);
        this.scheduler = new Scheduler(this.mockServerLogger);
        this.httpStateHandler = new HttpState(this.mockServerLogger, this.scheduler);
    }

    public Future<String> stopAsync() {
        CompletableFuture<String> stopFuture = new CompletableFuture<String>();
        new Scheduler.SchedulerThreadFactory("Stop").newThread(() -> {
            this.scheduler.shutdown();
            this.httpStateHandler.stop();
            this.bossGroup.shutdownGracefully(5L, 5L, TimeUnit.MILLISECONDS);
            this.workerGroup.shutdownGracefully(5L, 5L, TimeUnit.MILLISECONDS);
            this.bossGroup.terminationFuture().syncUninterruptibly();
            this.workerGroup.terminationFuture().syncUninterruptibly();
            try {
                GlobalEventExecutor.INSTANCE.awaitInactivity(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            stopFuture.complete("done");
        }).start();
        return stopFuture;
    }

    public void stop() {
        block2: {
            try {
                this.stopAsync().get(10L, TimeUnit.SECONDS);
            }
            catch (Throwable throwable) {
                if (!MockServerLogger.isEnabled((Level)Level.DEBUG)) break block2;
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("exception while stopping - " + throwable.getMessage()).setArguments(new Object[]{throwable}));
            }
        }
    }

    public void close() {
        this.stop();
    }

    protected EventLoopGroup getEventLoopGroup() {
        return this.workerGroup;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public boolean isRunning() {
        return !this.bossGroup.isShuttingDown() || !this.workerGroup.isShuttingDown();
    }

    public List<Integer> getLocalPorts() {
        return this.getBoundPorts(this.serverChannelFutures);
    }

    @Deprecated
    public Integer getPort() {
        return this.getLocalPort();
    }

    public int getLocalPort() {
        return this.getFirstBoundPort(this.serverChannelFutures);
    }

    private Integer getFirstBoundPort(List<Future<Channel>> channelFutures) {
        for (Future<Channel> channelOpened : channelFutures) {
            try {
                return ((InetSocketAddress)channelOpened.get(15L, TimeUnit.SECONDS).localAddress()).getPort();
            }
            catch (Throwable throwable) {
                if (!MockServerLogger.isEnabled((Level)Level.WARN)) continue;
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("exception while retrieving port from channel future, ignoring port for this channel - " + throwable.getMessage()).setArguments(new Object[]{throwable}));
            }
        }
        return -1;
    }

    private List<Integer> getBoundPorts(List<Future<Channel>> channelFutures) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Future<Channel> channelOpened : channelFutures) {
            try {
                ports.add(((InetSocketAddress)channelOpened.get(3L, TimeUnit.SECONDS).localAddress()).getPort());
            }
            catch (Exception e) {
                if (!MockServerLogger.isEnabled((Level)Level.DEBUG)) continue;
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("exception while retrieving port from channel future, ignoring port for this channel").setArguments(new Object[]{e}));
            }
        }
        return ports;
    }

    public List<Integer> bindServerPorts(List<Integer> requestedPortBindings) {
        return this.bindPorts(this.serverServerBootstrap, requestedPortBindings, this.serverChannelFutures);
    }

    private List<Integer> bindPorts(ServerBootstrap serverBootstrap, List<Integer> requestedPortBindings, List<Future<Channel>> channelFutures) {
        ArrayList<Integer> actualPortBindings = new ArrayList<Integer>();
        String localBoundIP = ConfigurationProperties.localBoundIP();
        for (Integer portToBind : requestedPortBindings) {
            try {
                CompletableFuture channelOpened = new CompletableFuture();
                channelFutures.add(channelOpened);
                new Thread(() -> {
                    try {
                        InetSocketAddress inetSocketAddress = StringUtils.isBlank((CharSequence)localBoundIP) ? new InetSocketAddress(portToBind) : new InetSocketAddress(localBoundIP, (int)portToBind);
                        serverBootstrap.bind((SocketAddress)inetSocketAddress).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                            if (future.isSuccess()) {
                                channelOpened.complete(future.channel());
                            } else {
                                channelOpened.completeExceptionally(future.cause());
                            }
                        })).channel().closeFuture().syncUninterruptibly();
                    }
                    catch (Exception e) {
                        channelOpened.completeExceptionally(new RuntimeException("Exception while binding MockServer to port " + portToBind, e));
                    }
                }, "MockServer thread for port: " + portToBind).start();
                actualPortBindings.add(((InetSocketAddress)((Channel)channelOpened.get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS)).localAddress()).getPort());
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while binding MockServer to port " + portToBind, e.getCause());
            }
        }
        return actualPortBindings;
    }

    protected void startedServer(List<Integer> ports) {
        String message = "started on port" + (ports.size() == 1 ? ": " + ports.get(0) : "s: " + ports);
        if (MockServerLogger.isEnabled((Level)Level.INFO)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.INFO).setHttpRequest((RequestDefinition)HttpRequest.request()).setMessageFormat(message));
        }
    }
}

