/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.mockserver.client.NettyHttpClient;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.http.HttpActionHandler;
import org.mockserver.model.BinaryMessage;
import org.mockserver.netty.unification.PortUnificationHandler;
import org.mockserver.scheduler.Scheduler;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class BinaryHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private MockServerLogger mockServerLogger;
    private final Scheduler scheduler;
    private final NettyHttpClient httpClient;

    public BinaryHandler(MockServerLogger mockServerLogger, Scheduler scheduler, NettyHttpClient httpClient) {
        super(true);
        this.mockServerLogger = mockServerLogger;
        this.scheduler = scheduler;
        this.httpClient = httpClient;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf byteBuf) {
        BinaryMessage binaryRequest = BinaryMessage.bytes((byte[])ByteBufUtil.getBytes((ByteBuf)byteBuf));
        String logCorrelationId = UUID.randomUUID().toString();
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.RECEIVED_REQUEST).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setMessageFormat("received binary request:{}").setArguments(new Object[]{ByteBufUtil.hexDump((byte[])binaryRequest.getBytes())}));
        InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress((ChannelHandlerContext)ctx);
        if (remoteAddress != null) {
            boolean synchronous = true;
            CompletableFuture binaryResponseFuture = this.httpClient.sendRequest(binaryRequest, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()), remoteAddress, Integer.valueOf(ConfigurationProperties.socketConnectionTimeout()));
            this.scheduler.submit(binaryResponseFuture, () -> {
                try {
                    BinaryMessage binaryResponse = (BinaryMessage)binaryResponseFuture.get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.FORWARDED_REQUEST).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setMessageFormat("returning binary response:{}from:{}for forwarded binary request:{}").setArguments(new Object[]{StringFormatter.formatBytes((byte[])binaryResponse.getBytes()), remoteAddress, StringFormatter.formatBytes((byte[])binaryRequest.getBytes())}));
                    ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])binaryResponse.getBytes()));
                }
                catch (Throwable throwable) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setCorrelationId(logCorrelationId).setMessageFormat("exception " + throwable.getMessage() + " sending hex{}to{}closing connection").setArguments(new Object[]{ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()), remoteAddress}).setThrowable(throwable));
                    ctx.close();
                }
            }, synchronous);
        } else {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setMessageFormat("unknown message format{}").setArguments(new Object[]{ByteBufUtil.hexDump((byte[])binaryRequest.getBytes())}));
            ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])"unknown message format".getBytes(StandardCharsets.UTF_8)));
            ctx.close();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException((Throwable)cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception caught by " + ((Object)((Object)this)).getClass() + " handler -> closing pipeline " + ctx.channel()).setThrowable(cause));
        }
        ExceptionHandling.closeOnFlush((Channel)ctx.channel());
    }
}

