/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidatorState;
import java.util.Iterator;

public class JsonNodeUtil {
    private static final String TYPE = "type";
    private static final String ENUM = "enum";
    private static final String REF = "$ref";
    private static final String NULLABLE = "nullable";
    private static final char CHAR_0 = '0';
    private static final char CHAR_1 = '1';
    private static final char CHAR_9 = '9';
    private static final char MINUS = '-';
    private static final char PLUS = '+';
    private static final char DOT = '.';
    private static final char CHAR_E = 'E';
    private static final char CHAR_e = 'e';

    public static boolean isNodeNullable(JsonNode schema) {
        JsonNode nullable = schema.get(NULLABLE);
        return nullable != null && nullable.asBoolean();
    }

    public static boolean isNodeNullable(JsonNode schema, SchemaValidatorsConfig config) {
        if (config.isHandleNullableField()) {
            return JsonNodeUtil.isNodeNullable(schema);
        }
        return false;
    }

    public static boolean isChildNodeNullable(ArrayNode oneOfSchemaNode, SchemaValidatorsConfig config) {
        Iterator<JsonNode> iterator = oneOfSchemaNode.elements();
        while (iterator.hasNext()) {
            if (!JsonNodeUtil.isNodeNullable(iterator.next(), config)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchOneOfTypeNode(JsonNode oneOfSchemaNode, JsonType nodeType) {
        Iterator<JsonNode> iterator = oneOfSchemaNode.elements();
        while (iterator.hasNext()) {
            JsonNode oneOfTypeNode = iterator.next();
            JsonNode typeTextNode = oneOfTypeNode.get(TYPE);
            if (typeTextNode == null || !typeTextNode.asText().equals(nodeType.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsToSchemaType(JsonNode node, JsonSchema schema, SchemaValidatorsConfig config) {
        JsonType schemaType = JsonNodeUtil.getSchemaJsonType(schema);
        return JsonNodeUtil.equalsToSchemaType(node, schemaType, schema.getParentSchema(), config);
    }

    public static JsonType getSchemaJsonType(JsonSchema schema) {
        JsonNode typeNode = schema.getSchemaNode().get(TYPE);
        if (typeNode != null) {
            return JsonType.valueOf(typeNode.asText().toUpperCase());
        }
        return JsonType.UNKNOWN;
    }

    public static boolean equalsToSchemaType(JsonNode node, JsonType schemaType, JsonSchema parentSchema, SchemaValidatorsConfig config) {
        JsonType nodeType = TypeFactory.getValueNodeType(node, config);
        if (nodeType != schemaType) {
            if (schemaType == JsonType.ANY) {
                return true;
            }
            if (schemaType == JsonType.NUMBER && nodeType == JsonType.INTEGER) {
                return true;
            }
            ValidatorState state = (ValidatorState)CollectorContext.getInstance().get("com.networknt.schema.ValidatorState");
            if (JsonType.NULL.equals((Object)nodeType) && (state.isComplexValidator() && JsonNodeUtil.isNodeNullable(parentSchema.getParentSchema().getSchemaNode(), config) || JsonNodeUtil.isNodeNullable(parentSchema.getSchemaNode()))) {
                return true;
            }
            if (JsonNodeUtil.isEnumObjectSchema(parentSchema)) {
                return true;
            }
            if (config != null && config.isTypeLoose()) {
                if (schemaType == JsonType.ARRAY) {
                    return true;
                }
                if (nodeType == JsonType.STRING && (schemaType == JsonType.INTEGER ? JsonNodeUtil.isInteger(node.textValue()) : (schemaType == JsonType.BOOLEAN ? JsonNodeUtil.isBoolean(node.textValue()) : schemaType == JsonType.NUMBER && JsonNodeUtil.isNumeric(node.textValue())))) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean isInteger(String str) {
        if (str == null || str.equals("")) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-' || str.charAt(0) == '+') {
            if (str.length() == 1) {
                return false;
            }
            i = 1;
        }
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isBoolean(String s2) {
        return "true".equals(s2) || "false".equals(s2);
    }

    public static boolean isNumeric(String str) {
        char c;
        if (str == null || str.equals("")) {
            return false;
        }
        int i = 0;
        int len = str.length();
        if (str.charAt(i) == '-' || str.charAt(i) == '+') {
            if (str.length() == 1) {
                return false;
            }
            i = 1;
        }
        if ((c = str.charAt(i++)) == '0') {
            if (i < len && (c = str.charAt(i++)) != '.' && c != 'E' && c != 'e') {
                return false;
            }
        } else if ('1' <= c && c <= '9') {
            while (i < len && '0' <= c && c <= '9') {
                c = str.charAt(i++);
            }
        } else {
            return false;
        }
        if (c == '.') {
            if (i >= len) {
                return false;
            }
            c = str.charAt(i++);
            while (i < len && '0' <= c && c <= '9') {
                c = str.charAt(i++);
            }
        }
        if (c == 'E' || c == 'e') {
            if (i >= len) {
                return false;
            }
            if ((c = str.charAt(i++)) == '+' || c == '-') {
                if (i >= len) {
                    return false;
                }
                c = str.charAt(i++);
            }
            while (i < len && '0' <= c && c <= '9') {
                c = str.charAt(i++);
            }
        }
        return i >= len && '0' <= c && c <= '9';
    }

    public static boolean isNumber(JsonNode node, SchemaValidatorsConfig config) {
        if (node.isNumber()) {
            return true;
        }
        if (config.isTypeLoose() && TypeFactory.getValueNodeType(node, config) == JsonType.STRING) {
            return JsonNodeUtil.isNumeric(node.textValue());
        }
        return false;
    }

    private static boolean isEnumObjectSchema(JsonSchema jsonSchema) {
        JsonNode typeNode = null;
        JsonNode enumNode = null;
        JsonNode refNode = null;
        if (jsonSchema != null) {
            if (jsonSchema.getSchemaNode() != null) {
                typeNode = jsonSchema.getSchemaNode().get(TYPE);
                enumNode = jsonSchema.getSchemaNode().get(ENUM);
            }
            if (jsonSchema.getParentSchema() != null && jsonSchema.getParentSchema().getSchemaNode() != null) {
                refNode = jsonSchema.getParentSchema().getSchemaNode().get(REF);
            }
        }
        if (typeNode != null && enumNode != null && refNode != null) {
            return TypeFactory.getSchemaNodeType(typeNode) == JsonType.OBJECT && enumNode.isArray();
        }
        return false;
    }
}

