/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.integration;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.mockserver.client.MockServerClient;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.lifecycle.ExpectationsListener;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.netty.MockServer;
import org.slf4j.event.Level;

public class ClientAndServer
extends MockServerClient {
    private final MockServer mockServer;

    public static void main(String[] args) {
        ConfigurationProperties.logLevel("DEBUG");
        ClientAndServer clientAndServer = ClientAndServer.startClientAndServer(1080);
        clientAndServer.when(HttpRequest.request()).respond(HttpResponse.response());
        clientAndServer.stop();
    }

    public ClientAndServer(Integer ... ports) {
        super(new CompletableFuture<Integer>());
        this.mockServer = new MockServer(ports);
        this.completePortFutureAndOpenUI();
    }

    public ClientAndServer(String remoteHost, Integer remotePort, Integer ... ports) {
        super(new CompletableFuture<Integer>());
        this.mockServer = new MockServer(remotePort, remoteHost, ports);
        this.completePortFutureAndOpenUI();
    }

    private void completePortFutureAndOpenUI() {
        if (MockServerLogger.isEnabled(Level.DEBUG) && ConfigurationProperties.launchUIForLogLevelDebug()) {
            this.portFuture.whenComplete((integer, throwable) -> this.openUI());
        }
        this.portFuture.complete(this.mockServer.getLocalPort());
    }

    public static ClientAndServer startClientAndServer(List<Integer> ports) {
        return ClientAndServer.startClientAndServer(ports.toArray(new Integer[0]));
    }

    public static ClientAndServer startClientAndServer(Integer ... port) {
        return new ClientAndServer(port);
    }

    public static ClientAndServer startClientAndServer(String remoteHost, Integer remotePort, Integer ... port) {
        return new ClientAndServer(remoteHost, remotePort, port);
    }

    @Override
    public ClientAndServer openUI() {
        super.openUI();
        return this;
    }

    @Override
    public ClientAndServer openUI(TimeUnit timeUnit, long pause) {
        super.openUI(timeUnit, pause);
        return this;
    }

    @Override
    public boolean isRunning() {
        return this.mockServer.isRunning();
    }

    @Override
    public boolean hasStarted() {
        return this.mockServer.isRunning();
    }

    public CompletableFuture stopAsync() {
        return this.mockServer.stopAsync().thenComposeAsync(s2 -> this.stop(true));
    }

    @Override
    public void stop() {
        this.mockServer.stop();
        super.stop();
    }

    @Override
    public Integer getPort() {
        return this.mockServer.getLocalPort();
    }

    public Integer getLocalPort() {
        return this.mockServer.getLocalPort();
    }

    public List<Integer> getLocalPorts() {
        return this.mockServer.getLocalPorts();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.mockServer.getRemoteAddress();
    }

    public ClientAndServer registerListener(ExpectationsListener expectationsListener) {
        this.mockServer.registerListener(expectationsListener);
        return this;
    }
}

