/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.model.ParameterStyle;
import org.mockserver.validator.jsonschema.JsonSchemaValidator;

public class JsonSchemaMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger", "jsonSchemaValidator"};
    private final MockServerLogger mockServerLogger;
    private String matcher;
    private JsonSchemaValidator jsonSchemaValidator;
    private Map<String, ParameterStyle> parameterStyle;

    JsonSchemaMatcher(MockServerLogger mockServerLogger, String matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
        this.jsonSchemaValidator = new JsonSchemaValidator(mockServerLogger, matcher);
    }

    public Map<String, ParameterStyle> getParameterStyle() {
        return this.parameterStyle;
    }

    public JsonSchemaMatcher withParameterStyle(Map<String, ParameterStyle> parameterStyle) {
        this.parameterStyle = parameterStyle;
        return this;
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean result;
        block6: {
            result = false;
            if (this.matcher.equalsIgnoreCase(matched)) {
                result = true;
            } else if (!StringUtils.isBlank(matched)) {
                try {
                    String validation = this.jsonSchemaValidator.isValid(matched, false);
                    result = validation.isEmpty();
                    if (!result && context != null) {
                        context.addDifference(this.mockServerLogger, "json schema match failed expected:{}found:{}failed because:{}", this.matcher, matched, validation);
                    }
                }
                catch (Throwable throwable) {
                    if (context == null) break block6;
                    context.addDifference(this.mockServerLogger, throwable, "json schema match failed expected:{}found:{}failed because:{}", this.matcher, matched, throwable.getMessage());
                }
            }
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return StringUtils.isBlank(this.matcher);
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

