/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action.http;

import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.BooleanUtils;
import org.mockserver.closurecallback.websocketregistry.LocalCallbackRegistry;
import org.mockserver.closurecallback.websocketregistry.WebSocketClientRegistry;
import org.mockserver.closurecallback.websocketregistry.WebSocketRequestCallback;
import org.mockserver.httpclient.NettyHttpClient;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpState;
import org.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import org.mockserver.mock.action.ExpectationForwardCallback;
import org.mockserver.mock.action.http.HttpActionHandler;
import org.mockserver.mock.action.http.HttpForwardAction;
import org.mockserver.mock.action.http.HttpForwardActionResult;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpRequestAndHttpResponse;
import org.mockserver.model.HttpResponse;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.uuid.UUIDService;
import org.slf4j.event.Level;

public class HttpForwardObjectCallbackActionHandler
extends HttpForwardAction {
    private WebSocketClientRegistry webSocketClientRegistry;

    public HttpForwardObjectCallbackActionHandler(HttpState httpStateHandler, NettyHttpClient httpClient) {
        super(httpStateHandler.getMockServerLogger(), httpClient);
        this.webSocketClientRegistry = httpStateHandler.getWebSocketClientRegistry();
    }

    public void handle(HttpActionHandler actionHandler, HttpObjectCallback httpObjectCallback, HttpRequest request, ResponseWriter responseWriter, boolean synchronous, Runnable expectationPostProcessor) {
        String clientId = httpObjectCallback.getClientId();
        if (LocalCallbackRegistry.forwardClientExists(clientId)) {
            this.handleLocally(actionHandler, httpObjectCallback, request, responseWriter, synchronous, clientId);
        } else {
            this.handleViaWebSocket(actionHandler, httpObjectCallback, request, responseWriter, synchronous, expectationPostProcessor, clientId);
        }
    }

    private void handleLocally(HttpActionHandler actionHandler, HttpObjectCallback httpObjectCallback, HttpRequest request, ResponseWriter responseWriter, boolean synchronous, String clientId) {
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("locally sending request{}to client " + clientId).setArguments(request));
        }
        ExpectationForwardCallback expectationForwardCallback = LocalCallbackRegistry.retrieveForwardCallback(clientId);
        try {
            HttpRequest callbackRequest = expectationForwardCallback.handle(request);
            HttpForwardActionResult responseFuture = this.sendRequest(callbackRequest, null, null);
            ExpectationForwardAndResponseCallback expectationForwardAndResponseCallback = LocalCallbackRegistry.retrieveForwardAndResponseCallback(clientId);
            if (expectationForwardAndResponseCallback != null) {
                actionHandler.executeAfterForwardActionResponse(responseFuture, (httpResponse, exception) -> {
                    if (httpResponse != null) {
                        try {
                            HttpResponse callbackResponse = expectationForwardAndResponseCallback.handle(request, (HttpResponse)httpResponse);
                            actionHandler.writeForwardActionResponse(callbackResponse, responseWriter, request, httpObjectCallback);
                        }
                        catch (Throwable throwable) {
                            if (MockServerLogger.isEnabled(Level.WARN)) {
                                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setHttpRequest(request).setMessageFormat("returning{}because client " + clientId + " response callback threw an exception").setArguments(HttpResponse.notFoundResponse()).setThrowable(throwable));
                            }
                            actionHandler.writeForwardActionResponse(this.notFoundFuture(request), responseWriter, request, httpObjectCallback, synchronous);
                        }
                    } else if (exception != null) {
                        actionHandler.handleExceptionDuringForwardingRequest(httpObjectCallback, request, responseWriter, (Throwable)exception);
                    }
                }, synchronous);
            } else {
                actionHandler.writeForwardActionResponse(responseFuture, responseWriter, request, httpObjectCallback, synchronous);
            }
        }
        catch (Throwable throwable) {
            if (MockServerLogger.isEnabled(Level.WARN)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setHttpRequest(request).setMessageFormat("returning{}because client " + clientId + " request callback throw an exception").setArguments(HttpResponse.notFoundResponse()).setThrowable(throwable));
            }
            actionHandler.writeForwardActionResponse(this.notFoundFuture(request), responseWriter, request, httpObjectCallback, synchronous);
        }
    }

    private void handleViaWebSocket(final HttpActionHandler actionHandler, final HttpObjectCallback httpObjectCallback, final HttpRequest request, final ResponseWriter responseWriter, final boolean synchronous, final Runnable expectationPostProcessor, final String clientId) {
        final String webSocketCorrelationId = UUIDService.getUUID();
        this.webSocketClientRegistry.registerForwardCallbackHandler(webSocketCorrelationId, new WebSocketRequestCallback(){

            @Override
            public void handle(HttpRequest request2) {
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    HttpForwardObjectCallbackActionHandler.this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request2).setMessageFormat("received request over websocket{}from client " + clientId + " for correlationId " + webSocketCorrelationId).setArguments(request2));
                }
                HttpForwardActionResult responseFuture = HttpForwardObjectCallbackActionHandler.this.sendRequest(request2.removeHeader("WebSocketCorrelationId"), null, null);
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    HttpForwardObjectCallbackActionHandler.this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request2).setMessageFormat("received response for request{}from client " + clientId).setArguments(request2));
                }
                HttpForwardObjectCallbackActionHandler.this.webSocketClientRegistry.unregisterForwardCallbackHandler(webSocketCorrelationId);
                if (expectationPostProcessor != null && BooleanUtils.isFalse(httpObjectCallback.getResponseCallback())) {
                    expectationPostProcessor.run();
                }
                if (BooleanUtils.isTrue(httpObjectCallback.getResponseCallback())) {
                    HttpForwardObjectCallbackActionHandler.this.handleResponseViaWebSocket(request2, responseFuture, actionHandler, webSocketCorrelationId, clientId, expectationPostProcessor, responseWriter, httpObjectCallback, synchronous);
                } else {
                    actionHandler.writeForwardActionResponse(responseFuture, responseWriter, request2, httpObjectCallback, synchronous);
                }
            }

            @Override
            public void handleError(HttpResponse httpResponse) {
                if (MockServerLogger.isEnabled(Level.DEBUG)) {
                    HttpForwardObjectCallbackActionHandler.this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setHttpRequest(request).setMessageFormat("error sending request over websocket for client " + clientId + " for correlationId " + webSocketCorrelationId));
                }
                HttpForwardObjectCallbackActionHandler.this.webSocketClientRegistry.unregisterForwardCallbackHandler(webSocketCorrelationId);
                actionHandler.writeResponseActionResponse(httpResponse, responseWriter, request, httpObjectCallback, synchronous);
            }
        });
        if (!this.webSocketClientRegistry.sendClientMessage(clientId, request.clone().withHeader("WebSocketCorrelationId", webSocketCorrelationId), null)) {
            if (MockServerLogger.isEnabled(Level.WARN)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setHttpRequest(request).setMessageFormat("returning{}because client " + clientId + " has closed web socket connection").setArguments(HttpResponse.notFoundResponse()));
            }
            actionHandler.writeForwardActionResponse(this.notFoundFuture(request), responseWriter, request, httpObjectCallback, synchronous);
        } else if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("sending request over websocket{}to client " + clientId + " for correlationId " + webSocketCorrelationId).setArguments(request));
        }
    }

    private void handleResponseViaWebSocket(HttpRequest request, HttpForwardActionResult responseFuture, HttpActionHandler actionHandler, String webSocketCorrelationId, String clientId, Runnable expectationPostProcessor, ResponseWriter responseWriter, HttpObjectCallback httpObjectCallback, boolean synchronous) {
        actionHandler.executeAfterForwardActionResponse(responseFuture, (httpResponse, exception) -> {
            if (httpResponse != null) {
                CompletableFuture<HttpResponse> httpResponseCompletableFuture = new CompletableFuture<HttpResponse>();
                this.webSocketClientRegistry.registerResponseCallbackHandler(webSocketCorrelationId, overriddenResponse -> {
                    if (MockServerLogger.isEnabled(Level.TRACE)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("received response over websocket{}for request and response{}from client " + clientId + " for correlationId " + webSocketCorrelationId).setArguments(overriddenResponse, new HttpRequestAndHttpResponse().withHttpRequest(request).withHttpResponse((HttpResponse)httpResponse)));
                    }
                    this.webSocketClientRegistry.unregisterResponseCallbackHandler(webSocketCorrelationId);
                    if (expectationPostProcessor != null) {
                        expectationPostProcessor.run();
                    }
                    httpResponseCompletableFuture.complete(overriddenResponse.removeHeader("WebSocketCorrelationId"));
                });
                if (!this.webSocketClientRegistry.sendClientMessage(clientId, request.clone().withHeader("WebSocketCorrelationId", webSocketCorrelationId), (HttpResponse)httpResponse)) {
                    if (MockServerLogger.isEnabled(Level.WARN)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setHttpRequest(request).setMessageFormat("returning{}because client " + clientId + " has closed web socket connection").setArguments(HttpResponse.notFoundResponse()));
                    }
                    actionHandler.writeForwardActionResponse(this.notFoundFuture(request), responseWriter, request, httpObjectCallback, synchronous);
                } else if (MockServerLogger.isEnabled(Level.TRACE)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("sending response over websocket{}to client " + clientId + " for correlationId " + webSocketCorrelationId).setArguments(httpResponse));
                }
                actionHandler.writeForwardActionResponse(responseFuture.setHttpResponse(httpResponseCompletableFuture), responseWriter, request, httpObjectCallback, synchronous);
            } else if (exception != null) {
                actionHandler.handleExceptionDuringForwardingRequest(httpObjectCallback, request, responseWriter, (Throwable)exception);
            }
        }, synchronous);
    }
}

