/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.mockserver.model.KeyMatchStyle;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.NottableString;
import org.mockserver.model.ObjectWithJsonToString;

public abstract class KeysToMultiValues<T extends KeyToMultiValue, K extends KeysToMultiValues>
extends ObjectWithJsonToString {
    private KeyMatchStyle keyMatchStyle = KeyMatchStyle.SUB_SET;
    private final Multimap<NottableString, NottableString> multimap;
    private final K k = this;

    protected KeysToMultiValues() {
        this.multimap = LinkedHashMultimap.create();
    }

    protected KeysToMultiValues(Multimap<NottableString, NottableString> multimap) {
        this.multimap = LinkedHashMultimap.create(multimap);
    }

    public abstract T build(NottableString var1, Collection<NottableString> var2);

    public KeyMatchStyle getKeyMatchStyle() {
        return this.keyMatchStyle;
    }

    public KeysToMultiValues<T, K> withKeyMatchStyle(KeyMatchStyle keyMatchStyle) {
        this.keyMatchStyle = keyMatchStyle;
        return this;
    }

    public K withEntries(Map<String, List<String>> entries) {
        this.multimap.clear();
        for (String name : entries.keySet()) {
            for (String value : entries.get(name)) {
                this.withEntry(name, value);
            }
        }
        return this.k;
    }

    public K withEntries(List<T> entries) {
        this.multimap.clear();
        if (entries != null) {
            for (KeyToMultiValue entry : entries) {
                this.withEntry(entry);
            }
        }
        return this.k;
    }

    @SafeVarargs
    public final K withEntries(T ... entries) {
        if (ArrayUtils.isNotEmpty(entries)) {
            this.withEntries(Arrays.asList(entries));
        }
        return this.k;
    }

    public K withEntry(T entry) {
        if (entry != null) {
            if (((KeyToMultiValue)entry).getValues().isEmpty()) {
                this.multimap.put(((KeyToMultiValue)entry).getName(), null);
            } else {
                this.multimap.putAll(((KeyToMultiValue)entry).getName(), ((KeyToMultiValue)entry).getValues());
            }
        }
        return this.k;
    }

    public K withEntry(String name, String ... values) {
        if (values == null || values.length == 0) {
            this.multimap.put(NottableString.string(name), NottableString.string(""));
        } else {
            this.multimap.putAll(NottableString.string(name), NottableString.deserializeNottableStrings(values));
        }
        return this.k;
    }

    public K withEntry(String name, List<String> values) {
        if (values == null || values.size() == 0) {
            this.multimap.put(NottableString.string(name), null);
        } else {
            this.multimap.putAll(NottableString.string(name), NottableString.deserializeNottableStrings(values));
        }
        return this.k;
    }

    public K withEntry(NottableString name, List<NottableString> values) {
        if (values != null) {
            this.multimap.putAll(name, values);
        }
        return this.k;
    }

    public K withEntry(NottableString name, NottableString ... values) {
        if (ArrayUtils.isNotEmpty(values)) {
            this.withEntry(name, Arrays.asList(values));
        }
        return this.k;
    }

    public boolean remove(String name) {
        boolean exists = false;
        if (name != null) {
            for (NottableString key : this.multimap.keySet().toArray(new NottableString[0])) {
                if (!key.equalsIgnoreCase(name)) continue;
                this.multimap.removeAll(key);
                exists = true;
            }
        }
        return exists;
    }

    public boolean remove(NottableString name) {
        boolean exists = false;
        if (name != null) {
            for (NottableString key : this.multimap.keySet().toArray(new NottableString[0])) {
                if (!key.equalsIgnoreCase(name)) continue;
                this.multimap.removeAll(key);
                exists = true;
            }
        }
        return exists;
    }

    public K replaceEntry(T entry) {
        if (entry != null) {
            this.remove(((KeyToMultiValue)entry).getName());
            this.multimap.putAll(((KeyToMultiValue)entry).getName(), ((KeyToMultiValue)entry).getValues());
        }
        return this.k;
    }

    public K replaceEntryIfExists(T entry) {
        if (entry != null && this.remove(((KeyToMultiValue)entry).getName())) {
            this.multimap.putAll(((KeyToMultiValue)entry).getName(), ((KeyToMultiValue)entry).getValues());
        }
        return this.k;
    }

    public K replaceEntry(String name, String ... values) {
        if (ArrayUtils.isNotEmpty(values)) {
            this.remove(name);
            this.multimap.putAll(NottableString.string(name), NottableString.deserializeNottableStrings(values));
        }
        return this.k;
    }

    public List<T> getEntries() {
        if (!this.isEmpty()) {
            ArrayList<T> headers = new ArrayList<T>();
            for (NottableString nottableString : this.multimap.keySet().toArray(new NottableString[0])) {
                headers.add(this.build(nottableString, this.multimap.get(nottableString)));
            }
            return headers;
        }
        return Collections.emptyList();
    }

    public Set<NottableString> keySet() {
        return this.multimap.keySet();
    }

    public Collection<NottableString> getValues(NottableString key) {
        return this.multimap.get(key);
    }

    public Multimap<NottableString, NottableString> getMultimap() {
        return this.multimap;
    }

    public List<String> getValues(String name) {
        if (!this.isEmpty() && name != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (NottableString key : this.multimap.keySet().toArray(new NottableString[0])) {
                if (key == null || !key.equalsIgnoreCase(name)) continue;
                values.addAll(NottableString.serialiseNottableStrings(this.multimap.get(key)));
            }
            return values;
        }
        return Collections.emptyList();
    }

    String getFirstValue(String name) {
        if (!this.isEmpty()) {
            for (NottableString key : this.multimap.keySet().toArray(new NottableString[0])) {
                NottableString next;
                Collection<NottableString> nottableStrings;
                if (key == null || !key.equalsIgnoreCase(name) || (nottableStrings = this.multimap.get(key)).isEmpty() || (next = nottableStrings.iterator().next()) == null) continue;
                return next.getValue();
            }
        }
        return "";
    }

    public boolean containsEntry(String name) {
        if (!this.isEmpty()) {
            for (NottableString key : this.multimap.keySet().toArray(new NottableString[0])) {
                if (key == null || !key.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsEntry(String name, String value) {
        return this.containsEntry(NottableString.string(name), NottableString.string(value));
    }

    boolean containsEntry(NottableString name, NottableString value) {
        if (!this.isEmpty() && name != null && value != null) {
            for (NottableString entryKey : this.multimap.keySet().toArray(new NottableString[0])) {
                Collection<NottableString> nottableStrings;
                if (entryKey == null || !entryKey.equalsIgnoreCase(name) || (nottableStrings = this.multimap.get(entryKey)) == null) continue;
                for (NottableString entryValue : nottableStrings.toArray(new NottableString[0])) {
                    if (!value.equalsIgnoreCase(entryValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.multimap.isEmpty();
    }

    public abstract K clone();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeysToMultiValues)) {
            return false;
        }
        KeysToMultiValues that = (KeysToMultiValues)o;
        return Objects.equals(this.multimap, that.multimap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.multimap);
    }
}

