/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.RequestDefinition;

public class OpenAPIDefinition
extends RequestDefinition {
    private int hashCode;
    private String specUrlOrPayload;
    private String operationId;

    public static OpenAPIDefinition openAPI() {
        return new OpenAPIDefinition();
    }

    public static OpenAPIDefinition openAPI(String specUrlOrPayload) {
        return new OpenAPIDefinition().withSpecUrlOrPayload(specUrlOrPayload);
    }

    public static OpenAPIDefinition openAPI(String specUrlOrPayload, String operationId) {
        return new OpenAPIDefinition().withSpecUrlOrPayload(specUrlOrPayload).withOperationId(operationId);
    }

    public String getSpecUrlOrPayload() {
        return this.specUrlOrPayload;
    }

    public OpenAPIDefinition withSpecUrlOrPayload(String specUrlOrPayload) {
        this.specUrlOrPayload = specUrlOrPayload;
        return this;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public OpenAPIDefinition withOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    @Override
    public OpenAPIDefinition shallowClone() {
        return OpenAPIDefinition.not(OpenAPIDefinition.openAPI(), this.not).withSpecUrlOrPayload(this.specUrlOrPayload).withOperationId(this.operationId);
    }

    public OpenAPIDefinition update(OpenAPIDefinition replaceRequest) {
        if (replaceRequest.getSpecUrlOrPayload() != null && StringUtils.isNotBlank(replaceRequest.getSpecUrlOrPayload())) {
            this.withSpecUrlOrPayload(replaceRequest.getSpecUrlOrPayload());
        }
        if (replaceRequest.getOperationId() != null && StringUtils.isNotBlank(replaceRequest.getOperationId())) {
            this.withOperationId(replaceRequest.getOperationId());
        }
        this.hashCode = 0;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenAPIDefinition that = (OpenAPIDefinition)o;
        return Objects.equals(this.specUrlOrPayload, that.specUrlOrPayload) && Objects.equals(this.operationId, that.operationId);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.specUrlOrPayload, this.operationId);
        }
        return this.hashCode;
    }
}

