/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.httpclient.NettyHttpClient;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.http.HttpActionHandler;
import org.mockserver.model.BinaryMessage;
import org.mockserver.netty.unification.PortUnificationHandler;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.uuid.UUIDService;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class BinaryHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private MockServerLogger mockServerLogger;
    private final Scheduler scheduler;
    private final NettyHttpClient httpClient;

    public BinaryHandler(MockServerLogger mockServerLogger, Scheduler scheduler, NettyHttpClient httpClient) {
        super(true);
        this.mockServerLogger = mockServerLogger;
        this.scheduler = scheduler;
        this.httpClient = httpClient;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf byteBuf) {
        BinaryMessage binaryRequest = BinaryMessage.bytes(ByteBufUtil.getBytes(byteBuf));
        String logCorrelationId = UUIDService.getUUID();
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.RECEIVED_REQUEST).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setMessageFormat("received binary request:{}").setArguments(ByteBufUtil.hexDump(binaryRequest.getBytes())));
        InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress(ctx);
        if (remoteAddress != null) {
            boolean synchronous = true;
            CompletableFuture<BinaryMessage> binaryResponseFuture = this.httpClient.sendRequest(binaryRequest, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()), remoteAddress, ConfigurationProperties.socketConnectionTimeout());
            this.scheduler.submit(binaryResponseFuture, () -> {
                try {
                    BinaryMessage binaryResponse = (BinaryMessage)binaryResponseFuture.get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.FORWARDED_REQUEST).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setMessageFormat("returning binary response:{}from:{}for forwarded binary request:{}").setArguments(StringFormatter.formatBytes(binaryResponse.getBytes()), remoteAddress, StringFormatter.formatBytes(binaryRequest.getBytes())));
                    ctx.writeAndFlush(Unpooled.copiedBuffer(binaryResponse.getBytes()));
                }
                catch (Throwable throwable) {
                    if (MockServerLogger.isEnabled(Level.WARN)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setCorrelationId(logCorrelationId).setMessageFormat("exception " + throwable.getMessage() + " sending hex{}to{}closing connection").setArguments(ByteBufUtil.hexDump(binaryRequest.getBytes()), remoteAddress).setThrowable(throwable));
                    }
                    ctx.close();
                }
            }, synchronous);
        } else {
            if (MockServerLogger.isEnabled(Level.INFO)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setMessageFormat("unknown message format{}").setArguments(ByteBufUtil.hexDump(binaryRequest.getBytes())));
            }
            ctx.writeAndFlush(Unpooled.copiedBuffer("unknown message format".getBytes(StandardCharsets.UTF_8)));
            ctx.close();
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception caught by " + this.getClass() + " handler -> closing pipeline " + ctx.channel()).setThrowable(cause));
        }
        ExceptionHandling.closeOnFlush(ctx.channel());
    }
}

