/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.proxy.socks;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.netty.HttpRequestHandler;
import org.mockserver.netty.unification.PortUnificationHandler;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public abstract class SocksProxyHandler<T>
extends SimpleChannelInboundHandler<T> {
    protected final LifeCycle server;
    protected final MockServerLogger mockServerLogger;

    public SocksProxyHandler(LifeCycle server, MockServerLogger mockServerLogger) {
        super(false);
        this.server = server;
        this.mockServerLogger = mockServerLogger;
    }

    protected void forwardConnection(ChannelHandlerContext ctx, ChannelHandler forwarder, String addr, int port) {
        Channel channel = ctx.channel();
        channel.attr(HttpRequestHandler.PROXYING).set(Boolean.TRUE);
        if (String.valueOf(port).endsWith("80")) {
            PortUnificationHandler.disableSslDownstream(channel);
        } else if (String.valueOf(port).endsWith("443")) {
            PortUnificationHandler.enableSslDownstream(channel);
        }
        if (StringUtils.isNotBlank(addr)) {
            this.server.getScheduler().submit(() -> ConfigurationProperties.addSubjectAlternativeName(addr));
        }
        ctx.pipeline().replace(this, null, forwarder);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception caught by SOCKS proxy handler -> closing pipeline " + ctx.channel()).setThrowable(cause));
        }
        ctx.close();
    }
}

