/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.responsewriter;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.cors.CORSHeaders;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.Delay;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.scheduler.Scheduler;
import org.slf4j.event.Level;

public class NettyResponseWriter
extends ResponseWriter {
    private final MockServerLogger mockServerLogger;
    private final ChannelHandlerContext ctx;
    private final Scheduler scheduler;
    private static final CORSHeaders CORS_HEADERS = new CORSHeaders();

    public NettyResponseWriter(MockServerLogger mockServerLogger, ChannelHandlerContext ctx, Scheduler scheduler) {
        this.mockServerLogger = mockServerLogger;
        this.ctx = ctx;
        this.scheduler = scheduler;
    }

    @Override
    public void sendResponse(HttpRequest request, HttpResponse response) {
        this.writeAndCloseSocket(this.ctx, request, response);
    }

    private void writeAndCloseSocket(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        boolean closeChannel = connectionOptions != null && connectionOptions.getCloseSocket() != null ? connectionOptions.getCloseSocket() : request.isKeepAlive() == null || request.isKeepAlive() == false;
        ChannelFuture channelFuture = ctx.writeAndFlush(response);
        if (closeChannel || ConfigurationProperties.alwaysCloseSocketConnections()) {
            channelFuture.addListener(future -> {
                Delay closeSocketDelay;
                Delay delay = closeSocketDelay = connectionOptions != null ? connectionOptions.getCloseSocketDelay() : null;
                if (closeSocketDelay == null) {
                    this.disconnectAndCloseChannel((ChannelFuture)future);
                } else {
                    this.scheduler.schedule(() -> this.disconnectAndCloseChannel((ChannelFuture)future), false, closeSocketDelay);
                }
            });
        }
    }

    private void disconnectAndCloseChannel(ChannelFuture future) {
        future.channel().disconnect().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)disconnectFuture -> {
            if (disconnectFuture.isSuccess()) {
                future.channel().close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)closeFuture -> {
                    if (disconnectFuture.isSuccess()) {
                        if (MockServerLogger.isEnabled(Level.TRACE)) {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("disconnected and closed socket " + future.channel().localAddress()));
                        }
                    } else if (MockServerLogger.isEnabled(Level.WARN)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("exception closing socket " + future.channel().localAddress()).setThrowable(disconnectFuture.cause()));
                    }
                }));
            } else if (MockServerLogger.isEnabled(Level.WARN)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("exception disconnecting socket " + future.channel().localAddress()).setThrowable(disconnectFuture.cause()));
            }
        }));
    }
}

