/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.unification;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.socksx.v4.Socks4ServerDecoder;
import io.netty.handler.codec.socksx.v4.Socks4ServerEncoder;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5ServerEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.codec.MockServerHttpServerCodec;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.dashboard.DashboardWebSocketHandler;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mappers.MockServerHttpResponseToFullHttpResponse;
import org.mockserver.mock.HttpState;
import org.mockserver.mock.action.http.HttpActionHandler;
import org.mockserver.model.HttpResponse;
import org.mockserver.netty.HttpRequestHandler;
import org.mockserver.netty.proxy.BinaryHandler;
import org.mockserver.netty.proxy.socks.Socks4ProxyHandler;
import org.mockserver.netty.proxy.socks.Socks5ProxyHandler;
import org.mockserver.netty.proxy.socks.SocksDetector;
import org.mockserver.netty.unification.HttpContentLengthRemover;
import org.mockserver.netty.unification.PortBinding;
import org.mockserver.netty.websocketregistry.CallbackWebSocketServerHandler;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.mockserver.socket.tls.SniHandler;
import org.slf4j.event.Level;

public class PortUnificationHandler
extends ReplayingDecoder<Void> {
    private static final AttributeKey<Boolean> SSL_ENABLED_UPSTREAM = AttributeKey.valueOf("PROXY_SSL_ENABLED_UPSTREAM");
    private static final AttributeKey<Boolean> SSL_ENABLED_DOWNSTREAM = AttributeKey.valueOf("SSL_ENABLED_DOWNSTREAM");
    private static final AttributeKey<NettySslContextFactory> NETTY_SSL_CONTEXT_FACTORY = AttributeKey.valueOf("NETTY_SSL_CONTEXT_FACTORY");
    private static final Map<PortBinding, Set<String>> localAddressesCache = new ConcurrentHashMap<PortBinding, Set<String>>();
    protected final MockServerLogger mockServerLogger;
    private final LoggingHandler loggingHandlerFirst = new LoggingHandler(PortUnificationHandler.class.getSimpleName() + "-first");
    private final LoggingHandler loggingHandlerLast = new LoggingHandler(PortUnificationHandler.class.getSimpleName() + "-last");
    private final HttpContentLengthRemover httpContentLengthRemover = new HttpContentLengthRemover();
    private final LifeCycle server;
    private final HttpState httpStateHandler;
    private final HttpActionHandler actionHandler;
    private final NettySslContextFactory nettySslContextFactory;
    private final MockServerHttpResponseToFullHttpResponse mockServerHttpResponseToFullHttpResponse;

    public PortUnificationHandler(LifeCycle server, HttpState httpStateHandler, HttpActionHandler actionHandler, NettySslContextFactory nettySslContextFactory) {
        this.server = server;
        this.mockServerLogger = httpStateHandler.getMockServerLogger();
        this.httpStateHandler = httpStateHandler;
        this.actionHandler = actionHandler;
        this.nettySslContextFactory = nettySslContextFactory;
        this.mockServerHttpResponseToFullHttpResponse = new MockServerHttpResponseToFullHttpResponse(this.mockServerLogger);
    }

    public static NettySslContextFactory nettySslContextFactory(Channel channel) {
        if (channel.attr(NETTY_SSL_CONTEXT_FACTORY).get() != null) {
            return channel.attr(NETTY_SSL_CONTEXT_FACTORY).get();
        }
        throw new RuntimeException("NettySslContextFactory not yet initialised for channel " + channel);
    }

    public static void enableSslUpstreamAndDownstream(Channel channel) {
        channel.attr(SSL_ENABLED_UPSTREAM).set(Boolean.TRUE);
        channel.attr(SSL_ENABLED_DOWNSTREAM).set(Boolean.TRUE);
    }

    public static boolean isSslEnabledUpstream(Channel channel) {
        if (channel.attr(SSL_ENABLED_UPSTREAM).get() != null) {
            return channel.attr(SSL_ENABLED_UPSTREAM).get();
        }
        return false;
    }

    public static void enableSslDownstream(Channel channel) {
        channel.attr(SSL_ENABLED_DOWNSTREAM).set(Boolean.TRUE);
    }

    public static void disableSslDownstream(Channel channel) {
        channel.attr(SSL_ENABLED_DOWNSTREAM).set(Boolean.FALSE);
    }

    public static boolean isSslEnabledDownstream(Channel channel) {
        if (channel.attr(SSL_ENABLED_DOWNSTREAM).get() != null) {
            return channel.attr(SSL_ENABLED_DOWNSTREAM).get();
        }
        return false;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
        ctx.channel().attr(NETTY_SSL_CONTEXT_FACTORY).set(this.nettySslContextFactory);
        if (SocksDetector.isSocks4(msg, this.actualReadableBytes())) {
            this.logStage(ctx, "adding SOCKS4 decoders");
            this.enableSocks4(ctx, msg);
        } else if (SocksDetector.isSocks5(msg, this.actualReadableBytes())) {
            this.logStage(ctx, "adding SOCKS5 decoders");
            this.enableSocks5(ctx, msg);
        } else if (this.isTls(msg)) {
            this.logStage(ctx, "adding TLS decoders");
            this.enableTls(ctx, msg);
        } else if (this.isHttp(msg)) {
            this.logStage(ctx, "adding HTTP decoders");
            this.switchToHttp(ctx, msg);
        } else if (this.isProxyConnected(msg)) {
            this.logStage(ctx, "setting proxy connected");
            this.switchToProxyConnected(ctx, msg);
        } else {
            this.logStage(ctx, "adding binary decoder");
            this.switchToBinary(ctx, msg);
        }
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.loggingHandlerFirst.addLoggingHandler(ctx);
        }
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            ctx.pipeline().addLast(this.loggingHandlerLast);
        }
    }

    private void logStage(ChannelHandlerContext ctx, String message) {
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat(message + " for channel:{}pipeline:{}").setArguments(ctx.channel().toString(), ctx.pipeline().names()));
        }
    }

    private void enableSocks4(ChannelHandlerContext ctx, ByteBuf msg) {
        this.enableSocks(ctx, msg, new Socks4ServerDecoder(), new Socks4ProxyHandler(this.server, this.mockServerLogger), Socks4ServerEncoder.INSTANCE);
    }

    private void enableSocks5(ChannelHandlerContext ctx, ByteBuf msg) {
        this.enableSocks(ctx, msg, new Socks5InitialRequestDecoder(), new Socks5ProxyHandler(this.server, this.mockServerLogger), Socks5ServerEncoder.DEFAULT);
    }

    private void enableSocks(ChannelHandlerContext ctx, ByteBuf msg, ReplayingDecoder<?> socksInitialRequestDecoder, ChannelHandler ... channelHandlers) {
        ChannelPipeline pipeline = ctx.pipeline();
        for (ChannelHandler channelHandler : channelHandlers) {
            if (PortUnificationHandler.isSslEnabledUpstream(ctx.channel())) {
                pipeline.addAfter(SslHandler.class.getName(), null, channelHandler);
                continue;
            }
            pipeline.addFirst(channelHandler);
        }
        pipeline.addFirst(socksInitialRequestDecoder);
        ctx.channel().attr(HttpRequestHandler.PROXYING).set(Boolean.TRUE);
        ctx.pipeline().fireChannelRead(msg.readBytes(this.actualReadableBytes()));
    }

    private boolean isTls(ByteBuf buf) {
        return SslHandler.isEncrypted(buf);
    }

    private void enableTls(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addFirst(new SniHandler(this.nettySslContextFactory));
        PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
        ctx.pipeline().fireChannelRead(msg.readBytes(this.actualReadableBytes()));
    }

    private boolean isHttp(ByteBuf msg) {
        String method = msg.toString(msg.readerIndex(), 8, StandardCharsets.US_ASCII);
        return method.startsWith("GET ") || method.startsWith("POST ") || method.startsWith("PUT ") || method.startsWith("HEAD ") || method.startsWith("OPTIONS ") || method.startsWith("PATCH ") || method.startsWith("DELETE ") || method.startsWith("TRACE ") || method.startsWith("CONNECT ");
    }

    private void switchToHttp(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        this.addLastIfNotPresent(pipeline, new HttpServerCodec(ConfigurationProperties.maxInitialLineLength(), ConfigurationProperties.maxHeaderSize(), ConfigurationProperties.maxChunkSize()));
        this.addLastIfNotPresent(pipeline, new HttpContentDecompressor());
        this.addLastIfNotPresent(pipeline, this.httpContentLengthRemover);
        this.addLastIfNotPresent(pipeline, new HttpObjectAggregator(Integer.MAX_VALUE));
        if (ConfigurationProperties.tlsMutualAuthenticationRequired() && !PortUnificationHandler.isSslEnabledUpstream(ctx.channel())) {
            HttpResponse httpResponse = HttpResponse.response().withStatusCode(426).withHeader("Upgrade", "TLS/1.2, HTTP/1.1").withHeader("Connection", "Upgrade");
            if (MockServerLogger.isEnabled(Level.INFO)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setMessageFormat("no tls for connection:{}returning response:{}").setArguments(ctx.channel().localAddress(), httpResponse));
            }
            ctx.channel().writeAndFlush(this.mockServerHttpResponseToFullHttpResponse.mapMockServerResponseToNettyResponse(httpResponse).get(0)).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<ChannelFuture>)future -> future.channel().disconnect().awaitUninterruptibly()));
        } else {
            this.addLastIfNotPresent(pipeline, new CallbackWebSocketServerHandler(this.httpStateHandler));
            this.addLastIfNotPresent(pipeline, new DashboardWebSocketHandler(this.httpStateHandler, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()), false));
            this.addLastIfNotPresent(pipeline, new MockServerHttpServerCodec(this.mockServerLogger, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()), ctx.channel().localAddress()));
            this.addLastIfNotPresent(pipeline, new HttpRequestHandler(this.server, this.httpStateHandler, this.actionHandler));
            pipeline.remove(this);
            ctx.channel().attr(HttpRequestHandler.LOCAL_HOST_HEADERS).set(this.getLocalAddresses(ctx));
            ctx.fireChannelRead(msg.readBytes(this.actualReadableBytes()));
        }
    }

    private boolean isProxyConnected(ByteBuf msg) {
        return msg.toString(msg.readerIndex(), 8, StandardCharsets.US_ASCII).startsWith("PROXIED_");
    }

    private void switchToProxyConnected(ChannelHandlerContext ctx, ByteBuf msg) {
        String message = this.readMessage(msg);
        if (message.startsWith("PROXIED_SECURE_")) {
            String[] hostParts = StringUtils.substringAfter(message, "PROXIED_SECURE_").split(":");
            int port = hostParts.length > 1 ? Integer.parseInt(hostParts[1]) : 443;
            ctx.channel().attr(HttpRequestHandler.PROXYING).set(Boolean.TRUE);
            ctx.channel().attr(HttpActionHandler.REMOTE_SOCKET).set(new InetSocketAddress(hostParts[0], port));
            PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
            ctx.channel().attr(HttpRequestHandler.PROXYING).set(Boolean.TRUE);
            ctx.channel().attr(HttpActionHandler.REMOTE_SOCKET).set(new InetSocketAddress(hostParts[0], port));
        } else if (message.startsWith("PROXIED_")) {
            String[] hostParts = StringUtils.substringAfter(message, "PROXIED_").split(":");
            int port = hostParts.length > 1 ? Integer.parseInt(hostParts[1]) : 80;
            ctx.channel().attr(HttpRequestHandler.PROXYING).set(Boolean.TRUE);
            ctx.channel().attr(HttpActionHandler.REMOTE_SOCKET).set(new InetSocketAddress(hostParts[0], port));
        }
        ctx.writeAndFlush(Unpooled.copiedBuffer(("PROXIED_RESPONSE_" + message).getBytes(StandardCharsets.UTF_8))).awaitUninterruptibly();
    }

    private String readMessage(ByteBuf msg) {
        byte[] bytes = new byte[this.actualReadableBytes()];
        msg.readBytes(bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    private void switchToBinary(ChannelHandlerContext ctx, ByteBuf msg) {
        this.addLastIfNotPresent(ctx.pipeline(), new BinaryHandler(this.httpStateHandler.getMockServerLogger(), this.httpStateHandler.getScheduler(), this.actionHandler.getHttpClient()));
        ctx.fireChannelRead(msg.readBytes(this.actualReadableBytes()));
    }

    private Set<String> getLocalAddresses(ChannelHandlerContext ctx) {
        String portExtension;
        InetSocketAddress inetSocketAddress;
        PortBinding cacheKey;
        SocketAddress localAddress = ctx.channel().localAddress();
        Set<String> localAddresses = null;
        if (localAddress instanceof InetSocketAddress && (localAddresses = localAddressesCache.get(cacheKey = new PortBinding(inetSocketAddress = (InetSocketAddress)localAddress, portExtension = this.calculatePortExtension(inetSocketAddress, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()))))) == null) {
            localAddresses = this.calculateLocalAddresses(inetSocketAddress, portExtension);
            localAddressesCache.put(cacheKey, localAddresses);
        }
        return localAddresses == null ? Collections.emptySet() : localAddresses;
    }

    private String calculatePortExtension(InetSocketAddress inetSocketAddress, boolean sslEnabledUpstream) {
        String portExtension = inetSocketAddress.getPort() == 443 && sslEnabledUpstream || inetSocketAddress.getPort() == 80 && !sslEnabledUpstream ? "" : ":" + inetSocketAddress.getPort();
        return portExtension;
    }

    private Set<String> calculateLocalAddresses(InetSocketAddress localAddress, String portExtension) {
        InetAddress socketAddress = localAddress.getAddress();
        HashSet<String> localAddresses = new HashSet<String>();
        localAddresses.add(socketAddress.getHostAddress() + portExtension);
        localAddresses.add(socketAddress.getCanonicalHostName() + portExtension);
        localAddresses.add(socketAddress.getHostName() + portExtension);
        localAddresses.add("localhost" + portExtension);
        localAddresses.add("127.0.0.1" + portExtension);
        return Collections.unmodifiableSet(localAddresses);
    }

    private void addLastIfNotPresent(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.get(channelHandler.getClass()) == null) {
            pipeline.addLast(channelHandler);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable throwable) {
        if (ExceptionHandling.connectionClosedException(throwable)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception caught by port unification handler -> closing pipeline " + ctx.channel()).setThrowable(throwable));
        } else if (ExceptionHandling.sslHandshakeException(throwable)) {
            if (throwable.getMessage().contains("certificate_unknown")) {
                if (MockServerLogger.isEnabled(Level.WARN)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("TLS handshake failure:" + Character.NEW_LINE + Character.NEW_LINE + " Client does not trust MockServer Certificate Authority for:{}See http://mock-server.com/mock_server/HTTPS_TLS.html to enable the client to trust MocksServer Certificate Authority." + Character.NEW_LINE).setArguments(ctx.channel()));
                }
            } else if (!throwable.getMessage().contains("close_notify during handshake")) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("TLS handshake failure while a client attempted to connect to " + ctx.channel()).setThrowable(throwable));
            }
        }
        ExceptionHandling.closeOnFlush(ctx.channel());
    }
}

