/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.openapi;

import com.google.common.base.Joiner;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.extensions.SwaggerParserExtension;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.ResolverFully;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.mockserver.cache.LRUCache;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.slf4j.event.Level;

public class OpenAPIParser {
    private static final LRUCache<String, OpenAPI> openAPILRUCache = new LRUCache(new MockServerLogger(), 250, TimeUnit.MINUTES.toMillis(30L));
    public static final String OPEN_API_LOAD_ERROR = "Unable to load API spec";

    public static OpenAPI buildOpenAPI(String specUrlOrPayload, MockServerLogger mockServerLogger) {
        OpenAPI openAPI = openAPILRUCache.get(specUrlOrPayload);
        if (openAPI == null) {
            SwaggerParseResult swaggerParseResult = null;
            List<AuthorizationValue> auths = null;
            ParseOptions parseOptions = new ParseOptions();
            parseOptions.setResolve(true);
            parseOptions.setResolveFully(true);
            parseOptions.setResolveCombinators(true);
            parseOptions.setFlatten(true);
            parseOptions.setFlattenComposedSchemas(true);
            ArrayList<String> errorMessage = new ArrayList<String>();
            try {
                if (specUrlOrPayload.endsWith(".json") || specUrlOrPayload.endsWith(".yaml")) {
                    SwaggerParserExtension extension;
                    specUrlOrPayload = specUrlOrPayload.replaceAll("\\\\", "/");
                    List<SwaggerParserExtension> parserExtensions = OpenAPIV3Parser.getExtensions();
                    Iterator<SwaggerParserExtension> iterator = parserExtensions.iterator();
                    while (iterator.hasNext() && (openAPI = (swaggerParseResult = (extension = iterator.next()).readLocation(specUrlOrPayload, auths, parseOptions)).getOpenAPI()) == null) {
                        errorMessage.addAll(swaggerParseResult.getMessages());
                    }
                } else {
                    swaggerParseResult = new OpenAPIV3Parser().readContents(specUrlOrPayload, auths, parseOptions);
                    openAPI = swaggerParseResult.getOpenAPI();
                    if (openAPI == null) {
                        errorMessage.addAll(swaggerParseResult.getMessages());
                    }
                }
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException(OPEN_API_LOAD_ERROR + (errorMessage.isEmpty() ? ", " + throwable.getMessage() : ", " + Joiner.on(", ").skipNulls().join(errorMessage)), throwable);
            }
            if (openAPI != null) {
                try {
                    new ResolverFully().resolveFully(openAPI);
                }
                catch (Throwable throwable) {
                    mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setMessageFormat("exception:{}while resolving OpenAPI:{}").setArguments(errorMessage.isEmpty() ? ", " + throwable.getMessage() : ", " + Joiner.on(", ").skipNulls().join(errorMessage), specUrlOrPayload).setThrowable(throwable));
                }
            } else {
                if (swaggerParseResult != null) {
                    String message = errorMessage.stream().filter(Objects::nonNull).collect(Collectors.joining(" and ")).trim();
                    throw new IllegalArgumentException(OPEN_API_LOAD_ERROR + (StringUtils.isNotBlank(message) ? ", " + message : ""));
                }
                throw new IllegalArgumentException(OPEN_API_LOAD_ERROR);
            }
            OpenAPIParser.addMissingOperationIds(openAPI);
            openAPILRUCache.put(specUrlOrPayload, openAPI);
        }
        return openAPI;
    }

    private static void addMissingOperationIds(OpenAPI openAPI) {
        openAPI.getPaths().forEach((path, pathItem) -> OpenAPIParser.mapOperations(pathItem).forEach(stringOperationPair -> {
            if (StringUtils.isBlank(((Operation)stringOperationPair.getRight()).getOperationId())) {
                ((Operation)stringOperationPair.getRight()).setOperationId((String)stringOperationPair.getLeft() + " " + path);
            }
        }));
    }

    public static List<Pair<String, Operation>> mapOperations(PathItem pathItem) {
        ArrayList<Pair<String, Operation>> allOperations = new ArrayList<Pair<String, Operation>>();
        if (pathItem.getGet() != null) {
            allOperations.add(new ImmutablePair<String, Operation>("GET", pathItem.getGet()));
        }
        if (pathItem.getPut() != null) {
            allOperations.add(new ImmutablePair<String, Operation>("PUT", pathItem.getPut()));
        }
        if (pathItem.getPost() != null) {
            allOperations.add(new ImmutablePair<String, Operation>("POST", pathItem.getPost()));
        }
        if (pathItem.getPatch() != null) {
            allOperations.add(new ImmutablePair<String, Operation>("PATCH", pathItem.getPatch()));
        }
        if (pathItem.getDelete() != null) {
            allOperations.add(new ImmutablePair<String, Operation>("DELETE", pathItem.getDelete()));
        }
        if (pathItem.getHead() != null) {
            allOperations.add(new ImmutablePair<String, Operation>("HEAD", pathItem.getHead()));
        }
        if (pathItem.getOptions() != null) {
            allOperations.add(new ImmutablePair<String, Operation>("OPTIONS", pathItem.getOptions()));
        }
        if (pathItem.getTrace() != null) {
            allOperations.add(new ImmutablePair<String, Operation>("TRACE", pathItem.getTrace()));
        }
        return allOperations;
    }
}

