/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.deserializers.string;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.NottableOptionalString;
import org.mockserver.model.NottableSchemaString;
import org.mockserver.model.NottableString;
import org.mockserver.model.ParameterStyle;
import org.mockserver.serialization.ObjectMapperFactory;

public class NottableStringDeserializer
extends StdDeserializer<NottableString> {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();

    public NottableStringDeserializer() {
        super(NottableString.class);
    }

    @Override
    public NottableString deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
            Boolean not = null;
            Boolean optional = null;
            String value = null;
            JsonNode schema = null;
            ParameterStyle parameterStyle = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = jsonParser.getCurrentName();
                if ("not".equals(fieldName)) {
                    jsonParser.nextToken();
                    not = jsonParser.getBooleanValue();
                    continue;
                }
                if ("optional".equals(fieldName)) {
                    jsonParser.nextToken();
                    optional = jsonParser.getBooleanValue();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    jsonParser.nextToken();
                    value = ctxt.readValue(jsonParser, String.class);
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    jsonParser.nextToken();
                    schema = ctxt.readValue(jsonParser, JsonNode.class);
                    continue;
                }
                if (!"parameterStyle".equals(fieldName)) continue;
                jsonParser.nextToken();
                parameterStyle = ctxt.readValue(jsonParser, ParameterStyle.class);
            }
            NottableString result = null;
            if (schema != null) {
                result = NottableSchemaString.schemaString(schema.toPrettyString(), not);
            } else if (Boolean.TRUE.equals(optional)) {
                result = NottableOptionalString.optional(value, not);
            } else if (StringUtils.isNotBlank(value)) {
                result = NottableString.string(value, not);
            }
            if (result != null && parameterStyle != null) {
                result.withStyle(parameterStyle);
            }
            return result;
        }
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING || jsonParser.getCurrentToken() == JsonToken.FIELD_NAME) {
            return NottableString.string(ctxt.readValue(jsonParser, String.class));
        }
        return null;
    }
}

