/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.List;
import java.util.stream.Collectors;
import org.mockserver.character.Character;
import org.mockserver.model.Cookies;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpResponseModifier;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.Base64Converter;
import org.mockserver.serialization.java.CookieToJavaSerializer;
import org.mockserver.serialization.java.HeaderToJavaSerializer;
import org.mockserver.serialization.java.MultiValueToJavaSerializer;
import org.mockserver.serialization.java.ToJavaSerializer;

public class HttpResponseModifierToJavaSerializer
implements ToJavaSerializer<HttpResponseModifier> {
    private final Base64Converter base64Converter = new Base64Converter();

    public String serialize(List<HttpResponseModifier> httpResponseModifiers) {
        StringBuilder output = new StringBuilder();
        for (HttpResponseModifier httpResponseModifier : httpResponseModifiers) {
            output.append(this.serialize(0, httpResponseModifier));
            output.append(";");
            output.append(Character.NEW_LINE);
        }
        return output.toString();
    }

    @Override
    public String serialize(int numberOfSpacesToIndent, HttpResponseModifier response) {
        StringBuffer output = new StringBuffer();
        if (response != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output);
            output.append("responseModifier()");
            if (response.getHeaders() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withHeaders(");
                this.outputHeaders(numberOfSpacesToIndent, output, (Headers)response.getHeaders().getAdd());
                this.outputHeaders(numberOfSpacesToIndent, output, (Headers)response.getHeaders().getReplace());
                this.outputList(numberOfSpacesToIndent, output, response.getHeaders().getRemove());
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(")");
            }
            if (response.getCookies() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withCookies(");
                this.outputCookies(numberOfSpacesToIndent, output, (Cookies)response.getCookies().getAdd());
                this.outputCookies(numberOfSpacesToIndent, output, (Cookies)response.getCookies().getReplace());
                this.outputList(numberOfSpacesToIndent, output, response.getCookies().getRemove());
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(")");
            }
        }
        return output.toString();
    }

    private void outputHeaders(int numberOfSpacesToIndent, StringBuffer output, Headers headers) {
        if (headers != null && !headers.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("headers(");
            this.appendObject(numberOfSpacesToIndent + 2, output, new HeaderToJavaSerializer(), headers.getEntries());
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("),");
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null,");
        }
    }

    private void outputCookies(int numberOfSpacesToIndent, StringBuffer output, Cookies cookies) {
        if (cookies != null && !cookies.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("cookies(");
            this.appendObject(numberOfSpacesToIndent + 2, output, new CookieToJavaSerializer(), cookies.getEntries());
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("),");
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null,");
        }
    }

    private void outputList(int numberOfSpacesToIndent, StringBuffer output, List<String> add) {
        if (add != null && !add.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("ImmutableList.of(").append(Joiner.on(",").join(add.stream().map(s2 -> "\"" + s2 + "\"").collect(Collectors.toList()))).append(")");
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null");
        }
    }

    private <T extends ObjectWithReflectiveEqualsHashCodeToString> void appendObject(int numberOfSpacesToIndent, StringBuffer output, MultiValueToJavaSerializer<T> toJavaSerializer, List<T> objects) {
        output.append(toJavaSerializer.serializeAsJava(numberOfSpacesToIndent + 1, objects));
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart("", numberOfSpacesToIndent, ' '));
    }
}

