/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.request;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.serialization.ObjectMapperFactory;

public class OpenAPIDefinitionSerializer
extends StdSerializer<OpenAPIDefinition> {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();

    public OpenAPIDefinitionSerializer() {
        super(OpenAPIDefinition.class);
    }

    @Override
    public void serialize(OpenAPIDefinition openAPIDefinition, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (openAPIDefinition.getNot() != null && openAPIDefinition.getNot().booleanValue()) {
            jgen.writeBooleanField("not", openAPIDefinition.getNot());
        }
        if (StringUtils.isNotBlank(openAPIDefinition.getOperationId())) {
            jgen.writeObjectField("operationId", openAPIDefinition.getOperationId());
        }
        if (StringUtils.isNotBlank(openAPIDefinition.getSpecUrlOrPayload())) {
            if (openAPIDefinition.getSpecUrlOrPayload().trim().startsWith("{")) {
                jgen.writeObjectField("specUrlOrPayload", OBJECT_MAPPER.readTree(openAPIDefinition.getSpecUrlOrPayload()));
            } else {
                jgen.writeObjectField("specUrlOrPayload", openAPIDefinition.getSpecUrlOrPayload());
            }
        }
        jgen.writeEndObject();
    }
}

