/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmlunit.XMLUnitException;
import org.xmlunit.builder.AbstractTransformationBuilder;
import org.xmlunit.builder.JaxbBuilder;
import org.xmlunit.builder.JaxbBuilderFactoryLocator;
import org.xmlunit.builder.TransformationBuilderBase;

public class Input {
    private Input() {
    }

    public static Builder fromDocument(Document d) {
        return new SourceHoldingBuilder(new DOMSource(d));
    }

    public static Builder fromNode(Node n) {
        return new SourceHoldingBuilder(new DOMSource(n));
    }

    public static Builder from(Object object) {
        Builder xml = object instanceof Source ? new SourceHoldingBuilder((Source)object) : (object instanceof Builder ? (Builder)object : (object instanceof Document ? Input.fromDocument((Document)object) : (object instanceof Node ? Input.fromNode((Node)object) : (object instanceof byte[] ? Input.fromByteArray((byte[])object) : (object instanceof String ? Input.fromString((String)object) : (object instanceof File ? Input.fromFile((File)object) : (object instanceof URL ? Input.fromURL((URL)object) : (object instanceof URI ? Input.fromURI((URI)object) : (object instanceof InputStream ? Input.fromStream((InputStream)object) : (object instanceof ReadableByteChannel ? Input.fromChannel((ReadableByteChannel)object) : (object instanceof Path ? Input.fromPath((Path)object) : Input.fromJaxb(object))))))))))));
        return xml;
    }

    public static JaxbBuilder fromJaxb(Object jaxbObject) {
        return JaxbBuilderFactoryLocator.getFactory().create(jaxbObject);
    }

    public static Builder fromFile(File f) {
        return new StreamBuilder(f);
    }

    public static Builder fromFile(String name) {
        return new StreamBuilder(new File(name));
    }

    public static Builder fromStream(InputStream s2) {
        return new StreamBuilder(s2);
    }

    public static Builder fromReader(Reader r) {
        return new StreamBuilder(r);
    }

    public static Builder fromString(String s2) {
        return new StreamBuilder(s2);
    }

    public static Builder fromByteArray(byte[] b) {
        return new StreamBuilder(b);
    }

    public static Builder fromChannel(ReadableByteChannel c) {
        return Input.fromStream(Channels.newInputStream(c));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Builder fromURL(URL url) {
        try (InputStream in = url.openStream();){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int read = -1;
            byte[] buf = new byte[4096];
            while ((read = in.read(buf)) >= 0) {
                if (read <= 0) continue;
                baos.write(buf, 0, read);
            }
            StreamBuilder b = (StreamBuilder)Input.fromByteArray(baos.toByteArray());
            try {
                b.setSystemId(url.toURI().toString());
            }
            catch (URISyntaxException use) {
                b.setSystemId(url.toString());
            }
            StreamBuilder streamBuilder = b;
            return streamBuilder;
        }
        catch (IOException ex) {
            throw new XMLUnitException(ex);
        }
    }

    public static Builder fromURI(URI uri) {
        try {
            return Input.fromURL(uri.toURL());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("uri " + uri + " is not an URL", ex);
        }
    }

    public static Builder fromURI(String uri) {
        try {
            return Input.fromURI(new URI(uri));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("uri " + uri + " is not an URI", ex);
        }
    }

    public static Builder fromPath(Path path) {
        return Input.fromURI(path.toUri());
    }

    public static TransformationBuilder byTransforming(Source s2) {
        return new Transformation(s2);
    }

    public static TransformationBuilder byTransforming(Builder b) {
        return Input.byTransforming(b.build());
    }

    private static class Transformation
    extends AbstractTransformationBuilder<TransformationBuilder>
    implements TransformationBuilder {
        private Transformation(Source s2) {
            super(s2);
        }

        @Override
        public TransformationBuilder withStylesheet(Builder b) {
            return (TransformationBuilder)this.withStylesheet(b.build());
        }

        @Override
        public Source build() {
            return new DOMSource(this.getHelper().transformToDocument());
        }
    }

    public static interface TransformationBuilder
    extends TransformationBuilderBase<TransformationBuilder>,
    Builder {
        public TransformationBuilder withStylesheet(Builder var1);
    }

    private static class StreamBuilder
    extends SourceHoldingBuilder {
        private StreamBuilder(File f) {
            super(new StreamSource(f));
        }

        private StreamBuilder(InputStream s2) {
            super(new StreamSource(s2));
        }

        private StreamBuilder(Reader r) {
            super(new StreamSource(r));
        }

        private StreamBuilder(final byte[] b) {
            super(new StreamSource(){

                @Override
                public InputStream getInputStream() {
                    return new ByteArrayInputStream(b);
                }
            });
        }

        private StreamBuilder(final String s2) {
            super(new StreamSource(){

                @Override
                public Reader getReader() {
                    return new StringReader(s2);
                }
            });
        }

        void setSystemId(String id) {
            if (id != null) {
                this.source.setSystemId(id);
            }
        }
    }

    private static class SourceHoldingBuilder
    implements Builder {
        protected final Source source;

        protected SourceHoldingBuilder(Source source) {
            this.source = source;
        }

        @Override
        public Source build() {
            assert (this.source != null);
            return this.source;
        }
    }

    public static interface Builder {
        public Source build();
    }
}

