/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard.serializers;

import org.apache.commons.lang3.StringUtils;
import org.mockserver.dashboard.serializers.Description;
import org.mockserver.dashboard.serializers.DescriptionProcessor;

public class RequestDefinitionDescription
implements Description {
    final String firstPart;
    final String secondPart;
    private final boolean openAPI;
    final int length;
    final DescriptionProcessor descriptionProcessor;

    public RequestDefinitionDescription(String firstPart, String secondPart, DescriptionProcessor descriptionProcessor, boolean openAPI) {
        this.openAPI = openAPI;
        if (firstPart.length() + secondPart.length() > 115) {
            if (secondPart.length() > firstPart.length()) {
                this.firstPart = firstPart;
                this.secondPart = StringUtils.abbreviate((String)secondPart, (int)(115 - firstPart.length()));
            } else {
                this.firstPart = StringUtils.abbreviate((String)firstPart, (int)(115 - secondPart.length()));
                this.secondPart = secondPart;
            }
        } else {
            this.firstPart = firstPart;
            this.secondPart = secondPart;
        }
        this.length = firstPart.length() + secondPart.length();
        this.descriptionProcessor = descriptionProcessor;
    }

    @Override
    public int length() {
        return this.length + 1;
    }

    @Override
    public String toObject() {
        return this.firstPart + StringUtils.repeat((String)" ", (int)((this.openAPI ? this.descriptionProcessor.getMaxOpenAPILength() : this.descriptionProcessor.getMaxHttpRequestLength()) - this.length + 1)) + this.secondPart;
    }
}

