/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import java.net.BindException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.mockserver.configuration.Configuration;
import org.mockserver.dashboard.DashboardHandler;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpState;
import org.mockserver.mock.action.http.HttpActionHandler;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.MediaType;
import org.mockserver.model.PortBinding;
import org.mockserver.model.RequestDefinition;
import org.mockserver.netty.proxy.connect.HttpConnectHandler;
import org.mockserver.netty.responsewriter.NettyResponseWriter;
import org.mockserver.netty.unification.PortUnificationHandler;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.serialization.Base64Converter;
import org.mockserver.serialization.PortBindingSerializer;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class HttpRequestHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    public static final AttributeKey<Boolean> PROXYING = AttributeKey.valueOf((String)"PROXYING");
    public static final AttributeKey<Set<String>> LOCAL_HOST_HEADERS = AttributeKey.valueOf((String)"LOCAL_HOST_HEADERS");
    private static final Base64Converter BASE_64_CONVERTER = new Base64Converter();
    private MockServerLogger mockServerLogger;
    private HttpState httpState;
    private PortBindingSerializer portBindingSerializer;
    private final Configuration configuration;
    private LifeCycle server;
    private HttpActionHandler httpActionHandler;
    private DashboardHandler dashboardHandler = new DashboardHandler();

    public HttpRequestHandler(Configuration configuration, LifeCycle server, HttpState httpState, HttpActionHandler httpActionHandler) {
        super(false);
        this.configuration = configuration;
        this.server = server;
        this.httpState = httpState;
        this.mockServerLogger = httpState.getMockServerLogger();
        this.portBindingSerializer = new PortBindingSerializer(this.mockServerLogger);
        this.httpActionHandler = httpActionHandler;
    }

    private static boolean isProxyingRequest(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel().attr(PROXYING).get() != null) {
            return (Boolean)ctx.channel().attr(PROXYING).get();
        }
        return false;
    }

    private static Set<String> getLocalAddresses(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel().attr(LOCAL_HOST_HEADERS) != null && ctx.channel().attr(LOCAL_HOST_HEADERS).get() != null) {
            return (Set)ctx.channel().attr(LOCAL_HOST_HEADERS).get();
        }
        return new HashSet<String>();
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        block19: {
            NettyResponseWriter responseWriter = new NettyResponseWriter(this.configuration, this.mockServerLogger, ctx, this.httpState.getScheduler());
            try {
                this.configuration.addSubjectAlternativeName(request.getFirstHeader(HttpHeaderNames.HOST.toString()));
                if (this.httpState.handle(request, (ResponseWriter)responseWriter, false)) break block19;
                if (request.matches("PUT", new String[]{"/mockserver/status", "/status"}) || StringUtils.isNotBlank((CharSequence)this.configuration.livenessHttpGetPath()) && request.matches("GET", new String[]{this.configuration.livenessHttpGetPath()})) {
                    responseWriter.writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(this.server.getLocalPorts())), "application/json");
                    break block19;
                }
                if (request.matches("PUT", new String[]{"/mockserver/bind", "/bind"})) {
                    PortBinding requestedPortBindings = this.portBindingSerializer.deserialize(request.getBodyAsString());
                    if (requestedPortBindings == null) break block19;
                    try {
                        List<Integer> actualPortBindings = this.server.bindServerPorts(requestedPortBindings.getPorts());
                        responseWriter.writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                        break block19;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof BindException) {
                            responseWriter.writeResponse(request, HttpResponseStatus.BAD_REQUEST, e.getMessage() + " port already in use", MediaType.create((String)"text", (String)"plain").toString());
                            break block19;
                        }
                        throw e;
                    }
                }
                if (request.matches("PUT", new String[]{"/mockserver/stop", "/stop"})) {
                    ctx.writeAndFlush((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.OK.code())));
                    new Scheduler.SchedulerThreadFactory("MockServer Stop").newThread(() -> this.server.stop()).start();
                } else if (request.getMethod().getValue().equals("GET") && request.getPath().getValue().startsWith("/mockserver/dashboard")) {
                    this.dashboardHandler.renderDashboard(ctx, request);
                } else if (request.getMethod().getValue().equals("CONNECT")) {
                    String username = this.configuration.proxyAuthenticationUsername();
                    String password = this.configuration.proxyAuthenticationPassword();
                    if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password) && !request.containsHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString(), "Basic " + BASE_64_CONVERTER.bytesToBase64String((username + ':' + password).getBytes(StandardCharsets.UTF_8), StandardCharsets.US_ASCII))) {
                        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED.code())).withHeader(HttpHeaderNames.PROXY_AUTHENTICATE.toString(), new String[]{"Basic realm=\"" + StringEscapeUtils.escapeJava((String)this.configuration.proxyAuthenticationRealm()) + "\", charset=\"UTF-8\""});
                        ctx.writeAndFlush((Object)response);
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.AUTHENTICATION_FAILED).setLogLevel(Level.INFO).setCorrelationId(request.getLogCorrelationId()).setHttpRequest((RequestDefinition)request).setHttpResponse(response).setExpectation((RequestDefinition)request, response).setMessageFormat("proxy authentication failed so returning response:{}for forwarded request:{}").setArguments(new Object[]{response, request}));
                    } else {
                        String[] hostParts;
                        ctx.channel().attr(PROXYING).set((Object)Boolean.TRUE);
                        PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
                        if (StringUtils.isNotBlank((CharSequence)request.getPath().getValue())) {
                            this.server.getScheduler().submit(() -> this.configuration.addSubjectAlternativeName(request.getPath().getValue()));
                        }
                        int port = (hostParts = request.getPath().getValue().split(":")).length > 1 ? Integer.parseInt(hostParts[1]) : (PortUnificationHandler.isSslEnabledUpstream(ctx.channel()) ? 443 : 80);
                        ctx.pipeline().addLast(new ChannelHandler[]{new HttpConnectHandler(this.configuration, this.server, this.mockServerLogger, hostParts[0], port)});
                        ctx.pipeline().remove((ChannelHandler)this);
                        ctx.fireChannelRead((Object)request);
                    }
                } else {
                    try {
                        this.httpActionHandler.processAction(request, (ResponseWriter)responseWriter, ctx, HttpRequestHandler.getLocalAddresses(ctx), HttpRequestHandler.isProxyingRequest(ctx), false);
                    }
                    catch (Throwable throwable) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setHttpRequest((RequestDefinition)request).setMessageFormat("exception processing request:{}error:{}").setArguments(new Object[]{request, throwable.getMessage()}).setThrowable(throwable));
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setHttpRequest((RequestDefinition)request).setMessageFormat("exception processing request:{}error:{}").setArguments(new Object[]{request, iae.getMessage()}));
                responseWriter.writeResponse(request, HttpResponseStatus.BAD_REQUEST, iae.getMessage(), MediaType.create((String)"text", (String)"plain").toString());
            }
            catch (Exception ex) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setHttpRequest((RequestDefinition)request).setMessageFormat("exception processing " + request).setThrowable((Throwable)ex));
                responseWriter.writeResponse(request, HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.BAD_REQUEST.code())).withBody(ex.getMessage()), true);
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException((Throwable)cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception caught by " + this.server.getClass() + " handler -> closing pipeline " + ctx.channel()).setThrowable(cause));
        }
        ExceptionHandling.closeOnFlush((Channel)ctx.channel());
    }
}

