/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.relay;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.Future;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.mockserver.MockServerHandler;
import org.mockserver.proxy.relay.DownstreamProxyRelayHandler;
import org.mockserver.proxy.relay.UpstreamProxyRelayHandler;
import org.mockserver.socket.NettySslContextFactory;
import org.mockserver.unification.PortUnificationHandler;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public abstract class RelayConnectHandler<T>
extends SimpleChannelInboundHandler<T> {
    public static final AttributeKey<List<Future<Channel>>> HTTP_CONNECT_SOCKET = AttributeKey.valueOf((String)"HTTP_CONNECT_SOCKET");
    private final LifeCycle server;
    private final MockServerLogger mockServerLogger;
    private final String host;
    private final int port;

    public RelayConnectHandler(LifeCycle server, MockServerLogger mockServerLogger, String host, int port) {
        this.server = server;
        this.mockServerLogger = mockServerLogger;
        this.host = host;
        this.port = port;
    }

    public void channelRead0(final ChannelHandlerContext serverCtx, final T request) throws Exception {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)serverCtx.channel().eventLoop())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(final ChannelHandlerContext clientCtx) throws Exception {
                serverCtx.channel().writeAndFlush(RelayConnectHandler.this.successResponse(request)).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        RelayConnectHandler.this.removeCodecSupport(serverCtx);
                        serverCtx.channel().attr(MockServerHandler.PROXYING).set((Object)Boolean.TRUE);
                        ChannelPipeline downstreamPipeline = clientCtx.channel().pipeline();
                        if (PortUnificationHandler.isSslEnabledDownstream(serverCtx.channel())) {
                            downstreamPipeline.addLast(new ChannelHandler[]{NettySslContextFactory.nettySslContextFactory().createClientSslContext().newHandler(clientCtx.alloc(), RelayConnectHandler.this.host, RelayConnectHandler.this.port)});
                        }
                        if (RelayConnectHandler.this.mockServerLogger.isEnabled(Level.TRACE)) {
                            downstreamPipeline.addLast(new ChannelHandler[]{new LoggingHandler("downstream                -->")});
                        }
                        downstreamPipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                        downstreamPipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                        downstreamPipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                        downstreamPipeline.addLast(new ChannelHandler[]{new DownstreamProxyRelayHandler(RelayConnectHandler.this.mockServerLogger, serverCtx.channel())});
                        ChannelPipeline upstreamPipeline = serverCtx.channel().pipeline();
                        if (PortUnificationHandler.isSslEnabledUpstream(serverCtx.channel())) {
                            upstreamPipeline.addLast(new ChannelHandler[]{NettySslContextFactory.nettySslContextFactory().createServerSslContext().newHandler(serverCtx.alloc())});
                        }
                        if (RelayConnectHandler.this.mockServerLogger.isEnabled(Level.TRACE)) {
                            upstreamPipeline.addLast(new ChannelHandler[]{new LoggingHandler("upstream <-- ")});
                        }
                        upstreamPipeline.addLast(new ChannelHandler[]{new HttpServerCodec(8192, 8192, 8192)});
                        upstreamPipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                        upstreamPipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                        upstreamPipeline.addLast(new ChannelHandler[]{new UpstreamProxyRelayHandler(RelayConnectHandler.this.mockServerLogger, serverCtx.channel(), clientCtx.channel())});
                    }
                });
            }
        });
        final InetSocketAddress remoteSocket = this.getDownstreamSocket(serverCtx.channel());
        bootstrap.connect((SocketAddress)remoteSocket).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    RelayConnectHandler.this.failure("Connection failed to " + remoteSocket, future.cause(), serverCtx, RelayConnectHandler.this.failureResponse(request));
                }
            }
        });
    }

    private InetSocketAddress getDownstreamSocket(Channel channel) {
        if (channel.attr(ActionHandler.REMOTE_SOCKET).get() != null) {
            return (InetSocketAddress)channel.attr(ActionHandler.REMOTE_SOCKET).get();
        }
        return new InetSocketAddress(this.server.getLocalPort());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.failure("Exception caught by CONNECT proxy handler -> closing pipeline ", cause, ctx, this.failureResponse(null));
    }

    private void failure(String message, Throwable cause, ChannelHandlerContext ctx, Object response) {
        if (ExceptionHandler.shouldNotIgnoreException(cause)) {
            this.mockServerLogger.error(message, cause);
        }
        Channel channel = ctx.channel();
        channel.writeAndFlush(response);
        if (channel.isActive()) {
            channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    protected abstract void removeCodecSupport(ChannelHandlerContext var1);

    protected abstract Object successResponse(Object var1);

    protected abstract Object failureResponse(Object var1);

    protected void removeHandler(ChannelPipeline pipeline, Class<? extends ChannelHandler> handlerType) {
        if (pipeline.get(handlerType) != null) {
            pipeline.remove(handlerType);
        }
    }

    protected void removeHandler(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.toMap().containsValue(channelHandler)) {
            pipeline.remove(channelHandler);
        }
    }
}

