/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.log.model.LogEntry;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithJsonToString;
import org.slf4j.event.Level;

public class LogEntryDTO
extends ObjectWithJsonToString {
    private static final String[] EXCLUDED_FIELDS = new String[]{"key", "timestamp", "message", "throwable"};
    private String key;
    private Level logLevel;
    private long epochTime;
    private String timestamp;
    private LogEntry.LogMessageType type;
    private HttpRequest[] httpRequests;
    private HttpResponse httpResponse;
    private HttpError httpError;
    private Expectation expectation;
    private Throwable throwable;
    private String messageFormat;
    private Object[] arguments;
    private String message;

    public LogEntryDTO(LogEntry logEntry) {
        this.setKey(logEntry.key());
        this.setLogLevel(logEntry.getLogLevel());
        this.setTimestamp(logEntry.getTimestamp());
        this.setEpochTime(logEntry.getEpochTime());
        this.setType(logEntry.getType());
        this.setHttpRequests(logEntry.getHttpRequests());
        this.setHttpResponse(logEntry.getHttpResponse());
        this.setHttpError(logEntry.getHttpError());
        this.setExpectation(logEntry.getExpectation());
        this.setMessageFormat(logEntry.getMessageFormat());
        this.setArguments(logEntry.getArguments());
        this.setMessage(logEntry.getMessage());
        this.setThrowable(logEntry.getThrowable());
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public LogEntryDTO setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public long getEpochTime() {
        return this.epochTime;
    }

    public LogEntryDTO setEpochTime(long epochTime) {
        this.epochTime = epochTime;
        return this;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public LogEntry.LogMessageType getType() {
        return this.type;
    }

    public LogEntryDTO setType(LogEntry.LogMessageType type) {
        this.type = type;
        return this;
    }

    @JsonIgnore
    public HttpRequest[] getHttpRequests() {
        return this.httpRequests;
    }

    public LogEntryDTO setHttpRequests(HttpRequest[] httpRequests) {
        this.httpRequests = httpRequests;
        return this;
    }

    public LogEntryDTO setHttpRequest(HttpRequest httpRequest) {
        this.httpRequests = httpRequest != null ? new HttpRequest[]{httpRequest} : new HttpRequest[]{HttpRequest.request()};
        return this;
    }

    public HttpRequest getHttpRequest() {
        if (this.httpRequests != null && this.httpRequests.length > 0) {
            return this.httpRequests[0];
        }
        return null;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public LogEntryDTO setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public HttpError getHttpError() {
        return this.httpError;
    }

    public LogEntryDTO setHttpError(HttpError httpError) {
        this.httpError = httpError;
        return this;
    }

    public Expectation getExpectation() {
        return this.expectation;
    }

    public LogEntryDTO setExpectation(Expectation expectation) {
        this.expectation = expectation;
        return this;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public LogEntryDTO setThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public LogEntryDTO setMessageFormat(String messageFormat) {
        this.messageFormat = messageFormat;
        return this;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public LogEntryDTO setArguments(Object ... arguments) {
        this.arguments = arguments;
        return this;
    }

    @JsonIgnore
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

