/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.relay;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.mockserver.unification.PortUnificationHandler;
import org.slf4j.event.Level;

public class UpstreamProxyRelayHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final MockServerLogger mockServerLogger;
    private volatile Channel upstreamChannel;
    private volatile Channel downstreamChannel;

    public UpstreamProxyRelayHandler(MockServerLogger mockServerLogger, Channel upstreamChannel, Channel downstreamChannel) {
        super(false);
        this.upstreamChannel = upstreamChannel;
        this.downstreamChannel = downstreamChannel;
        this.mockServerLogger = mockServerLogger;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
        ctx.write((Object)Unpooled.EMPTY_BUFFER);
    }

    public void channelRead0(final ChannelHandlerContext ctx, final FullHttpRequest request) {
        if (PortUnificationHandler.isSslEnabledDownstream(this.upstreamChannel) && this.downstreamChannel.pipeline().get(SslHandler.class) == null) {
            this.downstreamChannel.pipeline().addFirst(new ChannelHandler[]{new NettySslContextFactory(this.mockServerLogger).createClientSslContext().newHandler(ctx.alloc())});
        }
        this.downstreamChannel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    ctx.channel().read();
                } else {
                    if (UpstreamProxyRelayHandler.this.isNotSocketClosedException(future.cause())) {
                        UpstreamProxyRelayHandler.this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception while returning response for request \"" + request.method() + " " + request.uri() + "\"").setThrowable(future.cause()));
                    }
                    future.channel().close();
                }
            }
        });
    }

    private boolean isNotSocketClosedException(Throwable cause) {
        return !(cause instanceof ClosedChannelException) && !(cause instanceof ClosedSelectorException);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ExceptionHandler.closeOnFlush(this.downstreamChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandler.shouldNotIgnoreException(cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception caught by upstream relay handler -> closing pipeline " + ctx.channel()).setThrowable(cause));
        }
        ExceptionHandler.closeOnFlush(ctx.channel());
    }
}

