/*
 * Copyright 2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mockftpserver.core.session;

/**
 * Constants for names of properties (attributes) stored in the session.
 */
public class SessionKeys {

    public static final String USERNAME = "username";
    public static final String USER_ACCOUNT = "userAccount";
    public static final String CURRENT_DIRECTORY = "currentDirectory";
    public static final String RENAME_FROM = "renameFrom";
    public static final String ACCOUNT_NAME = "accountName";
    public static final String ASCII_TYPE = "asciiType";

}