/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.command;

import java.util.List;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.util.StringUtil;
import org.mockftpserver.fake.command.AbstractFakeCommandHandler;

public class NlstCommandHandler
extends AbstractFakeCommandHandler {
    protected void handle(Command command, Session session) {
        this.verifyLoggedIn(session);
        String path = this.getRealPath(session, command.getParameter(0));
        if (this.getFileSystem().exists(path)) {
            this.replyCodeForFileSystemException = 550;
            this.verifyReadPermission(session, path);
        }
        this.replyCodeForFileSystemException = 451;
        List names = this.getFileSystem().listNames(path);
        String directoryListing = StringUtil.join(names, this.endOfLine());
        directoryListing = directoryListing + (directoryListing.length() > 0 ? this.endOfLine() : "");
        this.sendReply(session, 150);
        session.openDataConnection();
        session.sendData(directoryListing.getBytes(), directoryListing.length());
        session.closeDataConnection();
        this.sendReply(session, 226);
    }
}

