/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.command;

import java.util.Collections;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.fake.command.AbstractFakeCommandHandler;
import org.mockftpserver.fake.filesystem.FileEntry;
import org.mockftpserver.fake.filesystem.FileSystemEntry;

public class SizeCommandHandler
extends AbstractFakeCommandHandler {
    @Override
    protected void handle(Command command, Session session) {
        this.verifyLoggedIn(session);
        String path = this.getRealPath(session, command.getRequiredParameter(0));
        FileSystemEntry entry = this.getFileSystem().getEntry(path);
        this.verifyFileSystemCondition(entry != null, path, "filesystem.doesNotExist");
        this.verifyFileSystemCondition(!entry.isDirectory(), path, "filesystem.doesNotExist");
        this.verifyReadPermission(session, path);
        this.verifyExecutePermission(session, this.getFileSystem().getParent(path));
        FileEntry fileEntry = (FileEntry)entry;
        String size = String.valueOf(fileEntry.getSize());
        this.sendReply(session, 213, "size", Collections.singletonList(size));
    }
}

