/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.android.internal.creation;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;

class AndroidTempFileLocator {
    static final File target;

    AndroidTempFileLocator() {
    }

    private static File[] guessPath(String input) {
        ArrayList<File> results = new ArrayList<File>();
        for (String potential : AndroidTempFileLocator.splitPathList(input)) {
            File cacheDir;
            if (!potential.startsWith("/data/app/")) continue;
            int start = "/data/app/".length();
            int end = potential.lastIndexOf(".apk");
            if (end != potential.length() - 4) continue;
            int dash = potential.indexOf("-");
            if (dash != -1) {
                end = dash;
            }
            String packageName = potential.substring(start, end);
            File dataDir = new File("/data/data/" + packageName);
            if (!AndroidTempFileLocator.isWriteableDirectory(dataDir) || !AndroidTempFileLocator.fileOrDirExists(cacheDir = new File(dataDir, "cache")) && !cacheDir.mkdir() || !AndroidTempFileLocator.isWriteableDirectory(cacheDir)) continue;
            results.add(cacheDir);
        }
        return results.toArray(new File[results.size()]);
    }

    private static String[] splitPathList(String input) {
        String trimmed = input;
        if (input.startsWith("dexPath=")) {
            int start = "dexPath=".length();
            int end = input.indexOf(44);
            trimmed = end == -1 ? input.substring(start) : input.substring(start, end);
        }
        return trimmed.split(":");
    }

    private static boolean fileOrDirExists(File file) {
        return file.exists();
    }

    private static boolean isWriteableDirectory(File file) {
        return file.isDirectory() && file.canWrite();
    }

    static {
        Class<?> clazz2;
        File t = null;
        try {
            String user = System.getProperty("org.mockito.android.target");
            if (user != null) {
                t = new File(user);
            }
        }
        catch (Throwable user) {
            // empty catch block
        }
        if (t == null) {
            try {
                clazz2 = Class.forName("android.support.test.InstrumentationRegistry");
                Object context = clazz2.getDeclaredMethod("getTargetContext", new Class[0]).invoke(clazz2, new Object[0]);
                t = (File)context.getClass().getMethod("getCacheDir", new Class[0]).invoke(context, new Object[0]);
            }
            catch (Throwable clazz2) {
                // empty catch block
            }
        }
        if (t == null) {
            try {
                clazz2 = Class.forName("dalvik.system.PathClassLoader");
                Field pathField = clazz2.getDeclaredField("path");
                pathField.setAccessible(true);
                String pathFromThisClassLoader = (String)pathField.get(AndroidTempFileLocator.class.getClassLoader());
                File[] results = AndroidTempFileLocator.guessPath(pathFromThisClassLoader);
                if (results.length > 0) {
                    t = results[0];
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        target = t;
    }
}

